/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.content.blast.cluster;

import icbm.classic.api.ICBMClassicAPI;
import icbm.classic.api.explosion.BlastState;
import icbm.classic.api.explosion.IBlastInit;
import icbm.classic.api.explosion.responses.BlastForgeResponses;
import icbm.classic.api.explosion.responses.BlastResponse;
import icbm.classic.api.missiles.projectile.IProjectileData;
import icbm.classic.content.blast.cluster.bomblet.EntityBombDroplet;
import icbm.classic.content.blast.imp.BlastBase;
import icbm.classic.content.reg.ItemReg;
import icbm.classic.lib.transform.RotationHelper;
import java.util.function.Function;
import lombok.Generated;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;

public class BlastCluster
extends BlastBase {
    private static final Vec3d SOUTH_VEC = new Vec3d(0.0, 0.0, 1.0);
    private static final Vec3d UP_VEC = new Vec3d(0.0, 1.0, 0.0);
    private static final float stackScale = 0.1f;
    private static final float offsetScale = 0.25f;
    private Function<Integer, IProjectileData> projectileBuilder;
    private boolean allowPickupItem = true;
    private float ejectionScale = 0.3f;
    private int projectilesToSpawn = 0;
    private int projectilesPerLayer = 10;
    private float motionPitchOffset = -22.5f;
    private float discYawOffset = 22.5f;
    private float motionScale = 0.3f;
    private float motionScaleLayer = 0.1f;
    private float motionRandomScale = 0.1f;
    private float sourceYaw = 0.0f;
    private float sourcePitch = 0.0f;
    private Entity source;

    @Override
    public IBlastInit setBlastSource(Entity entity) {
        this.source = entity;
        this.sourceYaw = entity.field_70177_z;
        this.sourcePitch = entity.field_70125_A;
        return this;
    }

    @Override
    protected BlastResponse triggerBlast() {
        if (!this.world().field_72995_K) {
            boolean spawnedSomething = this.spawnEmptyMissile();
            float yawAmount = 360.0f / (float)this.projectilesPerLayer;
            int bombsToFire = this.projectilesToSpawn;
            int discIndex = 0;
            while (bombsToFire > 0) {
                for (int bombIndex = 0; bombIndex < this.projectilesPerLayer && bombsToFire > 0; ++bombIndex) {
                    --bombsToFire;
                    double yaw = MathHelper.func_76142_g((float)(yawAmount * (float)bombIndex + (float)discIndex * this.discYawOffset));
                    Vec3d offsetYaw = RotationHelper.rotateY(SOUTH_VEC, yaw);
                    Vec3d sourceVec = RotationHelper.rotateY(RotationHelper.rotateX(offsetYaw, this.sourcePitch - 90.0f), this.sourceYaw);
                    Vec3d backVector = RotationHelper.rotateX(UP_VEC, this.motionPitchOffset);
                    double motionX = (sourceVec.field_72450_a + backVector.field_72450_a) * (double)this.motionScale;
                    double motionY = (sourceVec.field_72448_b + backVector.field_72448_b) * (double)this.motionScale;
                    double motionZ = (sourceVec.field_72449_c + backVector.field_72449_c) * (double)this.motionScale;
                    motionX += (sourceVec.field_72450_a + backVector.field_72450_a) * (double)this.motionScaleLayer * (double)discIndex;
                    motionY += (sourceVec.field_72448_b + backVector.field_72448_b) * (double)this.motionScaleLayer * (double)discIndex;
                    motionZ += (sourceVec.field_72449_c + backVector.field_72449_c) * (double)this.motionScaleLayer * (double)discIndex;
                    if (this.motionRandomScale > 0.0f) {
                        motionX += (double)((this.world().field_73012_v.nextFloat() - this.world().field_73012_v.nextFloat()) * this.motionScaleLayer);
                        motionY += (double)((this.world().field_73012_v.nextFloat() - this.world().field_73012_v.nextFloat()) * this.motionScaleLayer);
                        motionZ += (double)((this.world().field_73012_v.nextFloat() - this.world().field_73012_v.nextFloat()) * this.motionScaleLayer);
                    }
                    Vec3d stackVector = RotationHelper.rotateY(RotationHelper.rotateX(SOUTH_VEC, this.sourcePitch - 180.0f), this.sourceYaw);
                    double x = sourceVec.field_72450_a * 0.25 + stackVector.field_72450_a * (double)0.1f * (double)discIndex;
                    double y = sourceVec.field_72448_b * 0.25 + stackVector.field_72448_b * (double)0.1f * (double)discIndex;
                    double z = sourceVec.field_72449_c * 0.25 + stackVector.field_72449_c * (double)0.1f * (double)discIndex;
                    spawnedSomething = this.spawnProjectile(bombsToFire, x, y, z, motionX, motionY, motionZ) || spawnedSomething;
                }
                ++discIndex;
            }
            return spawnedSomething ? BlastState.TRIGGERED.genericResponse : BlastForgeResponses.ENTITY_SPAWNING.get();
        }
        return BlastState.TRIGGERED.genericResponse;
    }

    private boolean spawnProjectile(int index, double x, double y, double z, double mx, double my, double mz) {
        IProjectileData data;
        IProjectileData iProjectileData = data = this.projectileBuilder != null ? this.projectileBuilder.apply(index) : null;
        if (data != null) {
            Entity entity = ICBMClassicAPI.PROJECTILE_DATA_REGISTRY.spawnProjectile(data, this.world(), this.x() + x, this.y() + y, this.z() + z, this.source, this.allowPickupItem, newEntity -> {
                newEntity.func_70107_b(this.x() + x, this.y() + y, this.z() + z);
                newEntity.field_70159_w = mx;
                newEntity.field_70181_x = my;
                newEntity.field_70179_y = mz;
                float f3 = MathHelper.func_76133_a((double)(newEntity.field_70159_w * newEntity.field_70159_w + newEntity.field_70179_y * newEntity.field_70179_y));
                newEntity.field_70126_B = newEntity.field_70177_z = (float)(Math.atan2(newEntity.field_70159_w, newEntity.field_70179_y) * 180.0 / Math.PI);
                newEntity.field_70127_C = newEntity.field_70125_A = (float)(Math.atan2(newEntity.field_70181_x, f3) * 180.0 / Math.PI);
            });
            return entity != null;
        }
        return false;
    }

    private boolean spawnEmptyMissile() {
        EntityBombDroplet bomblet = new EntityBombDroplet(this.world());
        bomblet.explosive.setStack(new ItemStack(ItemReg.itemBomblet));
        bomblet.func_70107_b(this.x(), this.y(), this.z());
        bomblet.initAimingPosition(this.x(), this.y(), this.z(), this.sourceYaw, this.sourcePitch, 0.0f, 0.03f);
        return this.world().func_72838_d((Entity)bomblet);
    }

    @Generated
    public Function<Integer, IProjectileData> getProjectileBuilder() {
        return this.projectileBuilder;
    }

    @Generated
    public void setProjectileBuilder(Function<Integer, IProjectileData> projectileBuilder) {
        this.projectileBuilder = projectileBuilder;
    }

    @Generated
    public boolean isAllowPickupItem() {
        return this.allowPickupItem;
    }

    @Generated
    public void setAllowPickupItem(boolean allowPickupItem) {
        this.allowPickupItem = allowPickupItem;
    }

    @Generated
    public float getEjectionScale() {
        return this.ejectionScale;
    }

    @Generated
    public void setEjectionScale(float ejectionScale) {
        this.ejectionScale = ejectionScale;
    }

    @Generated
    public int getProjectilesToSpawn() {
        return this.projectilesToSpawn;
    }

    @Generated
    public void setProjectilesToSpawn(int projectilesToSpawn) {
        this.projectilesToSpawn = projectilesToSpawn;
    }

    @Generated
    public int getProjectilesPerLayer() {
        return this.projectilesPerLayer;
    }

    @Generated
    public void setProjectilesPerLayer(int projectilesPerLayer) {
        this.projectilesPerLayer = projectilesPerLayer;
    }

    @Generated
    public float getMotionPitchOffset() {
        return this.motionPitchOffset;
    }

    @Generated
    public void setMotionPitchOffset(float motionPitchOffset) {
        this.motionPitchOffset = motionPitchOffset;
    }

    @Generated
    public float getDiscYawOffset() {
        return this.discYawOffset;
    }

    @Generated
    public void setDiscYawOffset(float discYawOffset) {
        this.discYawOffset = discYawOffset;
    }

    @Generated
    public float getMotionScale() {
        return this.motionScale;
    }

    @Generated
    public void setMotionScale(float motionScale) {
        this.motionScale = motionScale;
    }

    @Generated
    public float getMotionScaleLayer() {
        return this.motionScaleLayer;
    }

    @Generated
    public void setMotionScaleLayer(float motionScaleLayer) {
        this.motionScaleLayer = motionScaleLayer;
    }

    @Generated
    public float getMotionRandomScale() {
        return this.motionRandomScale;
    }

    @Generated
    public void setMotionRandomScale(float motionRandomScale) {
        this.motionRandomScale = motionRandomScale;
    }

    @Generated
    public float getSourceYaw() {
        return this.sourceYaw;
    }

    @Generated
    public void setSourceYaw(float sourceYaw) {
        this.sourceYaw = sourceYaw;
    }

    @Generated
    public float getSourcePitch() {
        return this.sourcePitch;
    }

    @Generated
    public void setSourcePitch(float sourcePitch) {
        this.sourcePitch = sourcePitch;
    }
}

