/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.content.blast.cluster.bomblet;

import icbm.classic.api.ICBMClassicAPI;
import icbm.classic.api.reg.IExplosiveData;
import icbm.classic.lib.capability.ex.CapabilityExplosiveEntity;
import icbm.classic.lib.projectile.EntityProjectile;
import icbm.classic.lib.saving.NbtSaveHandler;
import icbm.classic.lib.saving.NbtSaveNode;
import io.netty.buffer.ByteBuf;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityBombDroplet
extends EntityProjectile<EntityBombDroplet>
implements IEntityAdditionalSpawnData {
    public final CapabilityExplosiveEntity explosive = new CapabilityExplosiveEntity(this);
    private static final NbtSaveHandler<EntityBombDroplet> SAVE_LOGIC = new NbtSaveHandler().mainRoot().node(new NbtSaveNode<EntityBombDroplet, NBTTagCompound>("explosive", missile -> missile.explosive.serializeNBT(), (missile, data) -> missile.explosive.deserializeNBT((NBTTagCompound)data))).base();

    public EntityBombDroplet(World world) {
        super(world);
        this.func_70105_a(0.25f, 0.25f);
        this.hasHealth = false;
    }

    @Override
    protected void onImpact(Vec3d impactLocation) {
        super.onImpact(impactLocation);
        this.explosive.doExplosion(impactLocation);
    }

    public Vec3d func_70676_i(float partialTicks) {
        double mag = Math.sqrt(this.field_70159_w * this.field_70159_w + this.field_70181_x * this.field_70181_x + this.field_70179_y * this.field_70179_y);
        return new Vec3d(this.field_70159_w / mag, this.field_70181_x / mag, this.field_70179_y / mag);
    }

    @Override
    protected boolean shouldCollideWith(Entity entity) {
        return super.shouldCollideWith(entity) && !(entity instanceof EntityBombDroplet);
    }

    @Override
    public float getMaxHealth() {
        return 5.0f;
    }

    @Override
    protected void onDestroyedBy(DamageSource source, float damage) {
        super.onDestroyedBy(source, damage);
        if (source.func_94541_c() || source.func_76347_k()) {
            this.explosive.doExplosion(this.func_174791_d());
        }
    }

    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == ICBMClassicAPI.EXPLOSIVE_CAPABILITY) {
            return (T)ICBMClassicAPI.EXPLOSIVE_CAPABILITY.cast((Object)this.explosive);
        }
        return (T)super.getCapability(capability, facing);
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == ICBMClassicAPI.EXPLOSIVE_CAPABILITY || super.hasCapability(capability, facing);
    }

    public String func_70005_c_() {
        IExplosiveData data = this.explosive.getExplosiveData();
        if (data != null) {
            return I18n.func_74838_a((String)("bomb.droplet." + data.getRegistryName().toString() + ".name"));
        }
        return I18n.func_74838_a((String)"bomb.droplet.icbmclassic:generic.name");
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_70112_a(double distance) {
        double d0 = this.func_174813_aQ().func_72320_b() * 10.0;
        if (Double.isNaN(d0)) {
            d0 = 1.0;
        }
        return distance < (d0 = d0 * 64.0 * EntityBombDroplet.func_184183_bd()) * d0;
    }

    @Override
    public void writeSpawnData(ByteBuf additionalMissileData) {
        super.writeSpawnData(additionalMissileData);
        NBTTagCompound saveData = SAVE_LOGIC.save(this, new NBTTagCompound());
        ByteBufUtils.writeTag((ByteBuf)additionalMissileData, (NBTTagCompound)saveData);
    }

    @Override
    public void readSpawnData(ByteBuf additionalMissileData) {
        super.readSpawnData(additionalMissileData);
        NBTTagCompound saveData = ByteBufUtils.readTag((ByteBuf)additionalMissileData);
        SAVE_LOGIC.load(this, saveData);
    }

    @Override
    public void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        SAVE_LOGIC.load(this, nbt);
    }

    @Override
    public void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        SAVE_LOGIC.save(this, nbt);
    }

    public ItemStack toStack() {
        return this.explosive.toStack();
    }
}

