/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.content.blocks.launcher.base;

import icbm.classic.api.ICBMClassicAPI;
import icbm.classic.api.ICBMClassicHelpers;
import icbm.classic.api.caps.IMissileHolder;
import icbm.classic.config.ConfigMain;
import icbm.classic.config.machines.ConfigLauncher;
import icbm.classic.content.blocks.launcher.FiringPackage;
import icbm.classic.content.blocks.launcher.base.BlockLauncherBase;
import icbm.classic.content.blocks.launcher.base.LauncherCapability;
import icbm.classic.content.blocks.launcher.base.gui.ContainerLaunchBase;
import icbm.classic.content.blocks.launcher.base.gui.GuiLauncherBase;
import icbm.classic.content.blocks.launcher.network.ILauncherComponent;
import icbm.classic.content.blocks.launcher.network.LauncherNode;
import icbm.classic.content.entity.EntityPlayerSeat;
import icbm.classic.content.missile.entity.EntityMissile;
import icbm.classic.lib.capability.launcher.CapabilityMissileHolder;
import icbm.classic.lib.data.IMachineInfo;
import icbm.classic.lib.energy.storage.EnergyBuffer;
import icbm.classic.lib.energy.system.EnergySystem;
import icbm.classic.lib.network.lambda.PacketCodexReg;
import icbm.classic.lib.network.lambda.tile.PacketCodexTile;
import icbm.classic.lib.saving.NbtSaveHandler;
import icbm.classic.lib.tile.TickAction;
import icbm.classic.lib.tile.TickDoOnce;
import icbm.classic.prefab.gui.IPlayerUsing;
import icbm.classic.prefab.inventory.InventorySlot;
import icbm.classic.prefab.inventory.InventoryWithSlots;
import icbm.classic.prefab.tile.IGuiTile;
import icbm.classic.prefab.tile.TileMachine;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.function.BiConsumer;
import javax.annotation.Nullable;
import lombok.Generated;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;

public class TileLauncherBase
extends TileMachine
implements ILauncherComponent,
IMachineInfo,
IGuiTile,
IPlayerUsing {
    public static final ResourceLocation REGISTRY_NAME = new ResourceLocation("icbmclassic", "launcherbase");
    public EntityPlayerSeat seat;
    protected boolean checkMissileCollision = true;
    private boolean hasMissileCollision = false;
    public final EnergyBuffer energyStorage = new EnergyBuffer(() -> ConfigLauncher.POWER_CAPACITY).withOnChange((p, c, s) -> this.func_70296_d());
    public final InventoryWithSlots inventory = new InventoryWithSlots(2).withChangeCallback((s, i) -> this.func_70296_d()).withSlot(new InventorySlot(0, ICBMClassicHelpers::isMissile).withInsertCheck(s -> !this.checkForMissileInBounds()).withChangeCallback(stack -> this.func_70296_d())).withSlot(new InventorySlot(1, EnergySystem::isEnergyItem).withTick(this.energyStorage::dischargeItem));
    public ItemStack cachedMissileStack;
    public final IMissileHolder missileHolder = new CapabilityMissileHolder((IItemHandlerModifiable)this.inventory, 0);
    public final LauncherCapability missileLauncher = new LauncherCapability(this);
    private final LauncherNode launcherNode = new LauncherNode(this, true);
    private int firingDelay = 0;
    private int lockHeight = 3;
    private int groupId = -1;
    private int groupIndex = -1;
    private EnumFacing seatSide = null;
    private FiringPackage firingPackage;
    private final TickDoOnce descriptionPacketSender = new TickDoOnce(t -> PACKET_DESCRIPTION.sendToAllAround(this));
    private final List<EntityPlayer> playersUsing = new LinkedList<EntityPlayer>();
    private static final NbtSaveHandler<TileLauncherBase> SAVE_LOGIC = new NbtSaveHandler().mainRoot().nodeInteger("lock_height", TileLauncherBase::getLockHeight, TileLauncherBase::setLockHeight).nodeInteger("group_id", TileLauncherBase::getGroupId, TileLauncherBase::setGroupId).nodeInteger("group_index", TileLauncherBase::getGroupIndex, TileLauncherBase::setGroupIndex).nodeInteger("firing_delay", TileLauncherBase::getFiringDelay, TileLauncherBase::setFiringDelay).nodeInteger("energy", tile -> tile.energyStorage.getEnergyStored(), (tile, i) -> tile.energyStorage.setEnergyStored((int)i)).nodeINBTSerializable("inventory", launcher -> launcher.inventory).nodeINBTSerializable("firing_package", launcher -> launcher.firingPackage).nodeINBTSerializable("launcher", launcher -> launcher.missileLauncher).nodeFacing("seat_side", TileLauncherBase::getSeatSide, TileLauncherBase::setSeatSide).base();
    public static final PacketCodexTile<TileLauncherBase, TileLauncherBase> PACKET_DESCRIPTION = (PacketCodexTile)new PacketCodexTile(REGISTRY_NAME, "description").fromServer().nodeItemStack(TileLauncherBase::getMissileStack, (t, f) -> {
        t.cachedMissileStack = f;
    }).nodeFacing(TileLauncherBase::getSeatSide, TileLauncherBase::setSeatSide);
    public static final PacketCodexTile<TileLauncherBase, TileLauncherBase> PACKET_GUI = (PacketCodexTile)new PacketCodexTile(REGISTRY_NAME, "gui").fromServer().nodeInt(TileLauncherBase::getGroupIndex, TileLauncherBase::setGroupIndex).nodeInt(TileLauncherBase::getGroupId, TileLauncherBase::setGroupId).nodeInt(TileLauncherBase::getFiringDelay, TileLauncherBase::setFiringDelay).nodeInt(TileLauncherBase::getLockHeight, TileLauncherBase::setLockHeight);
    public static final PacketCodexTile<TileLauncherBase, TileLauncherBase> PACKET_LOCK_HEIGHT = (PacketCodexTile)new PacketCodexTile(REGISTRY_NAME, "lock_height").fromClient().nodeInt(TileLauncherBase::getLockHeight, TileLauncherBase::setLockHeight);
    public static final PacketCodexTile<TileLauncherBase, TileLauncherBase> PACKET_GROUP_INDEX = (PacketCodexTile)new PacketCodexTile(REGISTRY_NAME, "group.index").fromClient().nodeInt(TileLauncherBase::getGroupIndex, TileLauncherBase::setGroupIndex);
    public static final PacketCodexTile<TileLauncherBase, TileLauncherBase> PACKET_GROUP_ID = (PacketCodexTile)new PacketCodexTile(REGISTRY_NAME, "group.id").fromClient().nodeInt(TileLauncherBase::getGroupId, TileLauncherBase::setGroupId);
    public static final PacketCodexTile<TileLauncherBase, TileLauncherBase> PACKET_SEAT_ROTATION = (PacketCodexTile)new PacketCodexTile(REGISTRY_NAME, "rotation.seat").fromClient().nodeFacing(TileLauncherBase::getSeatSide, TileLauncherBase::setSeatSide);
    public static final PacketCodexTile<TileLauncherBase, TileLauncherBase> PACKET_FIRING_DELAY = (PacketCodexTile)new PacketCodexTile(REGISTRY_NAME, "firing.delay").fromClient().nodeInt(TileLauncherBase::getFiringDelay, TileLauncherBase::setFiringDelay);

    public TileLauncherBase() {
        this.tickActions.add(this.descriptionPacketSender);
        this.tickActions.add(new TickAction(3, true, t -> PACKET_GUI.sendPacketToGuiUsers(this, this.playersUsing)));
        this.tickActions.add(new TickAction(20, true, t -> this.playersUsing.removeIf(player -> !(player.field_71070_bA instanceof ContainerLaunchBase))));
        this.tickActions.add(new TickAction(() -> this.isServer() && this.firingPackage != null, this::handleFirePackage));
        this.tickActions.add(new TickAction(3, true, this::updateSeat));
        this.tickActions.add(this.inventory);
    }

    public void func_70296_d() {
        super.func_70296_d();
        if (this.isServer()) {
            this.descriptionPacketSender.doNext();
        }
    }

    @Override
    public void provideInformation(BiConsumer<String, Object> consumer) {
        consumer.accept("NEEDS_POWER", ConfigMain.REQUIRES_POWER);
        consumer.accept("ENERGY_COST_ACTION", this.getFiringCost());
        consumer.accept("MAX_RANGE", ConfigLauncher.RANGE);
        consumer.accept("INACCURACY_BASE", ConfigLauncher.MIN_INACCURACY);
        consumer.accept("INACCURACY_RANGE", ConfigLauncher.SCALED_INACCURACY_DISTANCE);
        consumer.accept("INACCURACY_LAUNCHERS", ConfigLauncher.SCALED_INACCURACY_LAUNCHERS);
    }

    public EnumFacing getLaunchDirection() {
        IBlockState state = this.getBlockState();
        if (state.func_177228_b().containsKey((Object)BlockLauncherBase.ROTATION_PROP)) {
            return (EnumFacing)state.func_177229_b((IProperty)BlockLauncherBase.ROTATION_PROP);
        }
        return EnumFacing.UP;
    }

    public EnumFacing getSeatSide() {
        if (this.seatSide == null) {
            switch (this.getLaunchDirection()) {
                case UP: {
                    this.seatSide = EnumFacing.NORTH;
                    break;
                }
                case DOWN: {
                    this.seatSide = EnumFacing.NORTH;
                    break;
                }
                case EAST: {
                    this.seatSide = EnumFacing.UP;
                    break;
                }
                case WEST: {
                    this.seatSide = EnumFacing.UP;
                    break;
                }
                case NORTH: {
                    this.seatSide = EnumFacing.UP;
                    break;
                }
                case SOUTH: {
                    this.seatSide = EnumFacing.UP;
                }
            }
        }
        return this.seatSide;
    }

    public float getMissileYaw(boolean render) {
        if (render) {
            switch (this.getLaunchDirection()) {
                case NORTH: {
                    return 0.0f;
                }
                case SOUTH: {
                    return -180.0f;
                }
                case WEST: {
                    return 90.0f;
                }
                case EAST: {
                    return -90.0f;
                }
            }
            return 0.0f;
        }
        switch (this.getLaunchDirection()) {
            case NORTH: {
                return -180.0f;
            }
            case SOUTH: {
                return 0.0f;
            }
            case WEST: {
                return -90.0f;
            }
            case EAST: {
                return 90.0f;
            }
        }
        return 0.0f;
    }

    public float getMissilePitch(boolean render) {
        if (render) {
            switch (this.getLaunchDirection()) {
                case UP: {
                    return 0.0f;
                }
                case DOWN: {
                    return -180.0f;
                }
            }
            return -90.0f;
        }
        switch (this.getLaunchDirection()) {
            case UP: {
                return 90.0f;
            }
            case DOWN: {
                return -90.0f;
            }
        }
        return 0.0f;
    }

    public int getFiringCost() {
        return ConfigLauncher.POWER_COST;
    }

    public void onLoad() {
        this.launcherNode.connectToTiles();
    }

    public void func_145843_s() {
        this.getNetworkNode().onTileRemoved();
        super.func_145843_s();
    }

    @Override
    public LauncherNode getNetworkNode() {
        return this.launcherNode;
    }

    private void handleFirePackage() {
        this.firingPackage.setCountDown(this.firingPackage.getCountDown() - 1);
        if (this.firingPackage.getCountDown() <= 0) {
            this.firingPackage.launch(this.missileLauncher);
            this.firingPackage = null;
        }
    }

    private void updateSeat() {
        this.checkMissileCollision = true;
        if (!this.getMissileStack().func_190926_b() && this.seat == null) {
            this.seat = new EntityPlayerSeat(this.field_145850_b);
            this.seat.func_70107_b((double)this.func_174877_v().func_177958_n() + 0.5, (double)this.func_174877_v().func_177956_o() + 0.5, (double)this.func_174877_v().func_177952_p() + 0.5);
            this.seat.setHost(this);
            this.field_145850_b.func_72838_d((Entity)this.seat);
        } else if (this.getMissileStack().func_190926_b() && this.seat != null) {
            Optional.ofNullable(this.seat.func_184187_bx()).ifPresent(Entity::func_184226_ay);
            this.seat.func_70106_y();
            this.seat = null;
        }
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || capability == ICBMClassicAPI.MISSILE_HOLDER_CAPABILITY || capability == ICBMClassicAPI.MISSILE_LAUNCHER_CAPABILITY || capability == CapabilityEnergy.ENERGY && ConfigMain.REQUIRES_POWER || super.hasCapability(capability, facing);
    }

    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityEnergy.ENERGY) {
            return (T)this.energyStorage;
        }
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)this.inventory;
        }
        if (capability == ICBMClassicAPI.MISSILE_HOLDER_CAPABILITY) {
            return (T)this.missileHolder;
        }
        if (capability == ICBMClassicAPI.MISSILE_LAUNCHER_CAPABILITY) {
            return (T)this.missileLauncher;
        }
        return (T)super.getCapability(capability, facing);
    }

    public boolean checkForMissileInBounds() {
        if (this.checkMissileCollision) {
            this.checkMissileCollision = false;
            AxisAlignedBB collisionCheck = new AxisAlignedBB((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p(), (double)(this.func_174877_v().func_177958_n() + 1), (double)(this.func_174877_v().func_177956_o() + 5), (double)(this.func_174877_v().func_177952_p() + 1));
            List entities = this.field_145850_b.func_72872_a(EntityMissile.class, collisionCheck);
            this.hasMissileCollision = entities.size() > 0;
        }
        return this.hasMissileCollision;
    }

    public ITextComponent func_145748_c_() {
        return new TextComponentTranslation("gui.icbmclassic:launcherbase.name", new Object[0]);
    }

    public ItemStack getMissileStack() {
        if (this.isClient() && this.cachedMissileStack != null) {
            return this.cachedMissileStack;
        }
        return this.missileHolder.getMissileStack();
    }

    public boolean tryInsertMissile(EntityPlayer player, EnumHand hand, ItemStack heldItem) {
        if (this.getMissileStack().func_190926_b() && this.missileHolder.canSupportMissile(heldItem)) {
            if (this.isServer()) {
                ItemStack stackLeft = this.inventory.insertItem(0, heldItem, false);
                if (!player.field_71075_bZ.field_75098_d) {
                    player.func_184201_a(hand == EnumHand.MAIN_HAND ? EntityEquipmentSlot.MAINHAND : EntityEquipmentSlot.OFFHAND, stackLeft);
                    player.field_71069_bz.func_75142_b();
                }
            }
            return true;
        }
        if (player.func_70093_af() && heldItem.func_190926_b() && !this.getMissileStack().func_190926_b()) {
            if (this.isServer()) {
                player.func_184201_a(hand == EnumHand.MAIN_HAND ? EntityEquipmentSlot.MAINHAND : EntityEquipmentSlot.OFFHAND, this.getMissileStack());
                this.inventory.extractItem(0, 1, false);
                player.field_71069_bz.func_75142_b();
            }
            return true;
        }
        return false;
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return INFINITE_EXTENT_AABB;
    }

    @Override
    public Object getServerGuiElement(int ID, EntityPlayer player) {
        return new ContainerLaunchBase(player, this);
    }

    @Override
    public Object getClientGuiElement(int ID, EntityPlayer player) {
        return new GuiLauncherBase(player, this);
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        SAVE_LOGIC.load(this, nbt);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        SAVE_LOGIC.save(this, nbt);
        return super.func_189515_b(nbt);
    }

    public static void register() {
        GameRegistry.registerTileEntity(TileLauncherBase.class, (ResourceLocation)REGISTRY_NAME);
        PacketCodexReg.register(PACKET_DESCRIPTION, PACKET_GUI, PACKET_LOCK_HEIGHT, PACKET_GROUP_ID, PACKET_GROUP_INDEX, PACKET_FIRING_DELAY, PACKET_SEAT_ROTATION);
    }

    @Generated
    public int getFiringDelay() {
        return this.firingDelay;
    }

    @Generated
    public void setFiringDelay(int firingDelay) {
        this.firingDelay = firingDelay;
    }

    @Generated
    public int getLockHeight() {
        return this.lockHeight;
    }

    @Generated
    public void setLockHeight(int lockHeight) {
        this.lockHeight = lockHeight;
    }

    @Generated
    public int getGroupId() {
        return this.groupId;
    }

    @Generated
    public void setGroupId(int groupId) {
        this.groupId = groupId;
    }

    @Generated
    public int getGroupIndex() {
        return this.groupIndex;
    }

    @Generated
    public void setGroupIndex(int groupIndex) {
        this.groupIndex = groupIndex;
    }

    @Generated
    public void setSeatSide(EnumFacing seatSide) {
        this.seatSide = seatSide;
    }

    @Generated
    public FiringPackage getFiringPackage() {
        return this.firingPackage;
    }

    @Generated
    public void setFiringPackage(FiringPackage firingPackage) {
        this.firingPackage = firingPackage;
    }

    @Generated
    public List<EntityPlayer> getPlayersUsing() {
        return this.playersUsing;
    }
}

