/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.content.blocks.launcher.cruise;

import icbm.classic.api.radio.IRadioMessage;
import icbm.classic.api.radio.IRadioReceiver;
import icbm.classic.api.radio.IRadioSender;
import icbm.classic.api.radio.messages.ITargetMessage;
import icbm.classic.api.radio.messages.ITriggerActionMessage;
import icbm.classic.content.blocks.launcher.FiringPackage;
import icbm.classic.content.blocks.launcher.cruise.TileCruiseLauncher;
import icbm.classic.content.missile.logic.source.cause.EntityCause;
import icbm.classic.content.missile.logic.targeting.BasicTargetData;
import icbm.classic.lib.radio.imp.RadioTile;
import icbm.classic.lib.radio.messages.RadioTranslations;
import icbm.classic.lib.radio.messages.TextMessage;
import icbm.classic.prefab.FakeRadioSender;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.common.util.INBTSerializable;

public class RadioCruise
extends RadioTile<TileCruiseLauncher>
implements IRadioReceiver,
INBTSerializable<NBTTagCompound> {
    public RadioCruise(TileCruiseLauncher host) {
        super(host);
    }

    @Override
    public void onMessage(IRadioSender sender, IRadioMessage packet) {
        if (this.canReceive(sender, packet)) {
            if (packet instanceof ITargetMessage) {
                Vec3d target = ((ITargetMessage)packet).getTarget();
                if (target != null) {
                    ((TileCruiseLauncher)this.host).setTarget(target);
                    if (!(packet instanceof ITriggerActionMessage)) {
                        sender.onMessageCallback(this, new TextMessage(this.getChannel(), RadioTranslations.RADIO_TARGET_SET, target.field_72450_a, target.field_72448_b, target.field_72449_c));
                    }
                } else {
                    sender.onMessageCallback(this, new TextMessage(this.getChannel(), RadioTranslations.RADIO_TARGET_NULL));
                }
            }
            if (packet instanceof ITriggerActionMessage) {
                if (((TileCruiseLauncher)this.host).getFiringPackage() != null) {
                    sender.onMessageCallback(this, new TextMessage(this.getChannel(), "info.icbmclassic:launcher.error.missile.queued"));
                    return;
                }
                if (sender instanceof FakeRadioSender) {
                    ((TileCruiseLauncher)this.host).setFiringPackage(new FiringPackage(new BasicTargetData(((TileCruiseLauncher)this.host).getTarget()), new EntityCause((Entity)((FakeRadioSender)sender).player), 0));
                } else {
                    ((TileCruiseLauncher)this.host).setFiringPackage(new FiringPackage(new BasicTargetData(((TileCruiseLauncher)this.host).getTarget()), null, 0));
                }
                sender.onMessageCallback(this, new TextMessage(this.getChannel(), RadioTranslations.RADIO_LAUNCH_TRIGGERED));
            }
        }
    }
}

