/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.content.blocks.radarstation.data;

import icbm.classic.content.blocks.radarstation.TileRadarStation;
import icbm.classic.content.blocks.radarstation.data.RadarDotType;
import icbm.classic.content.blocks.radarstation.data.RadarRenderDot;
import io.netty.buffer.ByteBuf;
import java.util.LinkedList;
import java.util.List;
import lombok.Generated;

public class RadarRenderData {
    public static final int UV_SIZE = 54;
    private final TileRadarStation host;
    private final List<RadarRenderDot> dots = new LinkedList<RadarRenderDot>();

    public RadarRenderData(TileRadarStation host) {
        this.host = host;
    }

    public void update() {
        this.addDot((double)this.host.func_174877_v().func_177958_n() + 0.5, (double)this.host.func_174877_v().func_177952_p() + 0.5, RadarDotType.MARKER);
        this.addDot((double)(this.host.getDetectionRange() + this.host.func_174877_v().func_177958_n()) + 0.5, (double)this.host.func_174877_v().func_177952_p() + 0.5, RadarDotType.MARKER);
        this.addDot((double)(-this.host.getDetectionRange() + this.host.func_174877_v().func_177958_n()) + 0.5, (double)this.host.func_174877_v().func_177952_p() + 0.5, RadarDotType.MARKER);
        this.addDot((double)this.host.func_174877_v().func_177958_n() + 0.5, (double)this.host.func_174877_v().func_177952_p() + 0.5 + (double)this.host.getDetectionRange(), RadarDotType.MARKER);
        this.addDot((double)this.host.func_174877_v().func_177958_n() + 0.5, (double)this.host.func_174877_v().func_177952_p() + 0.5 - (double)this.host.getDetectionRange(), RadarDotType.MARKER);
        this.addDot((double)this.host.func_174877_v().func_177958_n() + 0.5 + (double)this.host.getTriggerRange(), (double)this.host.func_174877_v().func_177952_p() + 0.5, RadarDotType.MARKER);
        this.addDot((double)this.host.func_174877_v().func_177958_n() + 0.5 - (double)this.host.getTriggerRange(), (double)this.host.func_174877_v().func_177952_p() + 0.5, RadarDotType.MARKER);
        this.addDot((double)this.host.func_174877_v().func_177958_n() + 0.5, (double)this.host.func_174877_v().func_177952_p() + 0.5 + (double)this.host.getTriggerRange(), RadarDotType.MARKER);
        this.addDot((double)this.host.func_174877_v().func_177958_n() + 0.5, (double)this.host.func_174877_v().func_177952_p() + 0.5 - (double)this.host.getTriggerRange(), RadarDotType.MARKER);
        this.host.getDetectedThreats().forEach(entity -> this.addDot(entity.field_70165_t, entity.field_70161_v, RadarDotType.HOSTILE));
        this.host.getIncomingThreats().forEach(entity -> this.addDot(entity.x(), entity.z(), RadarDotType.INCOMING));
    }

    public void addDot(double ex, double ez, RadarDotType type) {
        double deltaX = ex - ((double)this.host.func_174877_v().func_177958_n() + 0.5);
        double deltaZ = ez - ((double)this.host.func_174877_v().func_177952_p() + 0.5);
        double vecX = deltaX / (double)this.host.getDetectionRange();
        double vecZ = deltaZ / (double)this.host.getDetectionRange();
        int x = (int)Math.floor(vecX * 27.0);
        int z = (int)Math.floor(vecZ * 27.0);
        this.dots.add(new RadarRenderDot(x, z, type));
    }

    public void clear() {
        this.dots.clear();
    }

    public void setDots(List<RadarRenderDot> dots) {
        this.dots.clear();
        this.dots.addAll(dots);
    }

    public static List<RadarRenderDot> decodeDots(ByteBuf buf) {
        LinkedList<RadarRenderDot> dots = new LinkedList<RadarRenderDot>();
        int dotCount = buf.readInt();
        for (int i = 0; i < dotCount; ++i) {
            dots.add(new RadarRenderDot(buf.readInt(), buf.readInt(), RadarDotType.get(buf.readByte())));
        }
        return dots;
    }

    public static void encodeDots(ByteBuf buf, List<RadarRenderDot> dots) {
        buf.writeInt(dots.size());
        dots.forEach(dot -> {
            buf.writeInt(dot.getX());
            buf.writeInt(dot.getY());
            buf.writeByte(dot.getType().ordinal());
        });
    }

    @Generated
    public List<RadarRenderDot> getDots() {
        return this.dots;
    }
}

