/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.content.entity.flyingblock;

import icbm.classic.config.ConfigFlyingBlocks;
import icbm.classic.config.util.BlockStateConfigList;
import icbm.classic.content.entity.flyingblock.EntityFlyingBlock;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class FlyingBlock {
    static final BlockStateConfigList banAllowList = new BlockStateConfigList("[Flying Blocks][Ban/Allow Config]", blockStateConfigList -> {
        blockStateConfigList.addMod("dynamictrees");
        blockStateConfigList.loadBlockStates(ConfigFlyingBlocks.BAN_ALLOW.BLOCK_STATES);
    });

    public static boolean isAllowed(IBlockState state) {
        if (!ConfigFlyingBlocks.ENABLED) {
            return false;
        }
        if (ConfigFlyingBlocks.BAN_ALLOW.BAN) {
            return !banAllowList.contains(state);
        }
        return banAllowList.contains(state);
    }

    public static IBlockState applyMutations(IBlockState state) {
        return state;
    }

    public static boolean spawnFlyingBlock(World world, BlockPos pos, IBlockState state) {
        return FlyingBlock.spawnFlyingBlock(world, pos, state, null, null);
    }

    public static boolean spawnFlyingBlock(World world, BlockPos pos, IBlockState state, Consumer<EntityFlyingBlock> preSpawnCallback, Consumer<EntityFlyingBlock> postSpawnCallback) {
        if (!FlyingBlock.isAllowed(state)) {
            return false;
        }
        EntityFlyingBlock flyingBlock = new EntityFlyingBlock(world);
        flyingBlock.setBlockState(state);
        flyingBlock.func_70107_b((double)pos.func_177958_n() + 0.5, pos.func_177956_o(), (double)pos.func_177952_p() + 0.5);
        Optional.ofNullable(preSpawnCallback).ifPresent(f -> f.accept(flyingBlock));
        if (world.func_72838_d((Entity)flyingBlock)) {
            Optional.ofNullable(postSpawnCallback).ifPresent(f -> f.accept(flyingBlock));
            return true;
        }
        return false;
    }

    public static void loadFromConfig() {
        banAllowList.reload();
    }
}

