/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.content.missile.logic.flight.move;

import icbm.classic.api.missiles.IMissile;
import icbm.classic.content.missile.logic.flight.prefab.AccelerateByFacingLogic;
import icbm.classic.lib.saving.NbtSaveHandler;
import lombok.Generated;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;

public class MoveForTicksLogic
extends AccelerateByFacingLogic {
    public static final ResourceLocation REG_NAME = new ResourceLocation("icbmclassic", "engine.move.ticks");
    private int ticks;
    private static final NbtSaveHandler<MoveForTicksLogic> SAVE_LOGIC = new NbtSaveHandler().mainRoot().nodeInteger("ticks", MoveForTicksLogic::getTicks, MoveForTicksLogic::setTicks).base();

    @Override
    public ResourceLocation getRegistryName() {
        return REG_NAME;
    }

    @Override
    public void onEntityTick(Entity entity, IMissile missile, int ticksInAir) {
        super.onEntityTick(entity, missile, ticksInAir);
        if (this.ticks >= 0) {
            --this.ticks;
        }
    }

    @Override
    public boolean isDone() {
        return this.ticks <= 0;
    }

    @Override
    public boolean canSafelyExitLogic() {
        return super.canSafelyExitLogic();
    }

    @Override
    public NBTTagCompound serializeNBT() {
        return SAVE_LOGIC.save(this, super.serializeNBT());
    }

    @Override
    public void deserializeNBT(NBTTagCompound nbt) {
        super.deserializeNBT(nbt);
        SAVE_LOGIC.load(this, nbt);
    }

    @Generated
    public int getTicks() {
        return this.ticks;
    }

    @Generated
    public MoveForTicksLogic setTicks(int ticks) {
        this.ticks = ticks;
        return this;
    }
}

