/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.content.missile.logic.source;

import icbm.classic.api.ICBMClassicAPI;
import icbm.classic.api.missiles.cause.IMissileCause;
import icbm.classic.api.missiles.cause.IMissileSource;
import icbm.classic.lib.saving.NbtSaveHandler;
import icbm.classic.lib.saving.NbtSaveNode;
import lombok.Generated;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public final class MissileSource
implements IMissileSource {
    private World world;
    private Vec3d position;
    private IMissileCause cause;
    public static final NbtSaveNode<MissileSource, NBTTagCompound> CAUSE_SAVE = new NbtSaveNode<MissileSource, NBTTagCompound>("cause", source -> {
        NBTTagCompound save = new NBTTagCompound();
        IMissileCause cause = source.getCause();
        if (cause != null) {
            NBTTagCompound logicSave = (NBTTagCompound)cause.serializeNBT();
            if (logicSave != null && !logicSave.func_82582_d()) {
                save.func_74782_a("data", (NBTBase)logicSave);
            }
            save.func_74778_a("id", cause.getRegistryName().toString());
        }
        return save;
    }, (source, data) -> {
        ResourceLocation saveId = new ResourceLocation(data.func_74779_i("id"));
        IMissileCause cause = ICBMClassicAPI.MISSILE_CAUSE_REGISTRY.build(saveId);
        if (cause != null) {
            if (data.func_74764_b("data")) {
                cause.deserializeNBT((NBTBase)data.func_74775_l("data"));
            }
            source.cause = cause;
        }
    });
    private static final NbtSaveHandler<MissileSource> SAVE_LOGIC = new NbtSaveHandler().mainRoot().nodeWorldDim("dimension", MissileSource::getWorld, MissileSource::setWorld).nodeVec3d("pos", MissileSource::getPosition, MissileSource::setPosition).node(CAUSE_SAVE).base();

    public NBTTagCompound serializeNBT() {
        return SAVE_LOGIC.save(this, new NBTTagCompound());
    }

    public void deserializeNBT(NBTTagCompound save) {
        SAVE_LOGIC.load(this, save);
    }

    @Override
    @Generated
    public World getWorld() {
        return this.world;
    }

    @Override
    @Generated
    public Vec3d getPosition() {
        return this.position;
    }

    @Override
    @Generated
    public IMissileCause getCause() {
        return this.cause;
    }

    @Generated
    public void setWorld(World world) {
        this.world = world;
    }

    @Generated
    public void setPosition(Vec3d position) {
        this.position = position;
    }

    @Generated
    public void setCause(IMissileCause cause) {
        this.cause = cause;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MissileSource)) {
            return false;
        }
        MissileSource other = (MissileSource)o;
        World this$world = this.getWorld();
        World other$world = other.getWorld();
        if (this$world == null ? other$world != null : !this$world.equals(other$world)) {
            return false;
        }
        Vec3d this$position = this.getPosition();
        Vec3d other$position = other.getPosition();
        if (this$position == null ? other$position != null : !this$position.equals(other$position)) {
            return false;
        }
        IMissileCause this$cause = this.getCause();
        IMissileCause other$cause = other.getCause();
        return !(this$cause == null ? other$cause != null : !this$cause.equals(other$cause));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        World $world = this.getWorld();
        result = result * 59 + ($world == null ? 43 : $world.hashCode());
        Vec3d $position = this.getPosition();
        result = result * 59 + ($position == null ? 43 : $position.hashCode());
        IMissileCause $cause = this.getCause();
        result = result * 59 + ($cause == null ? 43 : $cause.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "MissileSource(world=" + this.getWorld() + ", position=" + this.getPosition() + ", cause=" + this.getCause() + ")";
    }

    @Generated
    public MissileSource() {
    }

    @Generated
    public MissileSource(World world, Vec3d position, IMissileCause cause) {
        this.world = world;
        this.position = position;
        this.cause = cause;
    }
}

