/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.content.parachute;

import icbm.classic.lib.projectile.EntityProjectile;
import icbm.classic.lib.saving.NbtSaveHandler;
import io.netty.buffer.ByteBuf;
import lombok.Generated;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityParachute
extends EntityProjectile<EntityParachute>
implements IEntityAdditionalSpawnData {
    public int ticksToLive = 100;
    private ItemStack renderItemStack = new ItemStack(Blocks.field_150404_cg);
    private ItemStack dropItemStack = ItemStack.field_190927_a;
    private static final NbtSaveHandler<EntityParachute> SAVE_LOGIC = new NbtSaveHandler().mainRoot().nodeInteger("ticksToLive", e -> e.ticksToLive, (e, i) -> {
        e.ticksToLive = i;
    }).nodeItemStack("renderItem", e -> e.renderItemStack, (e, i) -> {
        e.renderItemStack = i;
    }).nodeItemStack("dropItem", e -> e.dropItemStack, (e, i) -> {
        e.dropItemStack = i;
    }).base();

    public EntityParachute(World world) {
        super(world);
        this.func_70105_a(0.5f, 0.5f);
        this.field_70156_m = true;
        this.field_70158_ak = true;
    }

    @Override
    public void writeSpawnData(ByteBuf data) {
        data.writeInt(this.ticksToLive);
        ByteBufUtils.writeItemStack((ByteBuf)data, (ItemStack)this.renderItemStack);
    }

    @Override
    public void readSpawnData(ByteBuf data) {
        this.ticksToLive = data.readInt();
        this.renderItemStack = ByteBufUtils.readItemStack((ByteBuf)data);
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K && (this.field_70173_aa > this.ticksToLive || this.func_184188_bt().isEmpty())) {
            this.func_184226_ay();
            this.func_70106_y();
        }
    }

    @Override
    protected float getGravity() {
        return 0.0f;
    }

    @Override
    protected void decreaseMotion() {
        super.decreaseMotion();
        if (!this.field_70122_E && this.field_70181_x < 0.0) {
            this.field_70181_x *= 0.6;
        }
    }

    public boolean shouldRiderSit() {
        return false;
    }

    public ItemStack renderItemStack() {
        return this.renderItemStack;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_70112_a(double distance) {
        double d0 = this.func_174813_aQ().func_72320_b() * 10.0;
        if (Double.isNaN(d0)) {
            d0 = 1.0;
        }
        return distance < (d0 = d0 * 64.0 * EntityParachute.func_184183_bd()) * d0;
    }

    @Override
    public void func_70037_a(NBTTagCompound tag) {
        super.func_70037_a(tag);
        SAVE_LOGIC.load(this, tag);
    }

    @Override
    public void func_70014_b(NBTTagCompound tag) {
        super.func_70014_b(tag);
        SAVE_LOGIC.save(this, tag);
    }

    @Generated
    public EntityParachute setRenderItemStack(ItemStack renderItemStack) {
        this.renderItemStack = renderItemStack;
        return this;
    }

    @Generated
    public ItemStack getRenderItemStack() {
        return this.renderItemStack;
    }

    @Generated
    public EntityParachute setDropItemStack(ItemStack dropItemStack) {
        this.dropItemStack = dropItemStack;
        return this;
    }

    @Generated
    public ItemStack getDropItemStack() {
        return this.dropItemStack;
    }
}

