/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.lib.data;

import icbm.classic.api.data.IBoundBox;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;

public class BoundBlockPos
implements IBoundBox<BlockPos> {
    private BlockPos min;
    private BlockPos max;

    public BoundBlockPos(int x, int y, int z, int i, int j, int k) {
        this.min = new BlockPos(x, y, z);
        this.max = new BlockPos(i, j, k);
    }

    public BoundBlockPos(Vec3d pos, int range) {
        this.min = new BlockPos((int)Math.floor(pos.field_72450_a) - range, (int)Math.floor(pos.field_72448_b) - range, (int)Math.floor(pos.field_72449_c) - range);
        this.max = new BlockPos((int)Math.floor(pos.field_72450_a) + range, (int)Math.floor(pos.field_72448_b) + range, (int)Math.floor(pos.field_72449_c) + range);
    }

    public BoundBlockPos(BlockPos pos, int range) {
        this.min = new BlockPos(pos.func_177958_n() - range, pos.func_177956_o() - range, pos.func_177952_p() - range);
        this.max = new BlockPos(pos.func_177958_n() + range, pos.func_177956_o() + range, pos.func_177952_p() + range);
    }

    @Override
    public BlockPos lowerBound() {
        return this.min;
    }

    @Override
    public BlockPos upperBound() {
        return this.max;
    }

    public BlockPos getMin() {
        return this.min;
    }

    public BlockPos getMax() {
        return this.max;
    }

    public void setMin(BlockPos min) {
        this.min = min;
    }

    public void setMax(BlockPos max) {
        this.max = max;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BoundBlockPos)) {
            return false;
        }
        BoundBlockPos other = (BoundBlockPos)o;
        if (!other.canEqual(this)) {
            return false;
        }
        BlockPos this$min = this.getMin();
        BlockPos other$min = other.getMin();
        if (this$min == null ? other$min != null : !this$min.equals(other$min)) {
            return false;
        }
        BlockPos this$max = this.getMax();
        BlockPos other$max = other.getMax();
        return !(this$max == null ? other$max != null : !this$max.equals(other$max));
    }

    protected boolean canEqual(Object other) {
        return other instanceof BoundBlockPos;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        BlockPos $min = this.getMin();
        result = result * 59 + ($min == null ? 43 : $min.hashCode());
        BlockPos $max = this.getMax();
        result = result * 59 + ($max == null ? 43 : $max.hashCode());
        return result;
    }

    public String toString() {
        return "BoundBlockPos(min=" + this.getMin() + ", max=" + this.getMax() + ")";
    }

    public BoundBlockPos(BlockPos min, BlockPos max) {
        this.min = min;
        this.max = max;
    }
}

