/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.lib.projectile;

import icbm.classic.api.missiles.IMissileAiming;
import icbm.classic.content.entity.EntityPlayerSeat;
import icbm.classic.lib.saving.NbtSaveHandler;
import icbm.classic.lib.transform.vector.Pos;
import icbm.classic.lib.world.IProjectileBlockInteraction;
import icbm.classic.lib.world.ProjectileBlockInteraction;
import icbm.classic.prefab.entity.EntityICBM;
import io.netty.buffer.ByteBuf;
import java.util.List;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IProjectile;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ITeleporter;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class EntityProjectile<E extends EntityProjectile<E>>
extends EntityICBM
implements IProjectile,
IMissileAiming,
IEntityAdditionalSpawnData {
    public Entity shootingEntity;
    public UUID shootingEntityUUID;
    public Pos sourceOfProjectile;
    protected int inGroundKillTime = 1200;
    protected int inAirKillTime = 1200;
    protected DamageSource impact_damageSource = DamageSource.field_82728_o;
    public BlockPos tilePos = new BlockPos(0, 0, 0);
    public EnumFacing sideTile = EnumFacing.UP;
    public IBlockState blockInside = Blocks.field_150350_a.func_176223_P();
    public boolean inGround = false;
    public boolean changingDimensions = false;
    public int ticksInGround;
    public int ticksInAir;
    public boolean freezeMotion = false;
    private static final NbtSaveHandler<EntityProjectile> SAVE_LOGIC = new NbtSaveHandler().addRoot("ground").nodeBlockPos("pos", projectile -> projectile.tilePos, (projectile, pos) -> {
        projectile.tilePos = pos;
    }).nodeFacing("side", projectile -> projectile.sideTile, (projectile, side) -> {
        projectile.sideTile = side;
    }).nodeBlockState("state", projectile -> projectile.blockInside, (projectile, blockState) -> {
        projectile.blockInside = blockState;
    }).base().addRoot("flags").nodeBoolean("ground", projectile -> projectile.inGround, (projectile, flag) -> {
        projectile.inGround = flag;
    }).base().addRoot("ticks").nodeInteger("air", projectile -> projectile.ticksInAir, (projectile, flag) -> {
        projectile.ticksInAir = flag;
    }).nodeInteger("ground", projectile -> projectile.ticksInGround, (projectile, flag) -> {
        projectile.ticksInGround = flag;
    }).base();

    public EntityProjectile(World world) {
        super(world);
        this.func_70105_a(0.5f, 0.5f);
    }

    public void writeSpawnData(ByteBuf buffer) {
        buffer.writeBoolean(this.freezeMotion);
    }

    public void readSpawnData(ByteBuf additionalData) {
        this.freezeMotion = additionalData.readBoolean();
    }

    @Deprecated
    public E init(EntityLivingBase shooter, EntityLivingBase target, float multiplier, float random) {
        this.shootingEntity = shooter;
        this.sourceOfProjectile = new Pos((Entity)shooter);
        this.field_70163_u = shooter.field_70163_u + (double)shooter.func_70047_e() - (double)0.1f;
        double deltaX = target.field_70165_t - shooter.field_70165_t;
        double deltaY = target.func_174813_aQ().field_72338_b + (double)(target.field_70131_O / 3.0f) - this.field_70163_u;
        double deltaZ = target.field_70161_v - shooter.field_70161_v;
        double deltaMag = MathHelper.func_76133_a((double)(deltaX * deltaX + deltaZ * deltaZ));
        if (deltaMag >= 1.0E-7) {
            float yaw = (float)(Math.atan2(deltaZ, deltaX) * 180.0 / Math.PI) - 90.0f;
            float pitch = (float)(-(Math.atan2(deltaY, deltaMag) * 180.0 / Math.PI));
            double subX = deltaX / deltaMag;
            double subZ = deltaZ / deltaMag;
            float subY = (float)deltaMag * 0.2f;
            this.func_70012_b(shooter.field_70165_t + subX, this.field_70163_u, shooter.field_70161_v + subZ, yaw, pitch);
            this.func_70186_c(deltaX, deltaY + (double)subY, deltaZ, multiplier, random);
        }
        return (E)this;
    }

    @Deprecated
    public E init(double x, double y, double z, float yaw, float pitch, float multiplier, float distanceScale) {
        this.sourceOfProjectile = new Pos(x, y, z);
        this.func_70012_b(x, y, z, yaw, pitch);
        this.field_70165_t -= (double)(MathHelper.func_76134_b((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * 0.16f * distanceScale);
        this.field_70163_u -= (double)0.1f;
        this.field_70161_v -= (double)(MathHelper.func_76126_a((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * 0.16f * distanceScale);
        this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        this.field_70159_w = -MathHelper.func_76126_a((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(this.field_70125_A / 180.0f * (float)Math.PI));
        this.field_70179_y = MathHelper.func_76134_b((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(this.field_70125_A / 180.0f * (float)Math.PI));
        this.field_70181_x = -MathHelper.func_76126_a((float)(this.field_70125_A / 180.0f * (float)Math.PI));
        this.func_70186_c(this.field_70159_w, this.field_70181_x, this.field_70179_y, multiplier, 0.0f);
        return (E)this;
    }

    @Override
    public void initAimingPosition(double x, double y, double z, float yaw, float pitch, float offsetMultiplier, float forceMultiplier) {
        this.init(x, y, z, yaw, pitch, forceMultiplier, offsetMultiplier);
    }

    @Override
    public void initAimingPosition(Entity shooter, float offsetMultiplier, float forceMultiplier) {
        this.shootingEntity = shooter;
        this.initAimingPosition(shooter.field_70165_t, shooter.field_70163_u + (double)shooter.func_70047_e(), shooter.field_70161_v, shooter.field_70177_z, shooter.field_70125_A, offsetMultiplier, forceMultiplier);
    }

    public void func_70071_h_() {
        AxisAlignedBB axisalignedbb;
        super.func_70071_h_();
        IBlockState state = this.field_70170_p.func_180495_p(this.tilePos);
        if (!state.func_177230_c().isAir(state, (IBlockAccess)this.field_70170_p, this.tilePos) && (axisalignedbb = state.func_185890_d((IBlockAccess)this.field_70170_p, this.tilePos)) != Block.field_185506_k && axisalignedbb.func_186670_a(this.tilePos).func_72318_a(new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v))) {
            this.setInGround(true);
        }
        if (this.inGround) {
            if (state == this.blockInside) {
                ++this.ticksInGround;
                if (this.ticksInGround == this.inGroundKillTime) {
                    this.func_70106_y();
                }
            } else {
                this.inGround = false;
                this.field_70159_w *= (double)(this.field_70146_Z.nextFloat() * 0.2f);
                this.field_70181_x *= (double)(this.field_70146_Z.nextFloat() * 0.2f);
                this.field_70179_y *= (double)(this.field_70146_Z.nextFloat() * 0.2f);
                this.ticksInGround = 0;
                this.ticksInAir = 0;
            }
        } else {
            ++this.ticksInAir;
            if (this.ticksInAir >= this.inAirKillTime) {
                this.func_70106_y();
                return;
            }
            double rayEndVecX = this.field_70159_w;
            double rayEndVecY = this.field_70181_x;
            double rayEndVecZ = this.field_70179_y;
            double velocity = Math.sqrt(rayEndVecX * rayEndVecX + rayEndVecY * rayEndVecY + rayEndVecZ * rayEndVecZ);
            rayEndVecX /= velocity;
            rayEndVecY /= velocity;
            rayEndVecZ /= velocity;
            Vec3d rayStart = new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v);
            Vec3d rayEnd = new Vec3d(this.field_70165_t + (rayEndVecX *= velocity + 1.0), this.field_70163_u + (rayEndVecY *= velocity + 1.0), this.field_70161_v + (rayEndVecZ *= velocity + 1.0));
            RayTraceResult rayHit = this.field_70170_p.func_147447_a(rayStart, rayEnd, false, true, false);
            rayStart = new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v);
            rayEnd = new Vec3d(this.field_70165_t + this.field_70159_w, this.field_70163_u + this.field_70181_x, this.field_70161_v + this.field_70179_y);
            if (rayHit != null) {
                rayEnd = new Vec3d(rayHit.field_72307_f.field_72450_a, rayHit.field_72307_f.field_72448_b, rayHit.field_72307_f.field_72449_c);
            }
            Entity entity = null;
            List list = this.field_70170_p.func_72839_b((Entity)this, this.func_174813_aQ().func_72317_d(this.field_70159_w, this.field_70181_x, this.field_70179_y).func_72321_a(1.0, 1.0, 1.0));
            double distanceToHit = 0.0;
            for (int i = 0; i < list.size(); ++i) {
                double distance;
                Entity checkEntity = (Entity)list.get(i);
                if (!this.shouldCollideWith(checkEntity) || checkEntity == this.shootingEntity && this.ticksInAir < 5) continue;
                float hitBoxSizeScale = 0.3f;
                AxisAlignedBB hitBox = checkEntity.func_174813_aQ().func_72321_a((double)hitBoxSizeScale, (double)hitBoxSizeScale, (double)hitBoxSizeScale);
                RayTraceResult entityRayHit = hitBox.func_72327_a(rayStart, rayEnd);
                if (entityRayHit == null || !((distance = rayStart.func_72438_d(entityRayHit.field_72307_f)) < distanceToHit) && distanceToHit != 0.0) continue;
                entity = checkEntity;
                distanceToHit = distance;
            }
            if (entity != null) {
                rayHit = new RayTraceResult(entity);
            }
            if (rayHit != null && rayHit.field_72313_a != RayTraceResult.Type.MISS && !this.ignoreImpact(rayHit)) {
                if (rayHit.field_72313_a == RayTraceResult.Type.ENTITY) {
                    this.handleEntityCollision(rayHit, rayHit.field_72308_g);
                } else {
                    this.handleBlockCollision(rayHit);
                }
                this.postImpact(rayHit);
            }
            this.updateMotion();
        }
    }

    protected void setInGround(boolean b) {
        if (!this.inGround && b) {
            this.ticksInGround = 0;
        }
        this.inGround = b;
    }

    protected boolean ignoreImpact(RayTraceResult hit) {
        return false;
    }

    protected void postImpact(RayTraceResult hit) {
    }

    protected boolean shouldCollideWith(Entity entity) {
        return entity.func_70067_L() && !(entity instanceof EntityPlayerSeat);
    }

    protected void handleBlockCollision(RayTraceResult hit) {
        this.tilePos = hit.func_178782_a();
        this.sideTile = hit.field_178784_b;
        this.blockInside = this.field_70170_p.func_180495_p(this.tilePos);
        IProjectileBlockInteraction.EnumHitReactions reaction = ProjectileBlockInteraction.handleSpecialInteraction(this.field_70170_p, this.tilePos, hit.field_72307_f, this.sideTile, this.blockInside, this);
        if (reaction.stop) {
            return;
        }
        this.moveTowards(hit.field_72307_f, this.field_70130_N / 2.0f);
        if (this.blockInside.func_185904_a() != Material.field_151579_a) {
            this.blockInside.func_177230_c().func_180634_a(this.field_70170_p, this.tilePos, this.blockInside, (Entity)this);
        }
        if (!(this.changingDimensions || this.field_70128_L || this.field_71087_bX || reaction == IProjectileBlockInteraction.EnumHitReactions.CONTINUE_NO_IMPACT)) {
            this.setInGround(true);
            this.onImpactTile(hit);
            this.field_70159_w = 0.0;
            this.field_70181_x = 0.0;
            this.field_70179_y = 0.0;
        }
    }

    public void moveTowards(Vec3d hit, double offset) {
        double deltaX = hit.field_72450_a - this.field_70165_t;
        double deltaY = hit.field_72448_b - this.field_70163_u;
        double deltaZ = hit.field_72449_c - this.field_70161_v;
        float mag = MathHelper.func_76133_a((double)(deltaX * deltaX + deltaY * deltaY + deltaZ * deltaZ));
        double vecX = deltaX / (double)mag * offset;
        double vecY = deltaX / (double)mag * offset;
        double vecZ = deltaZ / (double)mag * offset;
        this.field_70165_t = hit.field_72450_a + vecX;
        this.field_70163_u = hit.field_72448_b + vecY;
        this.field_70161_v = hit.field_72449_c + vecZ;
        this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
    }

    public Entity changeDimension(int dimensionIn, ITeleporter teleporter) {
        this.changingDimensions = true;
        return super.changeDimension(dimensionIn, teleporter);
    }

    public int func_82147_ab() {
        return 10;
    }

    public int func_82145_z() {
        return -1;
    }

    protected void onImpactTile(RayTraceResult hit) {
        this.onImpact(hit.field_72307_f);
    }

    protected void handleEntityCollision(RayTraceResult hit, Entity entityHit) {
        this.onImpactEntity(entityHit, (float)this.getVelocity().magnitude(), hit);
    }

    protected void onImpactEntity(Entity entityHit, float velocity, RayTraceResult hit) {
        if (!this.field_70170_p.field_72995_K) {
            float vel_horizontal;
            int damage = MathHelper.func_76143_f((double)((double)velocity * 2.0));
            if (this.impact_damageSource != null && entityHit.func_70097_a(this.impact_damageSource, (float)damage) && entityHit instanceof EntityLivingBase && (vel_horizontal = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y))) > 0.0f) {
                entityHit.func_70024_g(this.field_70159_w * (double)0.6f / (double)vel_horizontal, 0.1, this.field_70179_y * (double)0.6f / (double)vel_horizontal);
            }
            this.onImpact(hit.field_72307_f);
        }
    }

    protected void onImpact(Vec3d impactLocation) {
        this.func_70106_y();
    }

    protected void updateMotion() {
        if (!this.freezeMotion) {
            this.field_70165_t += this.field_70159_w;
            this.field_70163_u += this.field_70181_x;
            this.field_70161_v += this.field_70179_y;
            if (this.shouldAlignWithMotion()) {
                this.rotateTowardsMotion(0.05f);
            }
            this.decreaseMotion();
            this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
            this.func_145775_I();
        }
    }

    public boolean shouldAlignWithMotion() {
        return true;
    }

    public void rotateTowardsMotion(float delta) {
        float speed = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y));
        this.field_70177_z = (float)(Math.atan2(this.field_70159_w, this.field_70179_y) * 180.0 / Math.PI);
        this.field_70125_A = (float)(Math.atan2(this.field_70181_x, speed) * 180.0 / Math.PI);
        while (this.field_70125_A - this.field_70127_C < -180.0f) {
            this.field_70127_C -= 360.0f;
        }
        while (this.field_70125_A - this.field_70127_C >= 180.0f) {
            this.field_70127_C += 360.0f;
        }
        while (this.field_70177_z - this.field_70126_B < -180.0f) {
            this.field_70126_B -= 360.0f;
        }
        while (this.field_70177_z - this.field_70126_B >= 180.0f) {
            this.field_70126_B += 360.0f;
        }
        this.field_70125_A = this.field_70127_C + (this.field_70125_A - this.field_70127_C) * delta;
        this.field_70177_z = this.field_70126_B + (this.field_70177_z - this.field_70126_B) * delta;
    }

    protected void decreaseMotion() {
        this.field_70159_w *= (double)0.99f;
        this.field_70181_x *= (double)0.99f;
        this.field_70179_y *= (double)0.99f;
        this.field_70181_x -= (double)this.getGravity();
    }

    protected float getGravity() {
        return 0.05f;
    }

    public void func_70186_c(double xx, double yy, double zz, float multiplier, float random) {
        float velocity = MathHelper.func_76133_a((double)(xx * xx + yy * yy + zz * zz));
        xx /= (double)velocity;
        yy /= (double)velocity;
        zz /= (double)velocity;
        if (random > 0.0f) {
            xx += this.field_70146_Z.nextGaussian() * (double)(this.field_70146_Z.nextBoolean() ? -1 : 1) * (double)0.0075f * (double)random;
            yy += this.field_70146_Z.nextGaussian() * (double)(this.field_70146_Z.nextBoolean() ? -1 : 1) * (double)0.0075f * (double)random;
            zz += this.field_70146_Z.nextGaussian() * (double)(this.field_70146_Z.nextBoolean() ? -1 : 1) * (double)0.0075f * (double)random;
        }
        this.field_70159_w = xx *= (double)multiplier;
        this.field_70181_x = yy *= (double)multiplier;
        this.field_70179_y = zz *= (double)multiplier;
        float f3 = MathHelper.func_76133_a((double)(xx * xx + zz * zz));
        this.field_70126_B = this.field_70177_z = (float)(Math.atan2(xx, zz) * 180.0 / Math.PI);
        this.field_70127_C = this.field_70125_A = (float)(Math.atan2(yy, f3) * 180.0 / Math.PI);
        this.ticksInGround = 0;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180426_a(double x, double y, double z, float yaw, float pitch, int posRotationIncrements, boolean teleport) {
        this.func_70107_b(x, y, z);
        this.func_70101_b(yaw, pitch);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70016_h(double xx, double yy, double zz) {
        this.field_70159_w = xx;
        this.field_70181_x = yy;
        this.field_70179_y = zz;
    }

    protected boolean func_70041_e_() {
        return false;
    }

    public boolean canBeDestroyed(Object attacker, DamageSource damageSource) {
        return this.hasHealth;
    }

    @Override
    public void func_70014_b(NBTTagCompound nbt) {
        SAVE_LOGIC.save(this, nbt);
        super.func_70014_b(nbt);
    }

    @Override
    public void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        SAVE_LOGIC.load(this, nbt);
    }
}

