/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.lib.tracker;

import icbm.classic.lib.tracker.EventTrackerType;
import java.util.Arrays;
import java.util.Optional;
import net.minecraft.util.ResourceLocation;

public class EventTrackerEntry {
    private final EventTrackerType type;
    private final Object[] data;

    public <DATA> DATA get(ResourceLocation key) {
        return this.get(key, null);
    }

    public <DATA> DATA get(ResourceLocation key, DATA placeholder) {
        return Optional.ofNullable(this.type.getField(key).get(this)).orElse(placeholder);
    }

    public String getString(ResourceLocation key, String placeholder) {
        return Optional.ofNullable(this.type.getField(key).get(this)).map(Object::toString).orElse(placeholder);
    }

    public EventTrackerEntry(EventTrackerType type, Object[] data) {
        this.type = type;
        this.data = data;
    }

    public EventTrackerType getType() {
        return this.type;
    }

    public Object[] getData() {
        return this.data;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EventTrackerEntry)) {
            return false;
        }
        EventTrackerEntry other = (EventTrackerEntry)o;
        if (!other.canEqual(this)) {
            return false;
        }
        EventTrackerType this$type = this.getType();
        EventTrackerType other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        return Arrays.deepEquals(this.getData(), other.getData());
    }

    protected boolean canEqual(Object other) {
        return other instanceof EventTrackerEntry;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        EventTrackerType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getData());
        return result;
    }

    public String toString() {
        return "EventTrackerEntry(type=" + this.getType() + ", data=" + Arrays.deepToString(this.getData()) + ")";
    }
}

