/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.client.guide.parts;

import buildcraft.api.core.render.ISprite;
import buildcraft.lib.client.guide.GuiGuide;
import buildcraft.lib.client.guide.parts.GuidePart;
import buildcraft.lib.gui.GuiSpriteScaled;

public class GuideImage
extends GuidePart {
    public static final int PIXEL_HEIGHT = 42;
    final ISprite sprite;
    final GuiSpriteScaled icon;
    final GuiSpriteScaled full;
    final int width;
    final int height;

    public GuideImage(GuiGuide gui, ISprite sprite, int srcWidth, int srcHeight, int width, int height) {
        super(gui);
        this.sprite = sprite;
        this.width = width;
        this.height = height;
        this.icon = new GuiSpriteScaled(sprite, width, height);
        this.full = new GuiSpriteScaled(sprite, srcWidth, srcHeight);
    }

    @Override
    public GuidePart.PagePosition renderIntoArea(int x, int y, int width, int height, GuidePart.PagePosition current, int index) {
        if (height - current.pixel < this.height) {
            current = current.nextPage();
        }
        if (index == current.page) {
            int w = this.width;
            int h = this.height;
            this.icon.drawAt(x, y += current.pixel);
            GuiGuide.BORDER_TOP_LEFT.drawAt(x, y);
            GuiGuide.BORDER_TOP_RIGHT.drawAt(x + w - GuiGuide.BORDER_TOP_RIGHT.width, y);
            GuiGuide.BORDER_BOTTOM_LEFT.drawAt(x, y + h - GuiGuide.BORDER_BOTTOM_LEFT.height);
            GuiGuide.BORDER_BOTTOM_RIGHT.drawAt(x + w - GuiGuide.BORDER_BOTTOM_RIGHT.width, y + h - GuiGuide.BORDER_BOTTOM_RIGHT.height);
        }
        return current.nextLine(this.height + 1, height);
    }

    @Override
    public GuidePart.PagePosition handleMouseClick(int x, int y, int width, int height, GuidePart.PagePosition current, int index, int mouseX, int mouseY) {
        if (height - current.pixel < this.height) {
            current = current.nextPage();
        }
        if (index == current.page) {
            // empty if block
        }
        return current.nextLine(this.height + 1, height);
    }
}

