/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.blocks.tileentity;

import appeng.api.movable.IMovableTile;
import com.brandon3055.brandonscore.blocks.TileInventoryBase;
import com.brandon3055.brandonscore.lib.ChatHelper;
import com.brandon3055.brandonscore.lib.datamanager.IManagedData;
import com.brandon3055.brandonscore.lib.datamanager.ManagedInt;
import com.brandon3055.brandonscore.utils.InventoryUtils;
import com.brandon3055.brandonscore.utils.Teleporter;
import com.brandon3055.draconicevolution.DEFeatures;
import com.brandon3055.draconicevolution.api.ITeleportEndPoint;
import com.brandon3055.draconicevolution.handlers.DislocatorLinkHandler;
import com.brandon3055.draconicevolution.items.tools.Dislocator;
import com.brandon3055.draconicevolution.lib.DESoundHandler;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.common.Optional;

@Optional.Interface(modid="appliedenergistics2", iface="appeng.api.movable.IMovableTile")
public class TileDislocatorPedestal
extends TileInventoryBase
implements ITeleportEndPoint,
IMovableTile {
    public final ManagedInt rotation = (ManagedInt)this.register("rotation", (IManagedData)new ManagedInt(0)).saveToTile().syncViaTile().trigerUpdate().finish();

    public TileDislocatorPedestal() {
        this.setInventorySize(1);
    }

    public boolean onBlockActivated(EntityPlayer player) {
        if (this.field_145850_b.field_72995_K) {
            return true;
        }
        ItemStack stack = this.func_70301_a(0);
        if (!player.func_70093_af() && !stack.func_190926_b()) {
            if (stack.func_77973_b() instanceof Dislocator) {
                boolean silenced;
                Teleporter.TeleportLocation location = ((Dislocator)stack.func_77973_b()).getLocation(stack, this.field_145850_b);
                if (location == null) {
                    if (DEFeatures.dislocatorBound.isValid(stack)) {
                        if (DEFeatures.dislocatorBound.isPlayer(stack)) {
                            ChatHelper.translate((ICommandSender)player, (String)"info.de.bound_dislocator.cant_find_player", (TextFormatting)TextFormatting.RED, (Object[])new Object[0]);
                        } else {
                            ChatHelper.translate((ICommandSender)player, (String)"info.de.bound_dislocator.cant_find_target", (TextFormatting)TextFormatting.RED, (Object[])new Object[0]);
                        }
                    }
                    return true;
                }
                if (DEFeatures.dislocatorBound.isValid(stack)) {
                    location.setYaw(player.field_70177_z);
                    location.setPitch(player.field_70125_A);
                }
                boolean bl = silenced = this.field_145850_b.func_180495_p(this.field_174879_c.func_177977_b()).func_177230_c() == Blocks.field_150325_L;
                if (!silenced) {
                    DESoundHandler.playSoundFromServer(player.field_70170_p, player.field_70165_t, player.field_70163_u, player.field_70161_v, DESoundHandler.portal, SoundCategory.PLAYERS, 0.1f, player.field_70170_p.field_73012_v.nextFloat() * 0.1f + 0.9f, false, 32.0);
                }
                DEFeatures.dislocatorBound.notifyArriving(stack, player.field_70170_p, (Entity)player);
                location.teleport((Entity)player);
                if (!silenced) {
                    DESoundHandler.playSoundFromServer(player.field_70170_p, player.field_70165_t, player.field_70163_u, player.field_70161_v, DESoundHandler.portal, SoundCategory.PLAYERS, 0.1f, player.field_70170_p.field_73012_v.nextFloat() * 0.1f + 0.9f, false, 32.0);
                }
            }
            return true;
        }
        InventoryUtils.handleHeldStackTransfer((int)0, (IInventory)this, (EntityPlayer)player);
        if (DEFeatures.dislocatorBound.isValid(stack) && !DEFeatures.dislocatorBound.isPlayer(stack) && this.func_70301_a(0).func_190926_b()) {
            DislocatorLinkHandler.updateLink(this.field_145850_b, stack, player);
        }
        this.checkIn();
        this.func_70296_d();
        this.updateBlock();
        return true;
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return stack.func_77973_b() instanceof Dislocator;
    }

    @Override
    public BlockPos getArrivalPos(String linkID) {
        if (!DEFeatures.dislocatorBound.isValid(this.func_70301_a(0)) || !DEFeatures.dislocatorBound.getLinkID(this.func_70301_a(0)).equals(linkID)) {
            return null;
        }
        return this.func_174877_v();
    }

    @Override
    public void entityArriving(Entity entity) {
    }

    public void checkIn() {
        ItemStack stack = this.func_70301_a(0);
        if (DEFeatures.dislocatorBound.isValid(stack) && !DEFeatures.dislocatorBound.isPlayer(stack)) {
            DislocatorLinkHandler.updateLink(this.field_145850_b, stack, this.field_174879_c, this.field_145850_b.field_73011_w.getDimension());
        }
    }

    @Optional.Method(modid="appliedenergistics2")
    public boolean prepareToMove() {
        return true;
    }

    @Optional.Method(modid="appliedenergistics2")
    public void doneMoving() {
        this.checkIn();
    }
}

