/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.client.render.entity;

import icbm.classic.content.entity.EntityLightBeam;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class RenderLightBeam
extends Render<EntityLightBeam> {
    public static final ResourceLocation TEXTURE_BEACON_BEAM = new ResourceLocation("textures/entity/beacon_beam.png");

    public RenderLightBeam(RenderManager renderManager) {
        super(renderManager);
    }

    public void doRender(EntityLightBeam beamEntity, double x, double y, double z, float entityYaw, float partialTicks) {
        GlStateManager.func_179092_a((int)516, (float)0.1f);
        this.func_110776_a(TEXTURE_BEACON_BEAM);
        GlStateManager.func_179106_n();
        int height = 255 - (int)beamEntity.field_70163_u;
        float beamGrowthRate = beamEntity.beamGrowthRate * partialTicks;
        if (beamEntity.clientBeamProgress < beamEntity.getBeamProgress()) {
            beamEntity.clientBeamProgress = Math.min(beamEntity.getBeamProgress(), beamEntity.clientBeamProgress + beamGrowthRate);
        } else if (beamEntity.clientBeamProgress > beamEntity.getBeamProgress()) {
            beamEntity.clientBeamProgress = Math.max(beamEntity.getBeamProgress(), beamEntity.clientBeamProgress - beamGrowthRate);
        }
        float beamRadius = Math.max(0.0f, beamEntity.clientBeamProgress * beamEntity.beamSize);
        float beamGlowRadius = Math.max(0.0f, beamEntity.clientBeamProgress * beamEntity.beamGlowSize);
        RenderLightBeam.renderBeamSegment(x, y - 5.0, z, partialTicks, 1.0, beamEntity.field_70173_aa, height, beamEntity.red, beamEntity.green, beamEntity.blue, beamRadius, beamGlowRadius);
        GlStateManager.func_179127_m();
    }

    public static void renderBeamSegment(double x, double y, double z, double partialTicks, double textureScale, double totalWorldTime, int height, float color_red, float color_green, float color_blue, double beamRadius, double glowRadius) {
        GlStateManager.func_187421_b((int)3553, (int)10242, (int)10497);
        GlStateManager.func_187421_b((int)3553, (int)10243, (int)10497);
        GlStateManager.func_179140_f();
        GlStateManager.func_179129_p();
        GlStateManager.func_179084_k();
        GlStateManager.func_179132_a((boolean)true);
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        double time = totalWorldTime + partialTicks;
        double uv_animation = MathHelper.func_181162_h((double)(time * 0.2 - (double)MathHelper.func_76128_c((double)(time * 0.1))));
        double nw_corner_x = 0.5 - beamRadius;
        double nw_corner_z = 0.5 - beamRadius;
        double ne_corner_x = 0.5 + beamRadius;
        double ne_corner_z = 0.5 - beamRadius;
        double sw_corner_x = 0.5 - beamRadius;
        double sw_corner_z = 0.5 + beamRadius;
        double se_corner_x = 0.5 + beamRadius;
        double se_corner_z = 0.5 + beamRadius;
        double uv_bottom = -1.0 + uv_animation;
        double uv_top = (double)height * textureScale + uv_bottom;
        RenderLightBeam.renderBeamTube(x, y, z, height, color_red, color_green, color_blue, tessellator, bufferbuilder, nw_corner_x, nw_corner_z, ne_corner_x, ne_corner_z, sw_corner_x, sw_corner_z, se_corner_x, se_corner_z, uv_bottom, uv_top);
        GlStateManager.func_179147_l();
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        GlStateManager.func_179132_a((boolean)false);
        nw_corner_x = 0.5 - glowRadius;
        nw_corner_z = 0.5 - glowRadius;
        ne_corner_x = 0.5 + glowRadius;
        ne_corner_z = 0.5 - glowRadius;
        sw_corner_x = 0.5 - glowRadius;
        sw_corner_z = 0.5 + glowRadius;
        se_corner_x = 0.5 + glowRadius;
        se_corner_z = 0.5 + glowRadius;
        uv_bottom = -1.0;
        uv_top = (double)height * textureScale + uv_bottom;
        RenderLightBeam.renderBeamTube(x, y, z, height, color_red, color_green, color_blue, tessellator, bufferbuilder, nw_corner_x, nw_corner_z, ne_corner_x, ne_corner_z, sw_corner_x, sw_corner_z, se_corner_x, se_corner_z, uv_bottom, uv_top);
        GlStateManager.func_179145_e();
        GlStateManager.func_179098_w();
        GlStateManager.func_179132_a((boolean)true);
    }

    private static void renderBeamTube(double x, double y, double z, int height, float color_red, float color_green, float color_blue, Tessellator tessellator, BufferBuilder bufferbuilder, double nw_corner_x, double nw_corner_z, double ne_corner_x, double ne_corner_z, double sw_corner_x, double sw_corner_z, double se_corner_x, double se_corner_z, double uv_bottom, double uv_top) {
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181709_i);
        bufferbuilder.func_181662_b(x + nw_corner_x, y + (double)height, z + nw_corner_z).func_187315_a(1.0, uv_top).func_181666_a(color_red, color_green, color_blue, 0.125f).func_181675_d();
        bufferbuilder.func_181662_b(x + nw_corner_x, y, z + nw_corner_z).func_187315_a(1.0, uv_bottom).func_181666_a(color_red, color_green, color_blue, 0.125f).func_181675_d();
        bufferbuilder.func_181662_b(x + ne_corner_x, y, z + ne_corner_z).func_187315_a(0.0, uv_bottom).func_181666_a(color_red, color_green, color_blue, 0.125f).func_181675_d();
        bufferbuilder.func_181662_b(x + ne_corner_x, y + (double)height, z + ne_corner_z).func_187315_a(0.0, uv_top).func_181666_a(color_red, color_green, color_blue, 0.125f).func_181675_d();
        bufferbuilder.func_181662_b(x + se_corner_x, y + (double)height, z + se_corner_z).func_187315_a(1.0, uv_top).func_181666_a(color_red, color_green, color_blue, 0.125f).func_181675_d();
        bufferbuilder.func_181662_b(x + se_corner_x, y, z + se_corner_z).func_187315_a(1.0, uv_bottom).func_181666_a(color_red, color_green, color_blue, 0.125f).func_181675_d();
        bufferbuilder.func_181662_b(x + sw_corner_x, y, z + sw_corner_z).func_187315_a(0.0, uv_bottom).func_181666_a(color_red, color_green, color_blue, 0.125f).func_181675_d();
        bufferbuilder.func_181662_b(x + sw_corner_x, y + (double)height, z + sw_corner_z).func_187315_a(0.0, uv_top).func_181666_a(color_red, color_green, color_blue, 0.125f).func_181675_d();
        bufferbuilder.func_181662_b(x + ne_corner_x, y + (double)height, z + ne_corner_z).func_187315_a(1.0, uv_top).func_181666_a(color_red, color_green, color_blue, 0.125f).func_181675_d();
        bufferbuilder.func_181662_b(x + ne_corner_x, y, z + ne_corner_z).func_187315_a(1.0, uv_bottom).func_181666_a(color_red, color_green, color_blue, 0.125f).func_181675_d();
        bufferbuilder.func_181662_b(x + se_corner_x, y, z + se_corner_z).func_187315_a(0.0, uv_bottom).func_181666_a(color_red, color_green, color_blue, 0.125f).func_181675_d();
        bufferbuilder.func_181662_b(x + se_corner_x, y + (double)height, z + se_corner_z).func_187315_a(0.0, uv_top).func_181666_a(color_red, color_green, color_blue, 0.125f).func_181675_d();
        bufferbuilder.func_181662_b(x + sw_corner_x, y + (double)height, z + sw_corner_z).func_187315_a(1.0, uv_top).func_181666_a(color_red, color_green, color_blue, 0.125f).func_181675_d();
        bufferbuilder.func_181662_b(x + sw_corner_x, y, z + sw_corner_z).func_187315_a(1.0, uv_bottom).func_181666_a(color_red, color_green, color_blue, 0.125f).func_181675_d();
        bufferbuilder.func_181662_b(x + nw_corner_x, y, z + nw_corner_z).func_187315_a(0.0, uv_bottom).func_181666_a(color_red, color_green, color_blue, 0.125f).func_181675_d();
        bufferbuilder.func_181662_b(x + nw_corner_x, y + (double)height, z + nw_corner_z).func_187315_a(0.0, uv_top).func_181666_a(color_red, color_green, color_blue, 0.125f).func_181675_d();
        tessellator.func_78381_a();
    }

    protected ResourceLocation getEntityTexture(EntityLightBeam entity) {
        return TEXTURE_BEACON_BEAM;
    }
}

