/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.content.blocks.emptower;

import icbm.classic.ICBMClassic;
import icbm.classic.api.ICBMClassicAPI;
import icbm.classic.api.explosion.BlastState;
import icbm.classic.api.explosion.IBlast;
import icbm.classic.api.refs.ICBMExplosives;
import icbm.classic.client.ICBMSounds;
import icbm.classic.config.ConfigMain;
import icbm.classic.config.machines.ConfigEmpTower;
import icbm.classic.content.blast.BlastEMP;
import icbm.classic.content.blocks.emptower.RadioEmpTower;
import icbm.classic.content.blocks.emptower.TileEmpTowerFake;
import icbm.classic.content.blocks.emptower.gui.ContainerEMPTower;
import icbm.classic.content.blocks.emptower.gui.GuiEMPTower;
import icbm.classic.lib.data.IMachineInfo;
import icbm.classic.lib.energy.storage.EnergyBuffer;
import icbm.classic.lib.energy.system.EnergySystem;
import icbm.classic.lib.network.lambda.PacketCodex;
import icbm.classic.lib.network.lambda.PacketCodexReg;
import icbm.classic.lib.network.lambda.tile.PacketCodexTile;
import icbm.classic.lib.radio.RadioRegistry;
import icbm.classic.lib.radio.imp.Radio;
import icbm.classic.lib.saving.NbtSaveHandler;
import icbm.classic.lib.tile.TickAction;
import icbm.classic.lib.tile.TickDoOnce;
import icbm.classic.prefab.gui.IPlayerUsing;
import icbm.classic.prefab.inventory.InventorySlot;
import icbm.classic.prefab.inventory.InventoryWithSlots;
import icbm.classic.prefab.tile.IGuiTile;
import icbm.classic.prefab.tile.TileMachine;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.function.BiConsumer;
import javax.annotation.Nullable;
import lombok.Generated;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.items.CapabilityItemHandler;

public class TileEMPTower
extends TileMachine
implements IGuiTile,
IMachineInfo,
IPlayerUsing {
    public static final ResourceLocation REGISTRY_NAME = new ResourceLocation("icbmclassic", "emptower");
    public static final int ROTATION_SPEED = 15;
    public float rotation = 0.0f;
    public float prevRotation = 0.0f;
    protected int cooldownTicks = 0;
    public int range = 60;
    public final EnergyBuffer energyStorage = new EnergyBuffer(() -> this.getFiringCost() + this.getTickingCost() * ConfigEmpTower.ENERGY_COST_TICKING_CAP).withOnChange((p, c, s) -> this.func_70296_d()).withCanReceive(() -> this.getCooldown() <= 0).withCanExtract(() -> false).withReceiveLimit(() -> ConfigEmpTower.ENERGY_INPUT);
    public final InventoryWithSlots inventory = new InventoryWithSlots(1).withChangeCallback((s, i) -> this.func_70296_d()).withSlot(new InventorySlot(0, EnergySystem::isEnergyItem).withTick(this.energyStorage::dischargeItem));
    public final RadioEmpTower radioCap = new RadioEmpTower(this);
    private final List<TileEmpTowerFake> subBlocks = new ArrayList<TileEmpTowerFake>();
    private final TickDoOnce descriptionPacketSender = new TickDoOnce(t -> PACKET_DESCRIPTION.sendToAllAround(this));
    private final List<EntityPlayer> playersUsing = new LinkedList<EntityPlayer>();
    private static final NbtSaveHandler<TileEMPTower> SAVE_LOGIC = new NbtSaveHandler().mainRoot().nodeINBTSerializable("inventory", tile -> tile.inventory).nodeINBTSerializable("radio", tile -> tile.radioCap).nodeInteger("range", tile -> tile.range, (tile, i) -> {
        tile.range = i;
    }).nodeInteger("cooldown", tile -> tile.cooldownTicks, (tile, i) -> {
        tile.cooldownTicks = i;
    }).nodeInteger("energy", tile -> tile.energyStorage.getEnergyStored(), (tile, i) -> tile.energyStorage.setEnergyStored((int)i)).nodeFloat("rotation", tile -> Float.valueOf(tile.rotation), (tile, f) -> {
        tile.rotation = f.floatValue();
    }).nodeFloat("prev_rotation", tile -> Float.valueOf(tile.prevRotation), (tile, f) -> {
        tile.prevRotation = f.floatValue();
    }).base();
    public static final PacketCodex<TileEMPTower, TileEMPTower> PACKET_RADIUS = new PacketCodexTile(REGISTRY_NAME, "radius").fromClient().nodeInt(TileEMPTower::getRange, TileEMPTower::setRange).onFinished((tile, target, player) -> tile.func_70296_d());
    public static final PacketCodex<TileEMPTower, RadioEmpTower> PACKET_RADIO_HZ = new PacketCodexTile<TileEMPTower, RadioEmpTower>(REGISTRY_NAME, "radio.frequency", tile -> tile.radioCap).fromClient().nodeString(Radio::getChannel, Radio::setChannel).onFinished((tile, target, player) -> tile.func_70296_d());
    public static final PacketCodex<TileEMPTower, RadioEmpTower> PACKET_RADIO_DISABLE = new PacketCodexTile<TileEMPTower, RadioEmpTower>(REGISTRY_NAME, "radio.disable", tile -> tile.radioCap).fromClient().toggleBoolean(Radio::isDisabled, Radio::setDisabled).onFinished((tile, target, player) -> tile.func_70296_d());
    public static final PacketCodex<TileEMPTower, TileEMPTower> PACKET_GUI = new PacketCodexTile(REGISTRY_NAME, "gui").fromServer().nodeInt(t -> t.energyStorage.getEnergyStored(), (t, i) -> t.energyStorage.setEnergyStored((int)i)).nodeString(t -> t.radioCap.getChannel(), (t, s) -> t.radioCap.setChannel((String)s)).nodeBoolean(t -> t.radioCap.isDisabled(), (t, b) -> t.radioCap.setDisabled((boolean)b)).nodeInt(TileEMPTower::getRange, TileEMPTower::setRange);
    public static final PacketCodex<TileEMPTower, TileEMPTower> PACKET_FIRE = new PacketCodexTile(REGISTRY_NAME, "fire").fromClient().onFinished((tile, target, player) -> {
        tile.fire();
        tile.func_70296_d();
    });
    public static final PacketCodexTile<TileEMPTower, TileEMPTower> PACKET_DESCRIPTION = (PacketCodexTile)new PacketCodexTile(REGISTRY_NAME, "description").fromServer().nodeFloat(t -> Float.valueOf(t.rotation), (t, f) -> {
        t.rotation = f.floatValue();
    }).nodeInt(t -> t.cooldownTicks, (t, f) -> {
        t.cooldownTicks = f;
    });

    public TileEMPTower() {
        this.tickActions.add(this.descriptionPacketSender);
        this.tickActions.add(new TickAction(3, true, t -> PACKET_GUI.sendPacketToGuiUsers(this, this.playersUsing)));
        this.tickActions.add(new TickAction(20, true, t -> this.playersUsing.removeIf(player -> !(player.field_71070_bA instanceof ContainerEMPTower))));
        this.tickActions.add(this.inventory);
        this.tickActions.add(new TickAction(5, t -> this.updateStructure()));
    }

    public void func_70296_d() {
        super.func_70296_d();
        if (this.isServer()) {
            this.descriptionPacketSender.doNext();
        }
    }

    @Override
    public void provideInformation(BiConsumer<String, Object> consumer) {
        consumer.accept("NEEDS_POWER", ConfigMain.REQUIRES_POWER);
        consumer.accept("ENERGY_COST_TICK", this.getTickingCost());
        consumer.accept("ENERGY_COST_ACTION", this.getFiringCost());
        consumer.accept("ENERGY_RECEIVE_LIMIT", ConfigEmpTower.ENERGY_INPUT);
        consumer.accept("COOLING_TICKS", this.getMaxCooldown());
        consumer.accept("MAX_RANGE", this.getMaxRadius());
    }

    public void onLoad() {
        super.onLoad();
        if (this.isServer()) {
            RadioRegistry.add(this.radioCap);
        }
    }

    public void func_145843_s() {
        super.func_145843_s();
        this.subBlocks.forEach(tile -> tile.setHost(null));
        this.subBlocks.clear();
        if (this.isServer()) {
            RadioRegistry.remove(this.radioCap);
        }
    }

    protected void updateStructure() {
        this.subBlocks.clear();
        BlockPos above = this.func_174877_v().func_177984_a();
        while (this.field_145850_b.func_180495_p(above).func_177230_c() == this.func_145838_q()) {
            TileEntity tile = this.field_145850_b.func_175625_s(above);
            if (tile instanceof TileEmpTowerFake) {
                ((TileEmpTowerFake)tile).setHost(this);
                this.subBlocks.add((TileEmpTowerFake)tile);
            }
            above = above.func_177984_a();
        }
    }

    @Override
    public void func_73660_a() {
        block9: {
            block8: {
                super.func_73660_a();
                if (this.isServer()) {
                    this.energyStorage.consumePower(this.getTickingCost(), false);
                    if (this.ticks % 20 == 0 && this.isReady()) {
                        ICBMSounds.MACHINE_HUM.play(this.field_145850_b, (double)this.func_174877_v().func_177958_n() + 0.5, (double)this.func_174877_v().func_177956_o() + 0.5, (double)this.func_174877_v().func_177952_p() + 0.5, 0.5f, 0.85f * this.getChargePercentage(), true);
                    } else if (this.getCooldown() > 0 && this.ticks % 10 == this.field_145850_b.field_73012_v.nextInt(10)) {
                        this.field_145850_b.func_184133_a(null, this.func_174877_v(), SoundEvents.field_187659_cY, SoundCategory.BLOCKS, 0.5f, this.field_145850_b.field_73012_v.nextFloat() * 0.15f + 0.6f);
                    }
                    if (this.isReady() && this.field_145850_b.func_175676_y(this.func_174877_v()) > 0) {
                        this.fire();
                    }
                }
                this.prevRotation = this.rotation;
                if (this.cooldownTicks <= 0) break block8;
                --this.cooldownTicks;
                if (this.ticks % 5 != 0) break block9;
                for (int i = 0; i <= this.subBlocks.size(); ++i) {
                    float rotation = this.rotation;
                    int side = this.field_145850_b.field_73012_v.nextInt(4);
                    this.spawnParticles((rotation += (float)side * 90.0f) + 45.0f, i);
                }
                break block9;
            }
            this.rotation += this.getChargePercentage() * 15.0f;
            this.clamp(this.rotation);
            while (this.rotation - this.prevRotation < -180.0f) {
                this.prevRotation -= 360.0f;
            }
            while (this.rotation - this.prevRotation >= 180.0f) {
                this.prevRotation += 360.0f;
            }
        }
    }

    private void spawnParticles(float rotation, int yOffset) {
        float faceWidth = 0.4375f;
        float faceHeight = 0.5625f;
        float faceYOffset = 0.3125f;
        float faceWOffset = 0.21875f;
        double faceA = 0.4375f * this.field_145850_b.field_73012_v.nextFloat() - 0.21875f;
        double faceB = 0.5625f * this.field_145850_b.field_73012_v.nextFloat();
        double rad = Math.toRadians(this.clamp(rotation));
        double rad2 = Math.toRadians(this.clamp(rotation + 90.0f));
        double vecX = Math.sin(rad) * 0.21875;
        double vecZ = Math.cos(rad) * 0.21875;
        double faceX = Math.sin(rad2) * faceA;
        double faceZ = Math.cos(rad2) * faceA;
        double x = (double)this.field_174879_c.func_177958_n() + 0.5;
        double y = (float)(this.field_174879_c.func_177956_o() + yOffset) + 0.3125f - 0.2f;
        double z = (double)this.field_174879_c.func_177952_p() + 0.5;
        double d0 = x + vecX + faceX;
        double d1 = y + 0.3125 + faceB;
        double d2 = z + vecZ + faceZ;
        this.field_145850_b.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, d0, d1, d2, 0.0, 0.0, 0.0, new int[0]);
    }

    private float clamp(float rotation) {
        while (rotation > 180.0f) {
            rotation -= 360.0f;
        }
        return rotation;
    }

    public float getChargePercentage() {
        return Math.max(0.0f, Math.min(1.0f, (float)this.energyStorage.getEnergyStored() / (float)this.getFiringCost()));
    }

    public int getFiringCost() {
        return this.range * this.range * ConfigEmpTower.ENERGY_COST_AREA;
    }

    public int getTickingCost() {
        return this.range * ConfigEmpTower.ENERGY_COST_TICKING;
    }

    public int getMaxRadius() {
        return ConfigEmpTower.MAX_BASE_RANGE + this.subBlocks.size() * ConfigEmpTower.BONUS_RADIUS;
    }

    public void setRange(int range) {
        this.range = Math.min(range, this.getMaxRadius());
    }

    protected IBlast buildBlast() {
        return ((BlastEMP)ICBMExplosives.EMP.create().setBlastWorld(this.field_145850_b).setBlastPosition((double)this.func_174877_v().func_177958_n() + 0.5, (double)this.func_174877_v().func_177956_o() + 1.2, (double)this.func_174877_v().func_177952_p() + 0.5).setBlastSize(this.range)).clearSetEffectBlocksAndEntities().setEffectBlocks().setEffectEntities().buildBlast();
    }

    public boolean fire() {
        if (this.isReady()) {
            if (this.buildBlast().runBlast().state == BlastState.TRIGGERED) {
                this.energyStorage.consumePower(this.getFiringCost(), false);
                this.cooldownTicks = this.getMaxCooldown();
                return true;
            }
            ICBMClassic.logger().warn("TileEmpTower( DIM: " + this.field_145850_b.field_73011_w.getDimension() + ", " + this.func_174877_v() + ") EMP did not trigger, likely was blocked.");
        }
        return false;
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return INFINITE_EXTENT_AABB;
    }

    public boolean isReady() {
        return this.getCooldown() <= 0 && this.energyStorage.consumePower(this.getFiringCost(), true);
    }

    public int getCooldown() {
        return this.cooldownTicks;
    }

    public float getCooldownPercentage() {
        return 1.0f - (float)this.cooldownTicks / (float)this.getMaxCooldown();
    }

    public int getMaxCooldown() {
        return ConfigEmpTower.COOLDOWN;
    }

    @Override
    public Object getServerGuiElement(int ID, EntityPlayer player) {
        return new ContainerEMPTower(player, this);
    }

    @Override
    public Object getClientGuiElement(int ID, EntityPlayer player) {
        return new GuiEMPTower(player, this);
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        return super.hasCapability(capability, facing) || capability == CapabilityEnergy.ENERGY && ConfigMain.REQUIRES_POWER || capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || capability == ICBMClassicAPI.RADIO_CAPABILITY;
    }

    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityEnergy.ENERGY) {
            return (T)this.energyStorage;
        }
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)this.inventory;
        }
        if (capability == ICBMClassicAPI.RADIO_CAPABILITY) {
            return (T)this.radioCap;
        }
        return (T)super.getCapability(capability, facing);
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        SAVE_LOGIC.load(this, nbt);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        SAVE_LOGIC.save(this, nbt);
        return super.func_189515_b(nbt);
    }

    public static void register() {
        GameRegistry.registerTileEntity(TileEMPTower.class, (ResourceLocation)REGISTRY_NAME);
        PacketCodexReg.register(PACKET_RADIUS, PACKET_RADIO_HZ, PACKET_GUI, PACKET_FIRE, PACKET_RADIO_DISABLE, PACKET_DESCRIPTION);
    }

    @Generated
    public int getRange() {
        return this.range;
    }

    @Generated
    public List<EntityPlayer> getPlayersUsing() {
        return this.playersUsing;
    }
}

