/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.lib.explosive.reg;

import icbm.classic.api.EnumTier;
import icbm.classic.api.explosion.IBlastFactory;
import icbm.classic.api.reg.IExplosiveData;
import icbm.classic.api.reg.content.IExplosiveContentRegistry;
import java.util.HashSet;
import java.util.Set;
import lombok.Generated;
import net.minecraft.util.ResourceLocation;

public class ExplosiveData
implements IExplosiveData {
    public final ResourceLocation regName;
    public final int id;
    public final EnumTier tier;
    public IBlastFactory blastCreationFactory;
    public final Set<ResourceLocation> enabledContent = new HashSet<ResourceLocation>();
    public boolean enabled = true;

    public ExplosiveData(ResourceLocation regName, int id, EnumTier tier) {
        this.regName = regName;
        this.id = id;
        this.tier = tier;
    }

    public ExplosiveData blastFactory(IBlastFactory factory) {
        this.blastCreationFactory = factory;
        return this;
    }

    @Override
    public ResourceLocation getRegistryName() {
        return this.regName;
    }

    @Override
    public int getRegistryID() {
        return this.id;
    }

    @Override
    public IBlastFactory getBlastFactory() {
        return this.blastCreationFactory;
    }

    @Override
    public EnumTier getTier() {
        return this.tier;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void setEnabled(boolean b) {
        this.enabled = b;
    }

    @Override
    public boolean onEnableContent(ResourceLocation contentID, IExplosiveContentRegistry registry) {
        this.enabledContent.add(contentID);
        return true;
    }

    public boolean equals(Object object) {
        if (object instanceof ExplosiveData) {
            return ((ExplosiveData)object).id == this.id;
        }
        return false;
    }

    @Override
    public int compareTo(IExplosiveData o) {
        return Integer.compare(this.getRegistryID(), o.getRegistryID());
    }

    @Generated
    public String toString() {
        return "ExplosiveData(regName=" + this.regName + ", id=" + this.id + ")";
    }
}

