/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.lib.network;

import icbm.classic.ICBMClassic;
import icbm.classic.lib.network.lambda.PacketCodex;
import icbm.classic.lib.network.lambda.PacketEventUtils;
import icbm.classic.lib.tracker.EventTrackerHelpers;
import icbm.classic.lib.tracker.EventTrackerType;
import net.minecraft.util.ResourceLocation;

public class PacketEvents {
    public static final ResourceLocation EXPECTED_WORLD = new ResourceLocation("icbmclassic", "level.id.expected");
    public static final EventTrackerType WRONG_WORLD = new EventTrackerType.Builder(new ResourceLocation("icbmclassic", "packet.tile.error.handling")).asWarn().with(PacketEventUtils.fieldCodexId(0)).with(PacketEventUtils.fieldCodexKey(1)).withString(EventTrackerHelpers.WORLD_SIDE, EventTrackerHelpers.stringAt(2)).withInt(EventTrackerHelpers.WORLD_ID, EventTrackerHelpers.intAt(3)).withInt(EXPECTED_WORLD, EventTrackerHelpers.intAt(4)).listen(new ResourceLocation("icbmclassic", "logger"), () -> ICBMClassic.logger().isDebugEnabled(), entry -> {
        String ERROR_MSG = "Packet(%s, %s): Received packet on side %s for world(%s) but got world(%s)... ignoring.";
        String message = String.format("Packet(%s, %s): Received packet on side %s for world(%s) but got world(%s)... ignoring.", entry.getString(PacketEventUtils.CODEX_ID, "?"), entry.getString(PacketEventUtils.CODEX_KEY, "?"), entry.getString(EventTrackerHelpers.WORLD_SIDE, "?"), entry.getString(EventTrackerHelpers.WORLD_ID, "?"), entry.getString(EXPECTED_WORLD, "?"));
        ICBMClassic.logger().debug(message);
    }).build();
    public static final EventTrackerType NOT_SERVER_WORLD = new EventTrackerType.Builder(new ResourceLocation("icbmclassic", "packet.tile.error.handling")).asWarn().with(PacketEventUtils.fieldCodexId(0)).with(PacketEventUtils.fieldCodexKey(1)).withInt(EventTrackerHelpers.WORLD_ID, EventTrackerHelpers.intAt(2)).listen(new ResourceLocation("icbmclassic", "logger"), () -> ICBMClassic.logger().isDebugEnabled(), entry -> {
        String ERROR_MSG = "Packet(%s, %s): Received packet server side but world(%s) is not WorldServer";
        String message = String.format("Packet(%s, %s): Received packet server side but world(%s) is not WorldServer", entry.getString(PacketEventUtils.CODEX_ID, "?"), entry.getString(PacketEventUtils.CODEX_KEY, "?"), entry.getString(EventTrackerHelpers.WORLD_ID, "?"));
        ICBMClassic.logger().debug(message);
    }).build();

    public static void onWrongWorld(PacketCodex builder, String side, int expected, int received) {
        ICBMClassic.MAIN_TRACKER.post(WRONG_WORLD, () -> new Object[]{PacketEventUtils.getPacketId(builder), PacketEventUtils.getPacketName(builder), side, received, expected});
    }

    public static void onNotServerWorld(PacketCodex builder, int dim) {
        ICBMClassic.MAIN_TRACKER.post(NOT_SERVER_WORLD, () -> new Object[]{PacketEventUtils.getPacketId(builder), PacketEventUtils.getPacketName(builder), dim});
    }
}

