/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.lib.saving;

import icbm.classic.api.missiles.parts.IBuildableObject;
import icbm.classic.api.reg.obj.IBuilderRegistry;
import icbm.classic.lib.saving.INbtSaveNode;
import icbm.classic.lib.saving.NbtSaveHandler;
import icbm.classic.lib.saving.NbtSaveNode;
import icbm.classic.lib.saving.nodes.SaveBuildableObject;
import icbm.classic.lib.saving.nodes.SaveNodeBlockPos;
import icbm.classic.lib.saving.nodes.SaveNodeBlockState;
import icbm.classic.lib.saving.nodes.SaveNodeBoolean;
import icbm.classic.lib.saving.nodes.SaveNodeCompoundTag;
import icbm.classic.lib.saving.nodes.SaveNodeDouble;
import icbm.classic.lib.saving.nodes.SaveNodeFacing;
import icbm.classic.lib.saving.nodes.SaveNodeFloat;
import icbm.classic.lib.saving.nodes.SaveNodeInteger;
import icbm.classic.lib.saving.nodes.SaveNodeItemStack;
import icbm.classic.lib.saving.nodes.SaveNodePos;
import icbm.classic.lib.saving.nodes.SaveNodeResourceLocation;
import icbm.classic.lib.saving.nodes.SaveNodeString;
import icbm.classic.lib.saving.nodes.SaveNodeUUID;
import icbm.classic.lib.saving.nodes.SaveNodeVec3d;
import icbm.classic.lib.transform.rotation.EulerAngle;
import icbm.classic.lib.transform.vector.Pos;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.util.INBTSerializable;

public class NbtSaveRoot<E>
implements INbtSaveNode<E, NBTTagCompound> {
    private final String name;
    private final NbtSaveHandler<E> handler;
    private final NbtSaveRoot<E> parent;
    public final List<INbtSaveNode> nodes = new LinkedList<INbtSaveNode>();
    private boolean shouldSave = true;

    public NbtSaveRoot(String name, NbtSaveHandler<E> handler, NbtSaveRoot<E> parent) {
        if (name == null) {
            throw new IllegalArgumentException("save key can't be null");
        }
        this.name = name;
        this.handler = handler;
        this.parent = parent;
    }

    public NbtSaveRoot<E> disableSave() {
        this.shouldSave = false;
        return this;
    }

    @Override
    public String getSaveKey() {
        return this.name;
    }

    @Override
    public NBTTagCompound save(E objectToSave) {
        if (!this.shouldSave) {
            return null;
        }
        return this.save(objectToSave, new NBTTagCompound());
    }

    protected NBTTagCompound save(E objectToSave, NBTTagCompound tagCompound) {
        this.nodes.forEach(node -> {
            Object tag = node.save(objectToSave);
            if (tag != null && !tag.func_82582_d()) {
                tagCompound.func_74782_a(node.getSaveKey(), tag);
            }
        });
        return tagCompound;
    }

    @Override
    public void load(E objectToLoad, NBTTagCompound save) {
        if (save != null && !save.func_82582_d()) {
            this.nodes.forEach(node -> {
                if (save.func_74764_b(node.getSaveKey())) {
                    node.load(objectToLoad, save.func_74781_a(node.getSaveKey()));
                }
            });
        }
    }

    public NbtSaveRoot<E> addRoot(String name) {
        NbtSaveRoot<E> root = new NbtSaveRoot<E>(name, this.handler, this);
        this.nodes.add(root);
        return root;
    }

    public <O extends NBTBase> NbtSaveRoot<E> node(NbtSaveNode<E, O> node) {
        this.nodes.add(node);
        return this;
    }

    public NbtSaveRoot<E> nodeString(String name, Function<E, String> save, BiConsumer<E, String> load) {
        return this.node(new SaveNodeString<E>(name, save, load));
    }

    public NbtSaveRoot<E> nodeResourceLocation(String name, Function<E, ResourceLocation> save, BiConsumer<E, ResourceLocation> load) {
        return this.node(new SaveNodeResourceLocation<E>(name, save, load));
    }

    public NbtSaveRoot<E> nodeCompoundTag(String name, Function<E, NBTTagCompound> save, BiConsumer<E, NBTTagCompound> load) {
        return this.node(new SaveNodeCompoundTag<E>(name, save, load));
    }

    public NbtSaveRoot<E> nodeInteger(String name, Function<E, Integer> save, BiConsumer<E, Integer> load) {
        return this.node(new SaveNodeInteger<E>(name, save, load));
    }

    public NbtSaveRoot<E> nodeDouble(String name, Function<E, Double> save, BiConsumer<E, Double> load) {
        return this.node(new SaveNodeDouble<E>(name, save, load));
    }

    public NbtSaveRoot<E> nodeFloat(String name, Function<E, Float> save, BiConsumer<E, Float> load) {
        return this.node(new SaveNodeFloat<E>(name, save, load));
    }

    public NbtSaveRoot<E> nodeBoolean(String name, Function<E, Boolean> save, BiConsumer<E, Boolean> load) {
        return this.node(new SaveNodeBoolean<E>(name, save, load));
    }

    public NbtSaveRoot<E> nodeBlockPos(String name, Function<E, BlockPos> save, BiConsumer<E, BlockPos> load) {
        return this.node(new SaveNodeBlockPos<E>(name, save, load));
    }

    public NbtSaveRoot<E> nodeVec3d(String name, Function<E, Vec3d> save, BiConsumer<E, Vec3d> load) {
        return this.node(new SaveNodeVec3d<E>(name, save, load));
    }

    public NbtSaveRoot<E> nodeWorldDim(String name, Function<E, World> save, BiConsumer<E, World> load) {
        return this.node(new NbtSaveNode<Object, NBTTagInt>(name, e -> {
            World world = (World)save.apply(e);
            if (world != null && world.field_73011_w != null) {
                return new NBTTagInt(world.field_73011_w.getDimension());
            }
            return null;
        }, (e, data) -> {
            int dim = data.func_150287_d();
            WorldServer world = DimensionManager.getWorld((int)dim);
            load.accept((Object)e, (World)world);
        }));
    }

    @Deprecated
    public NbtSaveRoot<E> nodePos(String name, Function<E, Pos> save, BiConsumer<E, Pos> load) {
        return this.node(new SaveNodePos<E>(name, save, load));
    }

    @Deprecated
    public NbtSaveRoot<E> nodeEulerAngle(String name, Function<E, EulerAngle> save, BiConsumer<E, EulerAngle> load) {
        return this.node(new NbtSaveNode<Object, NBTTagCompound>(name, e -> {
            EulerAngle angle = (EulerAngle)save.apply(e);
            if (angle != null) {
                return angle.toNBT();
            }
            return null;
        }, (e, data) -> load.accept(e, new EulerAngle((NBTTagCompound)data))));
    }

    public NbtSaveRoot<E> nodeFacing(String name, Function<E, EnumFacing> save, BiConsumer<E, EnumFacing> load) {
        return this.node(new SaveNodeFacing<E>(name, save, load));
    }

    public NbtSaveRoot<E> nodeBlockState(String name, Function<E, IBlockState> save, BiConsumer<E, IBlockState> load) {
        return this.node(new SaveNodeBlockState<E>(name, save, load));
    }

    public NbtSaveRoot<E> nodeUUID(String name, Function<E, UUID> save, BiConsumer<E, UUID> load) {
        return this.node(new SaveNodeUUID<E>(name, save, load));
    }

    public <C extends IBuildableObject> NbtSaveRoot<E> nodeBuildableObject(String name, Supplier<IBuilderRegistry<C>> reg, Function<E, C> getter, BiConsumer<E, C> setter) {
        return this.node(new SaveBuildableObject<E, C>(name, reg, getter, setter));
    }

    public <C extends INBTSerializable<NBTTagCompound>> NbtSaveRoot<E> nodeINBTSerializable(String name, Function<E, C> accessor) {
        return this.node(new NbtSaveNode<Object, NBTTagCompound>(name, source -> Optional.ofNullable(accessor.apply(source)).map(INBTSerializable::serializeNBT).orElse(null), (source, data) -> {
            INBTSerializable object = (INBTSerializable)accessor.apply(source);
            if (object != null) {
                object.deserializeNBT((NBTBase)data);
            }
        }));
    }

    public <C extends INBTSerializable<NBTTagCompound>> NbtSaveRoot<E> nodeINBTSerializable(String name, Function<E, C> save, BiConsumer<E, C> load, Supplier<C> builder) {
        return this.node(new NbtSaveNode<Object, NBTTagCompound>(name, source -> Optional.ofNullable(save.apply(source)).map(INBTSerializable::serializeNBT).orElse(null), (source, data) -> {
            INBTSerializable object = (INBTSerializable)builder.get();
            if (object != null) {
                object.deserializeNBT((NBTBase)data);
            }
            load.accept(source, object);
        }));
    }

    public NbtSaveRoot<E> nodeItemStack(String name, Function<E, ItemStack> save, BiConsumer<E, ItemStack> load) {
        return this.node(new SaveNodeItemStack<E>(name, save, load));
    }

    public NbtSaveRoot<E> parent() {
        return this.parent;
    }

    public NbtSaveHandler<E> base() {
        return this.handler;
    }
}

