/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.plugins.jei.device.coolant;

import cofh.core.util.helpers.StringHelper;
import cofh.thermalexpansion.ThermalExpansion;
import cofh.thermalexpansion.block.device.BlockDevice;
import cofh.thermalexpansion.block.dynamo.BlockDynamo;
import cofh.thermalexpansion.gui.client.device.GuiHeatSink;
import cofh.thermalexpansion.item.ItemAugment;
import cofh.thermalexpansion.plugins.jei.Drawables;
import cofh.thermalexpansion.plugins.jei.device.coolant.CoolantWrapper;
import cofh.thermalexpansion.plugins.jei.dynamo.BaseFuelCategory;
import cofh.thermalexpansion.util.managers.device.CoolantManager;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.IJeiHelpers;
import mezz.jei.api.IModRegistry;
import mezz.jei.api.gui.IDrawableStatic;
import mezz.jei.api.gui.IGuiFluidStackGroup;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeCategoryRegistration;
import net.minecraft.client.Minecraft;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class CoolantCategory
extends BaseFuelCategory<CoolantWrapper> {
    public static boolean enable = true;
    IDrawableStatic tank;

    public static void register(IRecipeCategoryRegistration registry) {
        String category = "Plugins.JEI";
        if (!(enable = ThermalExpansion.CONFIG_CLIENT.get("Coolant", category, enable))) {
            return;
        }
        IJeiHelpers jeiHelpers = registry.getJeiHelpers();
        IGuiHelper guiHelper = jeiHelpers.getGuiHelper();
        registry.addRecipeCategories(new IRecipeCategory[]{new CoolantCategory(guiHelper)});
    }

    public static void initialize(IModRegistry registry) {
        if (!enable) {
            return;
        }
        IJeiHelpers jeiHelpers = registry.getJeiHelpers();
        IGuiHelper guiHelper = jeiHelpers.getGuiHelper();
        registry.addRecipes(CoolantCategory.getRecipes(registry, guiHelper), "thermalexpansion.coolant");
        registry.addRecipeClickArea(GuiHeatSink.class, 44, 35, 16, 16, new String[]{"thermalexpansion.coolant"});
        registry.addRecipeCatalyst((Object)BlockDevice.deviceHeatSink, new String[]{"thermalexpansion.coolant"});
        registry.addRecipeCatalyst((Object)BlockDynamo.dynamoCompression, new String[]{"thermalexpansion.coolant"});
        registry.addRecipeCatalyst((Object)ItemAugment.dynamoMagmaticCoolant, new String[]{"thermalexpansion.coolant"});
    }

    public static List<CoolantWrapper> getRecipes(IModRegistry registry, IGuiHelper guiHelper) {
        ArrayList<CoolantWrapper> recipes = new ArrayList<CoolantWrapper>();
        for (String fluidName : CoolantManager.getCoolantFluids()) {
            FluidStack coolantStack = new FluidStack(FluidRegistry.getFluid((String)fluidName), 1000);
            recipes.add(new CoolantWrapper(guiHelper, coolantStack, CoolantManager.getCoolantRF(coolantStack), CoolantManager.getCoolantFactor(coolantStack)));
        }
        return recipes;
    }

    public CoolantCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.createBlankDrawable(164, 62);
        this.energyMeter = Drawables.getDrawables(guiHelper).getCoolantEmpty();
        this.durationEmpty = Drawables.getDrawables(guiHelper).getScale(10);
        this.localizedName = StringHelper.localize((String)"info.thermalexpansion.coolant");
        this.tank = Drawables.getDrawables(guiHelper).getTank(2);
    }

    @Nonnull
    public String getUid() {
        return "thermalexpansion.coolant";
    }

    @Override
    public void drawExtras(@Nonnull Minecraft minecraft) {
        super.drawExtras(minecraft);
        this.tank.draw(minecraft, 33, 7);
    }

    public void setRecipe(IRecipeLayout recipeLayout, CoolantWrapper recipeWrapper, IIngredients ingredients) {
        List inputs = ingredients.getInputs(FluidStack.class);
        IGuiFluidStackGroup guiFluidStacks = recipeLayout.getFluidStacks();
        guiFluidStacks.init(0, true, 34, 8, 16, 30, 1000, false, null);
        guiFluidStacks.set(0, (List)inputs.get(0));
    }
}

