/*
 * Decompiled with CFR 0.152.
 */
package appeng.core.features.registries.cell;

import appeng.api.storage.ICellGuiHandler;
import appeng.api.storage.ICellHandler;
import appeng.api.storage.ICellInventoryHandler;
import appeng.api.storage.ICellRegistry;
import appeng.api.storage.ISaveProvider;
import appeng.api.storage.IStorageChannel;
import appeng.api.storage.data.IAEStack;
import appeng.core.features.registries.cell.BasicCellHandler;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;

public class CellRegistry
implements ICellRegistry {
    private final List<ICellHandler> handlers = new ArrayList<ICellHandler>();
    private final List<ICellGuiHandler> guiHandlers = new ArrayList<ICellGuiHandler>();

    @Override
    public void addCellHandler(ICellHandler handler) {
        Preconditions.checkNotNull((Object)handler, (Object)"Called before FMLInitializationEvent.");
        Preconditions.checkArgument((!this.handlers.contains(handler) ? 1 : 0) != 0, (Object)"Tried to register the same handler instance twice.");
        this.handlers.add(handler);
        Verify.verify((boolean)(this.handlers.get(0) instanceof BasicCellHandler));
    }

    @Override
    public boolean isCellHandled(ItemStack is) {
        if (is.func_190926_b()) {
            return false;
        }
        for (ICellHandler ch : this.handlers) {
            if (!ch.isCell(is)) continue;
            return true;
        }
        return false;
    }

    @Override
    public ICellHandler getHandler(ItemStack is) {
        if (is.func_190926_b()) {
            return null;
        }
        for (ICellHandler ch : this.handlers) {
            if (!ch.isCell(is)) continue;
            return ch;
        }
        return null;
    }

    @Override
    public <T extends IAEStack<T>> ICellInventoryHandler<T> getCellInventory(ItemStack is, ISaveProvider container, IStorageChannel<T> chan) {
        if (is.func_190926_b()) {
            return null;
        }
        for (ICellHandler ch : this.handlers) {
            if (!ch.isCell(is)) continue;
            return ch.getCellInventory(is, container, chan);
        }
        return null;
    }

    @Override
    public void addCellGuiHandler(ICellGuiHandler handler) {
        this.guiHandlers.add(handler);
    }

    @Override
    public <T extends IAEStack<T>> ICellGuiHandler getGuiHandler(IStorageChannel<T> channel, ItemStack is) {
        ICellGuiHandler fallBack = null;
        for (ICellGuiHandler ch : this.guiHandlers) {
            if (!ch.isHandlerFor(channel)) continue;
            if (ch.isSpecializedFor(is)) {
                return ch;
            }
            if (fallBack != null) continue;
            fallBack = ch;
        }
        return fallBack;
    }
}

