/*
 * Decompiled with CFR 0.152.
 */
package net.montoyo.wd.utilities;

import io.netty.buffer.ByteBuf;
import net.minecraft.util.math.BlockPos;
import net.montoyo.wd.utilities.Vector3f;

public final class Vector3i {
    public int x;
    public int y;
    public int z;

    public Vector3i() {
        this.x = 0;
        this.y = 0;
        this.z = 0;
    }

    public Vector3i(int val) {
        this.x = val;
        this.y = val;
        this.z = val;
    }

    public Vector3i(int x, int y, int z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public Vector3i(BlockPos bp) {
        this.x = bp.func_177958_n();
        this.y = bp.func_177956_o();
        this.z = bp.func_177952_p();
    }

    public Vector3i(ByteBuf bb) {
        this.x = bb.readInt();
        this.y = bb.readInt();
        this.z = bb.readInt();
    }

    public Vector3i clone() {
        return new Vector3i(this.x, this.y, this.z);
    }

    public int hashCode() {
        return ((37 + this.x) * 31 + this.y) * 43 + this.z;
    }

    public boolean equals(Object o) {
        if (o instanceof Vector3i) {
            Vector3i src = (Vector3i)o;
            return src.x == this.x && src.y == this.y && src.z == this.z;
        }
        return false;
    }

    public boolean equalsBlockPos(BlockPos bp) {
        return bp.func_177958_n() == this.x && bp.func_177956_o() == this.y && bp.func_177952_p() == this.z;
    }

    public String toString() {
        return "X: " + this.x + ", Y: " + this.y + ", Z: " + this.z;
    }

    public Vector3i add(Vector3i src) {
        this.x += src.x;
        this.y += src.y;
        this.z += src.z;
        return this;
    }

    public Vector3i addMul(Vector3i src, int mul) {
        this.x += src.x * mul;
        this.y += src.y * mul;
        this.z += src.z * mul;
        return this;
    }

    public Vector3i add(int x, int y, int z) {
        this.x += x;
        this.y += y;
        this.z += z;
        return this;
    }

    public Vector3i add(int xyz) {
        this.x += xyz;
        this.y += xyz;
        this.z += xyz;
        return this;
    }

    public Vector3i sub(Vector3i src) {
        this.x -= src.x;
        this.y -= src.y;
        this.z -= src.z;
        return this;
    }

    public Vector3i sub(int x, int y, int z) {
        this.x -= x;
        this.y -= y;
        this.z -= z;
        return this;
    }

    public Vector3i sub(int xyz) {
        this.x -= xyz;
        this.y -= xyz;
        this.z -= xyz;
        return this;
    }

    public Vector3i neg() {
        this.x = -this.x;
        this.y = -this.y;
        this.z = -this.z;
        return this;
    }

    public Vector3i mul(int val) {
        this.x *= val;
        this.y *= val;
        this.z *= val;
        return this;
    }

    public Vector3i div(int val) {
        this.x /= val;
        this.y /= val;
        this.z /= val;
        return this;
    }

    public Vector3i set(int x, int y, int z) {
        this.x = x;
        this.y = y;
        this.z = z;
        return this;
    }

    public Vector3i set(double x, double y, double z) {
        this.x = (int)x;
        this.y = (int)y;
        this.z = (int)z;
        return this;
    }

    public Vector3i set(float x, float y, float z) {
        this.x = (int)x;
        this.y = (int)y;
        this.z = (int)z;
        return this;
    }

    public Vector3i set(int val) {
        this.x = val;
        this.y = val;
        this.z = val;
        return this;
    }

    public Vector3i set(Vector3i val) {
        this.x = val.x;
        this.y = val.y;
        this.z = val.z;
        return this;
    }

    public Vector3i set(Vector3f vec) {
        this.x = (int)vec.x;
        this.y = (int)vec.y;
        this.z = (int)vec.z;
        return this;
    }

    public int dot(Vector3i vec) {
        return this.x * vec.x + this.y * vec.y + this.z * vec.z;
    }

    public Vector3f toFloat() {
        return new Vector3f(this.x, this.y, this.z);
    }

    public BlockPos toBlock() {
        return new BlockPos(this.x, this.y, this.z);
    }

    public void toBlock(BlockPos.MutableBlockPos bp) {
        bp.func_181079_c(this.x, this.y, this.z);
    }

    public int getChunkLocalPos() {
        int lx = this.x & 0xF;
        int ly = this.y & 0xFF;
        int lz = this.z & 0xF;
        return ly << 8 | lz << 4 | lx;
    }

    public void writeTo(ByteBuf bb) {
        bb.writeInt(this.x);
        bb.writeInt(this.y);
        bb.writeInt(this.z);
    }
}

