/*
 * Decompiled with CFR 0.152.
 */
package openmods.words;

import openmods.words.Alternative;
import openmods.words.IGenerator;
import openmods.words.Optional;
import openmods.words.Range;
import openmods.words.Sequence;
import openmods.words.Substitution;
import openmods.words.Terminal;
import openmods.words.Transformer;
import org.apache.commons.lang3.text.WordUtils;

public class Words {
    private static IGenerator[] convert(Object ... args) {
        IGenerator[] result = new IGenerator[args.length];
        for (int i = 0; i < args.length; ++i) {
            Object arg = args[i];
            result[i] = arg instanceof IGenerator ? (IGenerator)arg : Words.terminal(arg);
        }
        return result;
    }

    public static IGenerator terminal(Object object) {
        return new Terminal(object.toString());
    }

    public static IGenerator alt(Object ... obj) {
        return new Alternative(Words.convert(obj));
    }

    public static IGenerator seq(Object ... obj) {
        return new Sequence.Phrase(Words.convert(obj));
    }

    public static IGenerator word(Object ... obj) {
        return new Sequence.Word(Words.convert(obj));
    }

    public static IGenerator capitalize(IGenerator gen) {
        return new Transformer(gen){

            @Override
            protected String transform(String input) {
                return WordUtils.capitalize((String)input);
            }
        };
    }

    public static IGenerator capitalizeFully(IGenerator gen) {
        return new Transformer(gen){

            @Override
            protected String transform(String input) {
                return WordUtils.capitalizeFully((String)input);
            }
        };
    }

    public static IGenerator upper(IGenerator gen) {
        return new Transformer(gen){

            @Override
            protected String transform(String input) {
                return input.toUpperCase();
            }
        };
    }

    public static IGenerator lower(IGenerator gen) {
        return new Transformer(gen){

            @Override
            protected String transform(String input) {
                return input.toLowerCase();
            }
        };
    }

    public static IGenerator opt(float probability, IGenerator gen) {
        return new Optional(gen, probability);
    }

    public static IGenerator sub(String key) {
        return new Substitution(key, "");
    }

    public static IGenerator sub(String key, String defaultValue) {
        return new Substitution(key, defaultValue);
    }

    public static IGenerator range(int start, int end) {
        return new Range(start, end);
    }
}

