/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.smeltery;

import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import slimeknights.tconstruct.library.TinkerRegistry;
import slimeknights.tconstruct.library.Util;
import slimeknights.tconstruct.library.client.CustomTextureCreator;
import slimeknights.tconstruct.shared.client.BakedTableModel;
import slimeknights.tconstruct.smeltery.TinkerSmeltery;
import slimeknights.tconstruct.smeltery.block.BlockTank;
import slimeknights.tconstruct.smeltery.client.TankItemModel;
import slimeknights.tconstruct.tools.ToolClientEvents;

public class SmelteryClientEvents {
    private static final String LOCATION_CastingBlock = Util.resource("casting");
    public static final ModelResourceLocation locCastingTable = new ModelResourceLocation(LOCATION_CastingBlock, "type=table");
    public static final ModelResourceLocation locCastingBasin = new ModelResourceLocation(LOCATION_CastingBlock, "type=basin");
    private static final ResourceLocation MODEL_BlankCast = Util.getResource("item/cast");
    public static final ResourceLocation locBlankCast = Util.getResource("cast");
    public static final ResourceLocation locClayCast = Util.getResource("clay_cast");

    @SubscribeEvent
    public void onModelBake(ModelBakeEvent event) {
        this.wrap(event, locCastingTable);
        this.wrap(event, locCastingBasin);
        ToolClientEvents.replacePatternModel(locBlankCast, MODEL_BlankCast, event, CustomTextureCreator.castLocString, TinkerRegistry.getCastItems());
        ToolClientEvents.replacePatternModel(locClayCast, MODEL_BlankCast, event, CustomTextureCreator.castLocString, TinkerRegistry.getCastItems(), 10974360);
        for (BlockTank.TankType type : BlockTank.TankType.values()) {
            this.replaceTankModel(event, new ModelResourceLocation(TinkerSmeltery.searedTank.getRegistryName(), type.func_176610_l()));
        }
    }

    private void wrap(ModelBakeEvent event, ModelResourceLocation loc) {
        IBakedModel model = (IBakedModel)event.getModelRegistry().func_82594_a((Object)loc);
        if (model != null && model instanceof IBakedModel) {
            event.getModelRegistry().func_82595_a((Object)loc, (Object)new BakedTableModel(model, null, DefaultVertexFormats.field_176599_b));
        }
    }

    private void replaceTankModel(ModelBakeEvent event, ModelResourceLocation loc) {
        IBakedModel baked = (IBakedModel)event.getModelRegistry().func_82594_a((Object)loc);
        if (baked != null) {
            event.getModelRegistry().func_82595_a((Object)loc, (Object)new TankItemModel(baked));
        }
    }
}

