/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.smeltery.tileentity;

import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import slimeknights.mantle.network.AbstractPacket;
import slimeknights.mantle.tileentity.MantleTileEntity;
import slimeknights.tconstruct.common.TinkerNetwork;
import slimeknights.tconstruct.library.Util;
import slimeknights.tconstruct.library.fluid.ChannelSideTank;
import slimeknights.tconstruct.library.fluid.ChannelTank;
import slimeknights.tconstruct.smeltery.network.ChannelConnectionPacket;
import slimeknights.tconstruct.smeltery.network.ChannelFlowPacket;
import slimeknights.tconstruct.smeltery.network.FluidUpdatePacket;

public class TileChannel
extends MantleTileEntity
implements ITickable,
FluidUpdatePacket.IFluidPacketReceiver {
    private ChannelConnection[] connections = new ChannelConnection[4];
    private boolean connectedDown = false;
    private byte[] isFlowing = new byte[4];
    private boolean isFlowingDown;
    private boolean wasPowered;
    private int numOutputs = 0;
    private ChannelTank tank = new ChannelTank(36, this);
    private ChannelSideTank[] sideTanks = new ChannelSideTank[4];
    private static final String TAG_CONNECTIONS = "connections";
    private static final String TAG_CONNECTED_DOWN = "connected_down";
    private static final String TAG_IS_FLOWING = "is_flowing";
    private static final String TAG_IS_FLOWING_DOWN = "is_flowing_down";
    private static final String TAG_WAS_POWERED = "was_powered";
    private static final String TAG_TANK = "tank";

    public void func_73660_a() {
        if (this.func_145831_w().field_72995_K) {
            return;
        }
        FluidStack fluid = this.tank.getFluid();
        if (fluid != null && fluid.amount > 0) {
            boolean hasFlown = false;
            if (this.isConnectedDown()) {
                hasFlown = this.trySide(EnumFacing.DOWN, 6);
            }
            if (!hasFlown && this.numOutputs > 0) {
                int flowRate = Math.max(1, Math.min(this.tank.usableFluid() / this.numOutputs, 6));
                for (EnumFacing side : EnumFacing.field_176754_o) {
                    this.trySide(side, flowRate);
                }
            }
        }
        for (int i = 0; i < 4; ++i) {
            if (this.isFlowing[i] <= 0) continue;
            int n = i;
            this.isFlowing[n] = (byte)(this.isFlowing[n] - 1);
            if (this.isFlowing[i] != 0) continue;
            TinkerNetwork.sendToClients((WorldServer)this.field_145850_b, this.field_174879_c, (AbstractPacket)new ChannelFlowPacket(this.field_174879_c, EnumFacing.func_176731_b((int)i), false));
        }
        this.tank.freeFluid();
    }

    protected boolean trySide(@Nonnull EnumFacing side, int flowRate) {
        if (this.tank.getFluid() == null || this.getConnection(side) != ChannelConnection.OUT) {
            return false;
        }
        TileEntity te = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(side));
        if (te instanceof TileChannel) {
            TileChannel channel = (TileChannel)te;
            EnumFacing opposite = side.func_176734_d();
            if (channel.getConnection(opposite) == ChannelConnection.IN) {
                return this.fill(side, channel.getTank(opposite), flowRate);
            }
        } else {
            IFluidHandler toFill = this.getFluidHandler(te, side.func_176734_d());
            if (toFill != null) {
                return this.fill(side, toFill, flowRate);
            }
        }
        return false;
    }

    protected boolean fill(EnumFacing side, @Nonnull IFluidHandler handler, int amount) {
        int filled;
        FluidStack fluid = this.tank.getUsableFluid();
        fluid.amount = Math.min(fluid.amount, amount);
        int n = filled = fluid.amount == 0 ? 0 : handler.fill(fluid, false);
        if (filled > 0) {
            this.setFlow(side, true);
            filled = handler.fill(fluid, true);
            this.tank.drainInternal(filled, true);
            return true;
        }
        this.setFlow(side, false);
        return false;
    }

    protected TileChannel getChannel(BlockPos pos) {
        TileEntity te = this.func_145831_w().func_175625_s(pos);
        if (te != null && te instanceof TileChannel) {
            return (TileChannel)te;
        }
        return null;
    }

    protected IFluidHandler getFluidHandler(TileEntity te, EnumFacing direction) {
        if (te != null && te.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, direction)) {
            return (IFluidHandler)te.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, direction);
        }
        return null;
    }

    public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing side) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return side == null || this.getConnection(side) == ChannelConnection.IN;
        }
        return super.hasCapability(capability, side);
    }

    @Nonnull
    public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing side) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY && (side == null || this.getConnection(side) == ChannelConnection.IN)) {
            return (T)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.cast((Object)this.getTank(side));
        }
        return (T)super.getCapability(capability, side);
    }

    public void onPlaceBlock(EnumFacing hit, boolean sneak) {
        EnumFacing side = hit.func_176734_d();
        TileEntity te = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(side));
        if (te == null) {
            return;
        }
        if (side == EnumFacing.UP) {
            if (te instanceof TileChannel) {
                ((TileChannel)te).connectedDown = true;
            }
        } else if (te instanceof TileChannel) {
            if (side == EnumFacing.DOWN) {
                this.connectedDown = true;
            } else {
                ChannelConnection connection = sneak ? ChannelConnection.IN : ChannelConnection.OUT;
                this.setConnection(side, connection.getOpposite());
                ((TileChannel)te).setConnection(hit, connection);
            }
        } else if (te.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, side.func_176734_d())) {
            this.setConnection(side, ChannelConnection.OUT);
        }
        this.wasPowered = this.field_145850_b.func_175640_z(this.field_174879_c);
    }

    public void handleBlockUpdate(BlockPos fromPos, boolean didPlace, boolean isPowered) {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        EnumFacing side = Util.facingFromNeighbor(this.field_174879_c, fromPos);
        if (side != null && side != EnumFacing.UP) {
            boolean isValid = false;
            boolean shouldOutput = false;
            TileEntity te = this.field_145850_b.func_175625_s(fromPos);
            if (te instanceof TileChannel) {
                isValid = true;
            } else if (te != null && te.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, side.func_176734_d())) {
                isValid = true;
                shouldOutput = didPlace;
            }
            ChannelConnection connection = this.getConnection(side);
            if (connection != ChannelConnection.NONE && !isValid) {
                this.setConnection(side, ChannelConnection.NONE);
                TinkerNetwork.sendToClients((WorldServer)this.field_145850_b, this.field_174879_c, (AbstractPacket)new ChannelConnectionPacket(this.field_174879_c, side, false));
            } else if (shouldOutput && connection == ChannelConnection.NONE && isValid) {
                this.setConnection(side, ChannelConnection.OUT);
                TinkerNetwork.sendToClients((WorldServer)this.field_145850_b, this.field_174879_c, (AbstractPacket)new ChannelConnectionPacket(this.field_174879_c, side, true));
            }
        }
        if (isPowered != this.wasPowered && side != null && side != EnumFacing.DOWN) {
            TileEntity te = this.field_145850_b.func_175625_s(this.field_174879_c.func_177977_b());
            boolean isValid2 = te != null && (te instanceof TileChannel || te.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, side.func_176734_d()));
            this.connectedDown = isValid2 && isPowered;
            TinkerNetwork.sendToClients((WorldServer)this.field_145850_b, this.field_174879_c, (AbstractPacket)new ChannelConnectionPacket(this.field_174879_c, EnumFacing.DOWN, this.connectedDown));
            this.wasPowered = isPowered;
        }
    }

    public boolean interact(EntityPlayer player, EnumFacing side) {
        String message;
        TileEntity te = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(side));
        boolean isChannel = false;
        if (te instanceof TileChannel) {
            isChannel = true;
        } else if (te == null || !te.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, side.func_176734_d())) {
            if (this.getConnection(side) == ChannelConnection.NONE) {
                if (side != EnumFacing.DOWN) {
                    return this.interact(player, EnumFacing.DOWN);
                }
            } else {
                this.setConnection(side, ChannelConnection.NONE);
                this.updateBlock(this.field_174879_c);
            }
            return false;
        }
        if (side == EnumFacing.DOWN) {
            this.connectedDown = !this.connectedDown;
            this.updateBlock(this.field_174879_c);
            message = this.connectedDown ? "channel.connected_down.allow" : "channel.connected_down.disallow";
        } else {
            ChannelConnection newConnect = this.getConnection(side).getNext(player.func_70093_af());
            this.setConnection(side, newConnect);
            BlockPos offset = this.field_174879_c.func_177972_a(side);
            if (isChannel) {
                ((TileChannel)te).setConnection(side.func_176734_d(), newConnect.getOpposite());
            }
            this.updateBlock(this.field_174879_c);
            this.updateBlock(offset);
            switch (newConnect) {
                case OUT: {
                    message = "channel.connected.out";
                    break;
                }
                case IN: {
                    message = "channel.connected.in";
                    break;
                }
                default: {
                    message = "channel.connected.none";
                }
            }
        }
        player.func_146105_b((ITextComponent)new TextComponentTranslation(Util.prefix(message), new Object[0]), true);
        return true;
    }

    public ChannelTank getTank() {
        return this.tank;
    }

    protected IFluidHandler getTank(@Nullable EnumFacing side) {
        if (side == null || side == EnumFacing.UP) {
            return this.tank;
        }
        int index = side.func_176736_b();
        if (index >= 0) {
            if (this.sideTanks[index] == null) {
                this.sideTanks[index] = new ChannelSideTank(this, this.tank, side);
            }
            return this.sideTanks[index];
        }
        return null;
    }

    @Nonnull
    public ChannelConnection getConnection(@Nonnull EnumFacing side) {
        if (side == EnumFacing.UP) {
            return ChannelConnection.IN;
        }
        if (side == EnumFacing.DOWN) {
            return this.connectedDown ? ChannelConnection.OUT : ChannelConnection.NONE;
        }
        int index = side.func_176736_b();
        if (index < 0) {
            return null;
        }
        ChannelConnection connection = this.connections[index];
        return connection == null ? ChannelConnection.NONE : connection;
    }

    public boolean isConnectedDown() {
        return this.connectedDown;
    }

    public void setConnection(@Nonnull EnumFacing side, @Nonnull ChannelConnection connection) {
        if (side == EnumFacing.DOWN) {
            this.connectedDown = connection == ChannelConnection.OUT;
            return;
        }
        int index = side.func_176736_b();
        if (index >= 0) {
            ChannelConnection oldConnection = this.connections[index];
            if (oldConnection != ChannelConnection.OUT && connection == ChannelConnection.OUT) {
                ++this.numOutputs;
            } else if (oldConnection == ChannelConnection.OUT && connection != ChannelConnection.OUT) {
                --this.numOutputs;
            }
            this.connections[index] = connection;
        }
    }

    public void setFlow(@Nonnull EnumFacing side, boolean isFlowing) {
        if (side == EnumFacing.UP) {
            return;
        }
        boolean wasFlowing = this.setFlowRaw(side, isFlowing);
        if (wasFlowing != isFlowing) {
            TinkerNetwork.sendToClients((WorldServer)this.field_145850_b, this.field_174879_c, (AbstractPacket)new ChannelFlowPacket(this.field_174879_c, side, isFlowing));
        }
    }

    private boolean setFlowRaw(@Nonnull EnumFacing side, boolean isFlowing) {
        boolean wasFlowing;
        if (side == EnumFacing.DOWN) {
            wasFlowing = this.isFlowingDown;
            this.isFlowingDown = isFlowing;
        } else {
            int index = side.func_176736_b();
            wasFlowing = this.isFlowing[index] > 0;
            this.isFlowing[index] = (byte)(isFlowing ? 2 : 0);
        }
        return wasFlowing;
    }

    public boolean isFlowing(@Nonnull EnumFacing side) {
        if (side == EnumFacing.DOWN) {
            return this.isFlowingDown;
        }
        int index = side.func_176736_b();
        if (index >= 0) {
            return this.isFlowing[index] > 0;
        }
        return false;
    }

    public boolean isFlowingDown() {
        return this.isFlowingDown;
    }

    private void updateBlock(BlockPos pos) {
        IBlockState state = this.field_145850_b.func_180495_p(pos);
        this.field_145850_b.func_184138_a(pos, state, state, 2);
    }

    public boolean hasFastRenderer() {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return new AxisAlignedBB((double)this.field_174879_c.func_177958_n(), (double)(this.field_174879_c.func_177956_o() - 1), (double)this.field_174879_c.func_177952_p(), (double)(this.field_174879_c.func_177958_n() + 1), (double)(this.field_174879_c.func_177956_o() + 1), (double)(this.field_174879_c.func_177952_p() + 1));
    }

    @Nonnull
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        nbt = super.func_189515_b(nbt);
        byte[] bytes = new byte[4];
        for (int i = 0; i < 4; ++i) {
            ChannelConnection connection = this.connections[i];
            bytes[i] = connection == null ? (byte)0 : connection.getIndex();
        }
        nbt.func_74773_a(TAG_CONNECTIONS, bytes);
        nbt.func_74757_a(TAG_CONNECTED_DOWN, this.connectedDown);
        nbt.func_74773_a(TAG_IS_FLOWING, this.isFlowing);
        nbt.func_74757_a(TAG_IS_FLOWING_DOWN, this.isFlowingDown);
        nbt.func_74757_a(TAG_WAS_POWERED, this.wasPowered);
        nbt.func_74782_a(TAG_TANK, (NBTBase)this.tank.writeToNBT(new NBTTagCompound()));
        return nbt;
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        if (nbt.func_74764_b(TAG_CONNECTIONS)) {
            this.connections = new ChannelConnection[4];
            this.numOutputs = 0;
            byte[] bytes = nbt.func_74770_j(TAG_CONNECTIONS);
            for (int i = 0; i < 4 && i < bytes.length; ++i) {
                this.connections[i] = ChannelConnection.fromIndex(bytes[i]);
                if (this.connections[i] == ChannelConnection.NONE) continue;
                ++this.numOutputs;
            }
        }
        this.connectedDown = nbt.func_74767_n(TAG_CONNECTED_DOWN);
        if (nbt.func_74764_b(TAG_IS_FLOWING)) {
            this.isFlowing = nbt.func_74770_j(TAG_IS_FLOWING);
        }
        this.isFlowingDown = nbt.func_74767_n(TAG_IS_FLOWING_DOWN);
        this.wasPowered = nbt.func_74767_n(TAG_WAS_POWERED);
        NBTTagCompound tankTag = nbt.func_74775_l(TAG_TANK);
        if (tankTag != null) {
            this.tank.readFromNBT(tankTag);
        }
    }

    @Override
    public void updateFluidTo(FluidStack fluid) {
        this.tank.setFluid(fluid);
    }

    @SideOnly(value=Side.CLIENT)
    public void updateConnection(EnumFacing side, boolean connect) {
        this.setConnection(side, connect ? ChannelConnection.OUT : ChannelConnection.NONE);
        this.updateBlock(this.field_174879_c);
    }

    @SideOnly(value=Side.CLIENT)
    public void updateFlow(EnumFacing side, boolean flow) {
        this.setFlowRaw(side, flow);
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound tag = new NBTTagCompound();
        this.func_189515_b(tag);
        return new SPacketUpdateTileEntity(this.func_174877_v(), this.func_145832_p(), tag);
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        super.onDataPacket(net, pkt);
        this.func_145839_a(pkt.func_148857_g());
    }

    @Nonnull
    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    public void handleUpdateTag(@Nonnull NBTTagCompound tag) {
        this.func_145839_a(tag);
    }

    public static enum ChannelConnection implements IStringSerializable
    {
        NONE,
        IN,
        OUT;

        byte index = (byte)this.ordinal();

        public byte getIndex() {
            return this.index;
        }

        public ChannelConnection getOpposite() {
            switch (this) {
                case IN: {
                    return OUT;
                }
                case OUT: {
                    return IN;
                }
            }
            return NONE;
        }

        public ChannelConnection getNext(boolean reverse) {
            if (reverse) {
                switch (this) {
                    case NONE: {
                        return IN;
                    }
                    case IN: {
                        return OUT;
                    }
                    case OUT: {
                        return NONE;
                    }
                }
            } else {
                switch (this) {
                    case NONE: {
                        return OUT;
                    }
                    case OUT: {
                        return IN;
                    }
                    case IN: {
                        return NONE;
                    }
                }
            }
            throw new UnsupportedOperationException();
        }

        public static ChannelConnection fromIndex(int index) {
            if (index < 0 || index >= ChannelConnection.values().length) {
                return NONE;
            }
            return ChannelConnection.values()[index];
        }

        public String func_176610_l() {
            return this.toString().toLowerCase(Locale.US);
        }

        public boolean canFlow() {
            return this != NONE;
        }

        public static boolean canFlow(ChannelConnection connection) {
            return connection != null && connection != NONE;
        }
    }
}

