/*
 * Decompiled with CFR 0.152.
 */
package com.the9grounds.aeadditions.container;

import com.the9grounds.aeadditions.api.AEAApi;
import com.the9grounds.aeadditions.util.FluidHelper;
import com.the9grounds.aeadditions.util.GasUtil;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public enum StorageType {
    GAS("gas", "Kilo", "Mega", ""){

        @Override
        public boolean isEmpty(ItemStack stack) {
            return GasUtil.isEmpty(stack);
        }

        @Override
        public boolean isFilled(ItemStack stack) {
            return GasUtil.isFilled(stack);
        }

        @Override
        public boolean canSee(FluidStack fluidStack) {
            return AEAApi.instance().isGasStack(fluidStack);
        }

        @Override
        public boolean isContainer(ItemStack stack) {
            return GasUtil.isGasContainer(stack);
        }
    }
    ,
    FLUID("fluid", "KiloB", "MegaB", "B"){

        @Override
        public boolean isEmpty(ItemStack stack) {
            return FluidHelper.isEmpty(stack);
        }

        @Override
        public boolean isFilled(ItemStack stack) {
            return FluidHelper.isFilled(stack);
        }

        @Override
        public boolean canSee(FluidStack fluidStack) {
            return AEAApi.instance().canFluidSeeInTerminal(fluidStack.getFluid());
        }

        @Override
        public boolean isContainer(ItemStack stack) {
            return FluidHelper.isFluidContainer(stack);
        }
    };

    private String name;
    private String kilo;
    private String mega;
    private String buckets;

    private StorageType(String name, String kilo, String mega, String buckets) {
        this.name = name;
        this.kilo = kilo;
        this.mega = mega;
        this.buckets = buckets;
    }

    public String getName() {
        return this.name;
    }

    public String getBuckets() {
        return this.buckets;
    }

    public String getKilo() {
        return this.kilo;
    }

    public String getMega() {
        return this.mega;
    }

    public abstract boolean isEmpty(ItemStack var1);

    public abstract boolean isFilled(ItemStack var1);

    public abstract boolean canSee(FluidStack var1);

    public abstract boolean isContainer(ItemStack var1);
}

