/*
 * Decompiled with CFR 0.152.
 */
package com.the9grounds.aeadditions.part.gas;

import appeng.api.config.Actionable;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridNode;
import appeng.api.networking.security.IActionSource;
import appeng.api.networking.storage.IStackWatcher;
import appeng.api.networking.storage.IStorageGrid;
import appeng.api.parts.IPartHost;
import appeng.api.parts.IPartModel;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.data.IAEStack;
import appeng.api.util.DimensionalCoord;
import com.the9grounds.aeadditions.api.IWrenchHandler;
import com.the9grounds.aeadditions.api.gas.IAEGasStack;
import com.the9grounds.aeadditions.api.gas.IGasStorageChannel;
import com.the9grounds.aeadditions.models.PartModels;
import com.the9grounds.aeadditions.part.gas.PartGasStorageMonitor;
import com.the9grounds.aeadditions.util.AEUtils;
import com.the9grounds.aeadditions.util.GasUtil;
import com.the9grounds.aeadditions.util.MachineSource;
import com.the9grounds.aeadditions.util.StorageChannels;
import com.the9grounds.aeadditions.util.WrenchUtil;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import mekanism.api.gas.Gas;
import mekanism.api.gas.GasStack;
import mekanism.api.gas.IGasItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.Optional;
import org.apache.commons.lang3.tuple.MutablePair;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016J&\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0016J&\u0010\r\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0017J\b\u0010\u000e\u001a\u00020\u000fH\u0017J$\u0010\u0010\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\fH\u0007J\u0012\u0010\u0011\u001a\u00020\u000f2\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0016J&\u0010\u0014\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0007\u00a8\u0006\u0015"}, d2={"Lcom/the9grounds/aeadditions/part/gas/PartGasConversionMonitor;", "Lcom/the9grounds/aeadditions/part/gas/PartGasStorageMonitor;", "()V", "getStaticModels", "Lappeng/api/parts/IPartModel;", "onActivate", "", "player", "Lnet/minecraft/entity/player/EntityPlayer;", "hand", "Lnet/minecraft/util/EnumHand;", "pos", "Lnet/minecraft/util/math/Vec3d;", "onActivateGas", "onStackChange", "", "storageMonitor", "updateWatcher", "w", "Lappeng/api/networking/storage/IStackWatcher;", "wasActivated", "AEAdditions-1.12.2"})
public final class PartGasConversionMonitor
extends PartGasStorageMonitor {
    @Override
    public boolean onActivate(@Nullable EntityPlayer player, @Nullable EnumHand hand, @Nullable Vec3d pos) {
        if (this.isMekanismEnabled()) {
            return this.onActivateGas(player, hand, pos);
        }
        return false;
    }

    @Optional.Method(modid="MekanismAPI|gas")
    public final boolean wasActivated(@Nullable EntityPlayer player, @Nullable EnumHand hand, @Nullable Vec3d pos) {
        if (player == null || player.field_70170_p == null) {
            return true;
        }
        if (player.field_70170_p.field_72995_K) {
            return true;
        }
        ItemStack s = player.func_184586_b(hand);
        if (s == null) {
            if (this.getLocked()) {
                return false;
            }
            if (this.getFluid() == null) {
                return true;
            }
            if (this.getWatcher() != null) {
                IStackWatcher iStackWatcher = this.getWatcher();
                if (iStackWatcher == null) {
                    Intrinsics.throwNpe();
                }
                IGasStorageChannel iGasStorageChannel = StorageChannels.GAS;
                if (iGasStorageChannel == null) {
                    Intrinsics.throwNpe();
                }
                Fluid fluid = this.getFluid();
                if (fluid == null) {
                    Intrinsics.throwNpe();
                }
                iStackWatcher.remove(iGasStorageChannel.createStack(fluid));
            }
            this.setFluid(null);
            this.setAmount(0L);
            IPartHost iPartHost = this.getHost();
            Intrinsics.checkExpressionValueIsNotNull((Object)iPartHost, (String)"host");
            IPartHost host = iPartHost;
            if (host != null) {
                host.markForUpdate();
            }
            return true;
        }
        EnumFacing enumFacing = this.getFacing();
        DimensionalCoord dimensionalCoord = this.getLocation();
        if (dimensionalCoord == null) {
            Intrinsics.throwNpe();
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)dimensionalCoord, (String)"location!!");
        RayTraceResult rayTraceResult = new RayTraceResult(pos, enumFacing, dimensionalCoord.getPos());
        IWrenchHandler wrenchHandler = WrenchUtil.getHandler(s, player, rayTraceResult, hand);
        if (wrenchHandler != null) {
            this.setLocked(!this.getLocked());
            wrenchHandler.wrenchUsed(s, player, rayTraceResult, hand);
            IPartHost iPartHost = this.getHost();
            Intrinsics.checkExpressionValueIsNotNull((Object)iPartHost, (String)"host");
            IPartHost host = iPartHost;
            if (host != null) {
                host.markForUpdate();
            }
            if (this.getLocked()) {
                player.func_145747_a((ITextComponent)new TextComponentTranslation("chat.appliedenergistics2.isNowLocked", new Object[0]));
            } else {
                player.func_145747_a((ITextComponent)new TextComponentTranslation("chat.appliedenergistics2.isNowUnlocked", new Object[0]));
            }
            return true;
        }
        if (this.getLocked()) {
            return false;
        }
        if (GasUtil.isFilled(s)) {
            GasStack gas;
            FluidStack fluidStack;
            if (this.getFluid() != null && this.getWatcher() != null) {
                IStackWatcher iStackWatcher = this.getWatcher();
                if (iStackWatcher == null) {
                    Intrinsics.throwNpe();
                }
                IGasStorageChannel iGasStorageChannel = StorageChannels.GAS;
                if (iGasStorageChannel == null) {
                    Intrinsics.throwNpe();
                }
                Fluid fluid = this.getFluid();
                if (fluid == null) {
                    Intrinsics.throwNpe();
                }
                iStackWatcher.remove(iGasStorageChannel.createStack(fluid));
            }
            this.setFluid((fluidStack = GasUtil.getFluidStack(gas = GasUtil.getGasFromContainer(s))) == null ? null : fluidStack.getFluid());
            if (this.getWatcher() != null) {
                IStackWatcher iStackWatcher = this.getWatcher();
                if (iStackWatcher == null) {
                    Intrinsics.throwNpe();
                }
                IGasStorageChannel iGasStorageChannel = StorageChannels.GAS;
                if (iGasStorageChannel == null) {
                    Intrinsics.throwNpe();
                }
                Fluid fluid = this.getFluid();
                if (fluid == null) {
                    Intrinsics.throwNpe();
                }
                iStackWatcher.add(iGasStorageChannel.createStack(fluid));
            }
            IPartHost iPartHost = this.getHost();
            Intrinsics.checkExpressionValueIsNotNull((Object)iPartHost, (String)"host");
            IPartHost host = iPartHost;
            if (host != null) {
                host.markForUpdate();
            }
            this.onStackChange();
            return true;
        }
        return false;
    }

    @Override
    @Optional.Method(modid="MekanismAPI|gas")
    public boolean onActivateGas(@Nullable EntityPlayer player, @Nullable EnumHand hand, @Nullable Vec3d pos) {
        boolean b = this.wasActivated(player, hand, pos);
        if (b) {
            return b;
        }
        if (player == null || player.field_70170_p == null || hand == null || pos == null) {
            return true;
        }
        if (player.field_70170_p.field_72995_K) {
            return true;
        }
        ItemStack itemStack = player.func_184586_b(hand);
        Intrinsics.checkExpressionValueIsNotNull((Object)itemStack, (String)"player.getHeldItem(hand)");
        ItemStack s = itemStack;
        IMEMonitor<IAEGasStack> mon = this.getGasStorage();
        if (this.getLocked() && s != null && !s.func_190926_b() && mon != null) {
            ItemStack itemStack2 = s.func_77946_l();
            Intrinsics.checkExpressionValueIsNotNull((Object)itemStack2, (String)"s.copy()");
            ItemStack s2 = itemStack2;
            s2.func_190920_e(1);
            if (GasUtil.isFilled(s2)) {
                IAEGasStack g1;
                GasStack g = GasUtil.getGasFromContainer(s2);
                if (g == null) {
                    return true;
                }
                IGasStorageChannel iGasStorageChannel = StorageChannels.GAS;
                if (iGasStorageChannel == null) {
                    Intrinsics.throwNpe();
                }
                IAEGasStack iAEGasStack = g1 = (IAEGasStack)iGasStorageChannel.createStack(g);
                if (iAEGasStack == null) {
                    Intrinsics.throwNpe();
                }
                IAEGasStack not = (IAEGasStack)mon.injectItems((IAEStack)iAEGasStack.copy(), Actionable.SIMULATE, (IActionSource)new MachineSource(this));
                if (mon.canAccept((IAEStack)g1) && (not == null || not.getStackSize() == 0L)) {
                    mon.injectItems((IAEStack)g1, Actionable.MODULATE, (IActionSource)new MachineSource(this));
                    MutablePair<Integer, ItemStack> mutablePair = GasUtil.drainStack(s2, g);
                    Intrinsics.checkExpressionValueIsNotNull(mutablePair, (String)"GasUtil.drainStack(s2, g)");
                    MutablePair<Integer, ItemStack> empty1 = mutablePair;
                    Object object = empty1.right;
                    Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"empty1.right");
                    ItemStack empty = (ItemStack)object;
                    if (empty != null && !empty.func_190926_b()) {
                        IPartHost iPartHost = this.getHost();
                        Intrinsics.checkExpressionValueIsNotNull((Object)iPartHost, (String)"host");
                        TileEntity tileEntity = iPartHost.getTile();
                        Intrinsics.checkExpressionValueIsNotNull((Object)tileEntity, (String)"host.tile");
                        World world = tileEntity.func_145831_w();
                        IPartHost iPartHost2 = this.getHost();
                        Intrinsics.checkExpressionValueIsNotNull((Object)iPartHost2, (String)"host");
                        TileEntity tileEntity2 = iPartHost2.getTile();
                        Intrinsics.checkExpressionValueIsNotNull((Object)tileEntity2, (String)"host.tile");
                        BlockPos blockPos = tileEntity2.func_174877_v().func_177972_a(this.getFacing());
                        Intrinsics.checkExpressionValueIsNotNull((Object)blockPos, (String)"host.tile.pos.offset(facing)");
                        this.dropItems(world, blockPos, empty);
                    }
                    ItemStack itemStack3 = s.func_77946_l();
                    Intrinsics.checkExpressionValueIsNotNull((Object)itemStack3, (String)"s.copy()");
                    ItemStack s3 = itemStack3;
                    s3.func_190920_e(s3.func_190916_E() - 1);
                    if (s3.func_190916_E() == 0) {
                        player.func_184611_a(hand, ItemStack.field_190927_a);
                    } else {
                        player.func_184611_a(hand, s3);
                    }
                }
                return true;
            }
            if (GasUtil.isEmpty(s2)) {
                IGasStorageChannel iGasStorageChannel;
                if (this.getFluid() == null) {
                    return true;
                }
                IAEGasStack extract = null;
                Item item = s2.func_77973_b();
                if (item instanceof IGasItem) {
                    iGasStorageChannel = StorageChannels.GAS;
                    if (iGasStorageChannel == null) {
                        Intrinsics.throwNpe();
                    }
                } else {
                    return true;
                }
                extract = (IAEGasStack)mon.extractItems(iGasStorageChannel.createStack(new GasStack(GasUtil.getGas(this.getFluid()), ((IGasItem)item).getMaxGas(s2))), Actionable.SIMULATE, (IActionSource)new MachineSource(this));
                if (extract != null) {
                    mon.extractItems(StorageChannels.GAS.createStack(new GasStack(GasUtil.getGas(this.getFluid()), (int)extract.getStackSize())), Actionable.MODULATE, (IActionSource)new MachineSource(this));
                    Object object = extract.getGasStack();
                    if (object == null) {
                        throw new TypeCastException("null cannot be cast to non-null type mekanism.api.gas.GasStack");
                    }
                    MutablePair<Integer, ItemStack> mutablePair = GasUtil.fillStack(s2, (GasStack)object);
                    Intrinsics.checkExpressionValueIsNotNull(mutablePair, (String)"GasUtil.fillStack(s2, ex\u2026act.gasStack as GasStack)");
                    MutablePair<Integer, ItemStack> empty1 = mutablePair;
                    Integer n = (Integer)empty1.left;
                    if (n != null && n == 0) {
                        mon.injectItems(StorageChannels.GAS.createStack(new GasStack(GasUtil.getGas(this.getFluid()), (int)extract.getStackSize())), Actionable.MODULATE, (IActionSource)new MachineSource(this));
                        return true;
                    }
                    Object object2 = empty1.right;
                    Intrinsics.checkExpressionValueIsNotNull((Object)object2, (String)"empty1.right");
                    ItemStack empty = (ItemStack)object2;
                    if (empty != null && !empty.func_190926_b()) {
                        IPartHost iPartHost = this.getHost();
                        Intrinsics.checkExpressionValueIsNotNull((Object)iPartHost, (String)"host");
                        TileEntity tileEntity = iPartHost.getTile();
                        Intrinsics.checkExpressionValueIsNotNull((Object)tileEntity, (String)"host.tile");
                        World world = tileEntity.func_145831_w();
                        IPartHost iPartHost3 = this.getHost();
                        Intrinsics.checkExpressionValueIsNotNull((Object)iPartHost3, (String)"host");
                        TileEntity tileEntity3 = iPartHost3.getTile();
                        Intrinsics.checkExpressionValueIsNotNull((Object)tileEntity3, (String)"host.tile");
                        BlockPos blockPos = tileEntity3.func_174877_v().func_177972_a(this.getFacing());
                        Intrinsics.checkExpressionValueIsNotNull((Object)blockPos, (String)"host.tile.pos.offset(facing)");
                        this.dropItems(world, blockPos, empty);
                    }
                    ItemStack itemStack4 = s.func_77946_l();
                    Intrinsics.checkExpressionValueIsNotNull((Object)itemStack4, (String)"s.copy()");
                    ItemStack s3 = itemStack4;
                    s3.func_190920_e(s3.func_190916_E() - 1);
                    if (s3.func_190916_E() == 0) {
                        player.func_184611_a(hand, ItemStack.field_190927_a);
                    } else {
                        player.func_184611_a(hand, s3);
                    }
                }
                return true;
            }
        }
        return false;
    }

    @Optional.Method(modid="MekanismAPI|gas")
    public final boolean storageMonitor(@Nullable EntityPlayer player, @Nullable EnumHand hand, @NotNull Vec3d pos) {
        Intrinsics.checkParameterIsNotNull((Object)pos, (String)"pos");
        EntityPlayer entityPlayer = player;
        if ((entityPlayer != null ? entityPlayer.field_70170_p : null) == null) {
            return true;
        }
        if (player.field_70170_p.field_72995_K) {
            return true;
        }
        ItemStack s = player.func_184586_b(hand);
        if (s == null) {
            if (this.getLocked()) {
                return false;
            }
            if (this.getFluid() == null) {
                return true;
            }
            if (this.getWatcher() != null) {
                IStackWatcher iStackWatcher = this.getWatcher();
                if (iStackWatcher == null) {
                    Intrinsics.throwNpe();
                }
                iStackWatcher.remove((IAEStack)AEUtils.createFluidStack(this.getFluid()));
            }
            this.setFluid(null);
            this.setAmount(0L);
            IPartHost iPartHost = this.getHost();
            if (iPartHost != null) {
                iPartHost.markForUpdate();
            }
            return true;
        }
        EnumFacing enumFacing = this.getFacing();
        DimensionalCoord dimensionalCoord = this.getLocation();
        if (dimensionalCoord == null) {
            Intrinsics.throwNpe();
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)dimensionalCoord, (String)"location!!");
        RayTraceResult rayTraceResult = new RayTraceResult(pos, enumFacing, dimensionalCoord.getPos());
        IWrenchHandler wrenchHandler = WrenchUtil.getHandler(s, player, rayTraceResult, hand);
        if (wrenchHandler != null) {
            this.setLocked(!this.getLocked());
            wrenchHandler.wrenchUsed(s, player, rayTraceResult, hand);
            IPartHost iPartHost = this.getHost();
            if (iPartHost != null) {
                iPartHost.markForUpdate();
            }
            if (this.getLocked()) {
                player.func_145747_a((ITextComponent)new TextComponentTranslation("chat.appliedenergistics2.isNowLocked", new Object[0]));
            } else {
                player.func_145747_a((ITextComponent)new TextComponentTranslation("chat.appliedenergistics2.isNowUnlocked", new Object[0]));
            }
            return true;
        }
        if (this.getLocked()) {
            return false;
        }
        if (GasUtil.isFilled(s)) {
            if (this.getFluid() != null && this.getWatcher() != null) {
                IStackWatcher iStackWatcher = this.getWatcher();
                if (iStackWatcher == null) {
                    Intrinsics.throwNpe();
                }
                iStackWatcher.remove((IAEStack)AEUtils.createFluidStack(this.getFluid()));
            }
            GasStack gas = GasUtil.getGasFromContainer(s);
            FluidStack fluidStack = GasUtil.getFluidStack(gas);
            this.setFluid((Fluid)(fluidStack != null ? fluidStack.getFluid() : null));
            if (this.getWatcher() != null) {
                IStackWatcher iStackWatcher = this.getWatcher();
                if (iStackWatcher == null) {
                    Intrinsics.throwNpe();
                }
                iStackWatcher.add((IAEStack)AEUtils.createFluidStack(this.getFluid()));
            }
            IPartHost iPartHost = this.getHost();
            if (iPartHost != null) {
                iPartHost.markForUpdate();
            }
            return true;
        }
        return false;
    }

    @Override
    @Optional.Method(modid="MekanismAPI|gas")
    public void onStackChange() {
        block8: {
            if (this.getFluid() == null) break block8;
            IGridNode iGridNode = this.getGridNode();
            if (iGridNode == null) {
                return;
            }
            IGridNode node = iGridNode;
            IGrid iGrid = node.getGrid();
            if (iGrid == null) {
                return;
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)iGrid, (String)"node.grid ?: return");
            IGrid grid = iGrid;
            IStorageGrid iStorageGrid = (IStorageGrid)grid.getCache(IStorageGrid.class);
            if (iStorageGrid == null) {
                return;
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)iStorageGrid, (String)"grid.getCache<IStorageGr\u2026id::class.java) ?: return");
            IStorageGrid storage = iStorageGrid;
            IMEMonitor<IAEGasStack> iMEMonitor = this.getGasStorage();
            if (iMEMonitor == null) {
                return;
            }
            IMEMonitor<IAEGasStack> fluids = iMEMonitor;
            Gas gas = GasUtil.getGas(this.getFluid());
            Iterator iterator = fluids.getStorageList().iterator();
            while (iterator.hasNext()) {
                IAEGasStack s;
                IAEGasStack iAEGasStack = s = (IAEGasStack)iterator.next();
                if (iAEGasStack == null) {
                    Intrinsics.throwNpe();
                }
                if (!Intrinsics.areEqual((Object)iAEGasStack.getGas(), (Object)gas)) continue;
                this.setAmount(s.getStackSize());
                IPartHost iPartHost = this.getHost();
                if (iPartHost != null) {
                    iPartHost.markForUpdate();
                }
                return;
            }
            this.setAmount(0L);
            IPartHost iPartHost = this.getHost();
            if (iPartHost != null) {
                iPartHost.markForUpdate();
            }
        }
    }

    @Override
    @NotNull
    public IPartModel getStaticModels() {
        return this.isActive() && this.isPowered() ? (IPartModel)PartModels.CONVERSION_MONITOR_HAS_CHANNEL : (IPartModel)(this.isPowered() ? PartModels.CONVERSION_MONITOR_ON : PartModels.CONVERSION_MONITOR_OFF);
    }

    @Override
    public void updateWatcher(@Nullable IStackWatcher w) {
        this.setWatcher(w);
        if (this.getFluid() != null) {
            IStackWatcher iStackWatcher = w;
            if (iStackWatcher == null) {
                Intrinsics.throwNpe();
            }
            IGasStorageChannel iGasStorageChannel = StorageChannels.GAS;
            if (iGasStorageChannel == null) {
                Intrinsics.throwNpe();
            }
            Fluid fluid = this.getFluid();
            if (fluid == null) {
                Intrinsics.throwNpe();
            }
            iStackWatcher.add(iGasStorageChannel.createStack(fluid));
        }
        this.onStackChange(null, null, null, null, null);
    }
}

