/*
 * Decompiled with CFR 0.152.
 */
package com.the9grounds.aeadditions.tileentity;

import appeng.api.AEApi;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridBlock;
import appeng.api.networking.IGridNode;
import appeng.api.networking.energy.IEnergyGrid;
import appeng.api.networking.events.MENetworkCellArrayUpdate;
import appeng.api.networking.events.MENetworkEvent;
import appeng.api.networking.events.MENetworkEventSubscribe;
import appeng.api.networking.events.MENetworkPowerStatusChange;
import appeng.api.networking.security.IActionHost;
import appeng.api.storage.ICellContainer;
import appeng.api.storage.ICellHandler;
import appeng.api.storage.ICellInventory;
import appeng.api.storage.ICellInventoryHandler;
import appeng.api.storage.ICellRegistry;
import appeng.api.storage.IMEInventoryHandler;
import appeng.api.storage.IStorageChannel;
import appeng.api.util.AECableType;
import appeng.api.util.AEPartLocation;
import appeng.api.util.DimensionalCoord;
import com.the9grounds.aeadditions.api.IECTileEntity;
import com.the9grounds.aeadditions.container.ContainerHardMEDrive;
import com.the9grounds.aeadditions.gridblock.ECGridBlockHardMEDrive;
import com.the9grounds.aeadditions.gui.GuiHardMEDrive;
import com.the9grounds.aeadditions.inventory.IInventoryListener;
import com.the9grounds.aeadditions.inventory.InventoryPlain;
import com.the9grounds.aeadditions.models.drive.IECDrive;
import com.the9grounds.aeadditions.network.IGuiProvider;
import com.the9grounds.aeadditions.tileentity.TileBase;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntityHardMeDrive
extends TileBase
implements IActionHost,
IECTileEntity,
ICellContainer,
IInventoryListener,
IECDrive,
IGuiProvider {
    private int priority = 0;
    private boolean isPowerd;
    boolean isFirstGridNode = true;
    byte[] cellStatuses = new byte[3];
    List<IMEInventoryHandler> handlers = new ArrayList<IMEInventoryHandler>();
    private final ECGridBlockHardMEDrive gridBlock = new ECGridBlockHardMEDrive(this);
    private InventoryPlain inventory = new InventoryPlain("com.the9grounds.aeadditions.part.drive", 3, 1, this){
        ICellRegistry cellRegistry;
        {
            this.cellRegistry = AEApi.instance().registries().cell();
        }

        @Override
        public boolean func_94041_b(int i, ItemStack itemStack) {
            return this.cellRegistry.isCellHandled(itemStack);
        }

        @Override
        protected void onContentsChanged() {
            TileEntityHardMeDrive.this.saveData();
        }
    };
    IGridNode node = null;

    public IInventory getInventory() {
        return this.inventory;
    }

    public boolean isUseableByPlayer(EntityPlayer player) {
        return this.field_145850_b.func_175625_s(this.field_174879_c) == this && player.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) <= 64.0;
    }

    public void blinkCell(int i) {
    }

    public IGridNode getActionableNode() {
        return this.getGridNode(AEPartLocation.INTERNAL);
    }

    public List<IMEInventoryHandler> getCellArray(IStorageChannel channel) {
        if (!this.isActive()) {
            return new ArrayList<IMEInventoryHandler>();
        }
        ArrayList<IMEInventoryHandler> channelHandlers = new ArrayList<IMEInventoryHandler>();
        this.handlers = this.updateHandlers();
        for (IMEInventoryHandler handler : this.handlers) {
            if (handler.getChannel() != channel) continue;
            channelHandlers.add(handler);
        }
        return channelHandlers;
    }

    public int getPriority() {
        return this.priority;
    }

    @Override
    public DimensionalCoord getLocation() {
        return new DimensionalCoord((TileEntity)this);
    }

    @Override
    public double getPowerUsage() {
        return 0.0;
    }

    public IGridNode getGridNode(AEPartLocation location) {
        if (this.isFirstGridNode && this.func_145830_o() && !this.func_145831_w().field_72995_K) {
            this.isFirstGridNode = false;
            try {
                this.node = AEApi.instance().grid().createGridNode((IGridBlock)this.gridBlock);
                this.node.updateState();
            }
            catch (Exception e) {
                this.isFirstGridNode = true;
            }
        }
        return this.node;
    }

    public AECableType getCableConnectionType(AEPartLocation location) {
        return AECableType.SMART;
    }

    public void securityBreak() {
    }

    public void saveChanges(ICellInventory<?> imeInventory) {
        this.field_145850_b.func_175646_b(this.field_174879_c, (TileEntity)this);
    }

    boolean isActive() {
        return true;
    }

    public int getColorByStatus(int status) {
        switch (status) {
            case 1: {
                return 65280;
            }
            case 2: {
                return 0xFFFF00;
            }
            case 3: {
                return 0xFF0000;
            }
        }
        return 0;
    }

    @Override
    public void onInventoryChanged() {
        this.handlers = this.updateHandlers();
        Collection channels = AEApi.instance().storage().storageChannels();
        for (int i = 0; i < this.cellStatuses.length; ++i) {
            ICellHandler cellHandler;
            ItemStack stackInSlot = this.inventory.func_70301_a(i);
            ICellInventoryHandler inventoryHandler = null;
            for (IStorageChannel channel : channels) {
                inventoryHandler = AEApi.instance().registries().cell().getCellInventory(stackInSlot, null, channel);
                if (inventoryHandler == null) continue;
                break;
            }
            this.cellStatuses[i] = (cellHandler = AEApi.instance().registries().cell().getHandler(stackInSlot)) == null || inventoryHandler == null ? (byte)0 : (byte)cellHandler.getStatusForCell(stackInSlot, inventoryHandler);
        }
        IGridNode node = this.getGridNode(AEPartLocation.INTERNAL);
        if (node != null) {
            IGrid grid = node.getGrid();
            if (grid != null) {
                grid.postEvent((MENetworkEvent)new MENetworkCellArrayUpdate());
            }
            this.updateBlock();
        }
        if (this.field_145850_b != null && this.field_145850_b.field_72995_K) {
            this.field_145850_b.func_175704_b(this.field_174879_c, this.field_174879_c);
        }
    }

    private List<IMEInventoryHandler> updateHandlers() {
        ICellRegistry cellRegistry = AEApi.instance().registries().cell();
        ArrayList<IMEInventoryHandler> handlers = new ArrayList<IMEInventoryHandler>();
        for (IStorageChannel channel : AEApi.instance().storage().storageChannels()) {
            for (int i = 0; i < this.inventory.func_70302_i_(); ++i) {
                ICellInventoryHandler cellInventory;
                ItemStack cell = this.inventory.func_70301_a(i);
                if (!cellRegistry.isCellHandled(cell) || (cellInventory = cellRegistry.getCellInventory(cell, null, channel)) == null) continue;
                handlers.add((IMEInventoryHandler)cellInventory);
            }
        }
        return handlers;
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.inventory.readFromNBT(tag.func_150295_c("inventory", 10));
        this.onInventoryChanged();
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        super.func_189515_b(tag);
        tag.func_74782_a("inventory", (NBTBase)this.inventory.writeToNBT());
        return tag;
    }

    public NBTTagCompound func_189517_E_() {
        NBTTagCompound tag = new NBTTagCompound();
        int i = 0;
        for (byte aCellStati : this.cellStatuses) {
            tag.func_74774_a("status#" + i, aCellStati);
            ++i;
        }
        tag.func_74757_a("isPowerd", this.isPowerd);
        return tag;
    }

    @Override
    public int getCellCount() {
        return 3;
    }

    @Override
    public int getCellStatus(int index) {
        return this.cellStatuses[index];
    }

    @Override
    public boolean isPowered() {
        return this.isPowerd;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiContainer getClientGuiElement(EntityPlayer player, Object ... args) {
        return new GuiHardMEDrive(player.field_71071_by, this);
    }

    @Override
    public Container getServerGuiElement(EntityPlayer player, Object ... args) {
        return new ContainerHardMEDrive(player.field_71071_by, this);
    }

    @MENetworkEventSubscribe
    public void setPower(MENetworkPowerStatusChange notUsed) {
        if (this.node != null) {
            IEnergyGrid energy;
            IGrid grid = this.node.getGrid();
            if (grid != null && (energy = (IEnergyGrid)grid.getCache(IEnergyGrid.class)) != null) {
                this.isPowerd = energy.isNetworkPowered();
            }
            this.updateBlock();
        }
    }

    public void handleUpdateTag(NBTTagCompound tag) {
        this.isPowerd = tag.func_74767_n("isPowerd");
        for (int i = 0; i < this.cellStatuses.length; ++i) {
            this.cellStatuses[i] = tag.func_74771_c("status#" + i);
        }
        if (this.field_145850_b != null && this.field_145850_b.field_72995_K) {
            this.field_145850_b.func_175704_b(this.func_174877_v(), this.func_174877_v());
        }
    }
}

