/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.intercompatibility;

import de.maxhenkel.voicechat.ForgeVoicechatMod;
import de.maxhenkel.voicechat.Voicechat;
import de.maxhenkel.voicechat.api.ForgeVoicechatPlugin;
import de.maxhenkel.voicechat.api.VoicechatPlugin;
import de.maxhenkel.voicechat.events.ServerVoiceChatConnectedEvent;
import de.maxhenkel.voicechat.events.ServerVoiceChatDisconnectedEvent;
import de.maxhenkel.voicechat.events.VoiceChatCompatibilityCheckSucceededEvent;
import de.maxhenkel.voicechat.intercompatibility.CommonCompatibilityManager;
import de.maxhenkel.voicechat.net.ForgeNetManager;
import de.maxhenkel.voicechat.net.NetManager;
import de.maxhenkel.voicechat.permission.ForgePermissionManager;
import de.maxhenkel.voicechat.permission.PermissionManager;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.discovery.ASMDataTable;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartedEvent;
import net.minecraftforge.fml.common.event.FMLServerStoppingEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;

public class ForgeCommonCompatibilityManager
extends CommonCompatibilityManager {
    private final List<Consumer<MinecraftServer>> serverStartingEvents = new ArrayList<Consumer<MinecraftServer>>();
    private final List<Consumer<MinecraftServer>> serverStoppingEvents = new ArrayList<Consumer<MinecraftServer>>();
    private final List<Consumer<EntityPlayerMP>> playerLoggedInEvents = new ArrayList<Consumer<EntityPlayerMP>>();
    private final List<Consumer<EntityPlayerMP>> playerLoggedOutEvents = new ArrayList<Consumer<EntityPlayerMP>>();
    private final List<Consumer<EntityPlayerMP>> voicechatConnectEvents = new ArrayList<Consumer<EntityPlayerMP>>();
    private final List<Consumer<EntityPlayerMP>> voicechatCompatibilityCheckSucceededEvents = new ArrayList<Consumer<EntityPlayerMP>>();
    private final List<Consumer<UUID>> voicechatDisconnectEvents = new ArrayList<Consumer<UUID>>();
    private ASMDataTable asmDataTable;
    private ForgeNetManager netManager;

    public void preInit(FMLPreInitializationEvent event) {
        this.asmDataTable = event.getAsmData();
    }

    public void serverStarted(FMLServerStartedEvent event) {
        this.serverStartingEvents.forEach(consumer -> consumer.accept(FMLCommonHandler.instance().getMinecraftServerInstance()));
    }

    public void serverStopping(FMLServerStoppingEvent event) {
        this.serverStoppingEvents.forEach(consumer -> consumer.accept(FMLCommonHandler.instance().getMinecraftServerInstance()));
    }

    @SubscribeEvent
    public void playerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        if (event.player instanceof EntityPlayerMP) {
            EntityPlayerMP player = (EntityPlayerMP)event.player;
            this.playerLoggedInEvents.forEach(consumer -> consumer.accept(player));
        }
    }

    @SubscribeEvent
    public void playerLoggedOut(PlayerEvent.PlayerLoggedOutEvent event) {
        if (event.player instanceof EntityPlayerMP) {
            EntityPlayerMP player = (EntityPlayerMP)event.player;
            this.playerLoggedOutEvents.forEach(consumer -> consumer.accept(player));
        }
    }

    @Override
    public String getModVersion() {
        ModContainer modContainer = Loader.instance().activeModContainer();
        if (modContainer == null) {
            return "N/A";
        }
        return modContainer.getVersion();
    }

    @Override
    public String getModName() {
        ModContainer modContainer = Loader.instance().activeModContainer();
        if (modContainer == null) {
            return "N/A";
        }
        return modContainer.getName();
    }

    @Override
    public Path getGameDirectory() {
        return Loader.instance().getConfigDir().toPath().getParent();
    }

    @Override
    public void emitServerVoiceChatConnectedEvent(EntityPlayerMP player) {
        this.voicechatConnectEvents.forEach(consumer -> consumer.accept(player));
        MinecraftForge.EVENT_BUS.post((Event)new ServerVoiceChatConnectedEvent(player));
    }

    @Override
    public void emitServerVoiceChatDisconnectedEvent(UUID clientID) {
        this.voicechatDisconnectEvents.forEach(consumer -> consumer.accept(clientID));
        MinecraftForge.EVENT_BUS.post((Event)new ServerVoiceChatDisconnectedEvent(clientID));
    }

    @Override
    public void emitPlayerCompatibilityCheckSucceeded(EntityPlayerMP player) {
        this.voicechatCompatibilityCheckSucceededEvents.forEach(consumer -> consumer.accept(player));
        MinecraftForge.EVENT_BUS.post((Event)new VoiceChatCompatibilityCheckSucceededEvent(player));
    }

    @Override
    public void onServerVoiceChatConnected(Consumer<EntityPlayerMP> onVoiceChatConnected) {
        this.voicechatConnectEvents.add(onVoiceChatConnected);
    }

    @Override
    public void onServerVoiceChatDisconnected(Consumer<UUID> onVoiceChatDisconnected) {
        this.voicechatDisconnectEvents.add(onVoiceChatDisconnected);
    }

    @Override
    public void onServerStarting(Consumer<MinecraftServer> onServerStarting) {
        this.serverStartingEvents.add(onServerStarting);
    }

    @Override
    public void onServerStopping(Consumer<MinecraftServer> onServerStopping) {
        this.serverStoppingEvents.add(onServerStopping);
    }

    @Override
    public void onPlayerLoggedIn(Consumer<EntityPlayerMP> onPlayerLoggedIn) {
        this.playerLoggedInEvents.add(onPlayerLoggedIn);
    }

    @Override
    public void onPlayerLoggedOut(Consumer<EntityPlayerMP> onPlayerLoggedOut) {
        this.playerLoggedOutEvents.add(onPlayerLoggedOut);
    }

    @Override
    public void onPlayerCompatibilityCheckSucceeded(Consumer<EntityPlayerMP> onPlayerCompatibilityCheckSucceeded) {
        this.voicechatCompatibilityCheckSucceededEvents.add(onPlayerCompatibilityCheckSucceeded);
    }

    @Override
    public NetManager getNetManager() {
        if (this.netManager == null) {
            this.netManager = new ForgeNetManager();
        }
        return this.netManager;
    }

    @Override
    public boolean isDevEnvironment() {
        return !FMLCommonHandler.instance().findContainerFor((Object)ForgeVoicechatMod.INSTANCE).getSource().isFile();
    }

    @Override
    public boolean isDedicatedServer() {
        try {
            Class.forName("net.minecraft.client.Minecraft");
            return false;
        }
        catch (Exception e) {
            return true;
        }
    }

    @Override
    public List<VoicechatPlugin> loadPlugins() {
        ArrayList<VoicechatPlugin> plugins = new ArrayList<VoicechatPlugin>();
        String annotationClassName = ForgeVoicechatPlugin.class.getCanonicalName();
        Set asmDatas = this.asmDataTable.getAll(annotationClassName);
        for (ASMDataTable.ASMData asmData : asmDatas) {
            try {
                Class<?> clazz = Class.forName(asmData.getClassName());
                if (!VoicechatPlugin.class.isAssignableFrom(clazz)) continue;
                VoicechatPlugin plugin = (VoicechatPlugin)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                plugins.add(plugin);
            }
            catch (Throwable e) {
                Voicechat.LOGGER.warn("Failed to load plugin '{}'", asmData.getClassName(), e);
            }
        }
        return plugins;
    }

    @Override
    public PermissionManager createPermissionManager() {
        return new ForgePermissionManager();
    }
}

