/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.libVulpes.render;

import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class RenderHelper {
    public static void renderTag(double distanceSq, String displayString, double x, double y, double z, int sizeOnScreen) {
        RenderHelper.renderTag(distanceSq, displayString, x, y, z, 6, 1.0f);
    }

    public static void renderTag(double distanceSq, String displayString, double x, double y, double z, int sizeOnScreen, float scale) {
        double d3 = distanceSq;
        Minecraft mc = Minecraft.func_71410_x();
        RenderManager renderManager = mc.func_175598_ae();
        if (d3 <= (double)(sizeOnScreen * sizeOnScreen)) {
            FontRenderer fontrenderer = mc.field_71466_p;
            float f = 1.6f * scale;
            float f1 = 0.016666668f * f;
            GL11.glPushMatrix();
            GL11.glTranslatef((float)((float)x + 0.0f), (float)((float)y + 0.5f), (float)((float)z));
            GL11.glRotatef((float)(-renderManager.field_78735_i), (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glRotatef((float)renderManager.field_78732_j, (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glScalef((float)(-f1), (float)(-f1), (float)f1);
            GlStateManager.func_179140_f();
            GlStateManager.func_179132_a((boolean)false);
            GlStateManager.func_179097_i();
            GlStateManager.func_179147_l();
            GlStateManager.func_179112_b((int)770, (int)771);
            Tessellator tessellator = Tessellator.func_178181_a();
            int b0 = 0;
            BufferBuilder buffer = tessellator.func_178180_c();
            GlStateManager.func_179090_x();
            buffer.func_181668_a(7, DefaultVertexFormats.field_181705_e);
            int j = fontrenderer.func_78256_a(displayString) / 2;
            GlStateManager.func_179131_c((float)0.0f, (float)0.0f, (float)0.0f, (float)0.25f);
            buffer.func_181662_b((double)(-j - 1), (double)(-1 + b0), 0.0).func_181675_d();
            buffer.func_181662_b((double)(-j - 1), (double)(8 + b0), 0.0).func_181675_d();
            buffer.func_181662_b((double)(j + 1), (double)(8 + b0), 0.0).func_181675_d();
            buffer.func_181662_b((double)(j + 1), (double)(-1 + b0), 0.0).func_181675_d();
            tessellator.func_78381_a();
            GlStateManager.func_179098_w();
            fontrenderer.func_78276_b(displayString, -fontrenderer.func_78256_a(displayString) / 2, b0, 0x20FFFFFF);
            GlStateManager.func_179132_a((boolean)true);
            fontrenderer.func_78276_b(displayString, -fontrenderer.func_78256_a(displayString) / 2, b0, -1);
            GlStateManager.func_179145_e();
            GlStateManager.func_179126_j();
            GlStateManager.func_179084_k();
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glPopMatrix();
        }
    }

    public static void setupPlayerFacingMatrix(double distanceSq, double x, double y, double z) {
        Minecraft mc = Minecraft.func_71410_x();
        RenderManager renderManager = mc.func_175598_ae();
        float f = 1.6f;
        float f1 = 0.016666668f * f;
        GL11.glPushMatrix();
        GL11.glTranslatef((float)((float)x + 0.0f), (float)((float)y + 0.5f), (float)((float)z));
        GL11.glRotatef((float)(-renderManager.field_78735_i), (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)renderManager.field_78732_j, (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glScalef((float)(-f1), (float)(-f1), (float)f1);
    }

    public static void cleanupPlayerFacingMatrix() {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glPopMatrix();
    }

    public static void renderBlockWithEndPointers(BufferBuilder buff, double radius, double x1, double y1, double z1, double x2, double y2, double z2) {
        RenderHelper.renderBottomFaceEndpoints(buff, radius, x1, y1 - radius / 2.0, z1, x2, y2 - radius / 2.0, z2);
        RenderHelper.renderTopFaceEndpoints(buff, radius, x1, y1 + radius / 2.0, z1, x2, y2 + radius / 2.0, z2);
        RenderHelper.renderNorthFaceEndpoints(buff, radius, x1, y1, z1 + radius / 2.0, x2, y2, z2 + radius / 2.0);
        RenderHelper.renderSouthFaceEndpoints(buff, radius, x1, y1, z1 - radius / 2.0, x2, y2, z2 - radius / 2.0);
        RenderHelper.renderEastFaceEndpoints(buff, radius, x1 + radius / 2.0, y1, z1, x2 + radius / 2.0, y2, z2);
        RenderHelper.renderWestFaceEndpoints(buff, radius, x1 - radius / 2.0, y1, z1, x2 - radius / 2.0, y2, z2);
    }

    public static void renderCrossXZ(BufferBuilder buff, double width, double xMin, double yMin, double zMin, double xMax, double yMax, double zMax) {
        RenderHelper.renderTopFaceEndpoints(buff, width, xMin, yMin, zMin, xMax, yMax, zMax);
        RenderHelper.renderBottomFaceEndpoints(buff, width, xMin, yMin, zMin, xMax, yMax, zMax);
        RenderHelper.renderNorthFaceEndpoints(buff, width, xMin, yMin, zMin, xMax, yMax, zMax);
        RenderHelper.renderSouthFaceEndpoints(buff, width, xMin, yMin, zMin, xMax, yMax, zMax);
    }

    public static void renderTopFace(BufferBuilder buff, double yMax, double xMin, double zMin, double xMax, double zMax) {
        buff.func_181662_b(xMin, yMax, zMin).func_181663_c(0.0f, 1.0f, 0.0f).func_181675_d();
        buff.func_181662_b(xMin, yMax, zMax).func_181663_c(0.0f, 1.0f, 0.0f).func_181675_d();
        buff.func_181662_b(xMax, yMax, zMax).func_181663_c(0.0f, 1.0f, 0.0f).func_181675_d();
        buff.func_181662_b(xMax, yMax, zMin).func_181663_c(0.0f, 1.0f, 0.0f).func_181675_d();
    }

    public static void renderTopFaceEndpoints(BufferBuilder buff, double width, double xMin, double yMin, double zMin, double xMax, double yMax, double zMax) {
        buff.func_181662_b(xMin, yMin, zMin - width).func_181663_c(0.0f, 1.0f, 0.0f).func_181675_d();
        buff.func_181662_b(xMin, yMin, zMin + width).func_181663_c(0.0f, 1.0f, 0.0f).func_181675_d();
        buff.func_181662_b(xMax, yMax, zMax + width).func_181663_c(0.0f, 1.0f, 0.0f).func_181675_d();
        buff.func_181662_b(xMax, yMax, zMax - width).func_181663_c(0.0f, 1.0f, 0.0f).func_181675_d();
    }

    public static void renderBottomFace(BufferBuilder buff, double yMax, double xMin, double zMin, double xMax, double zMax) {
        buff.func_181662_b(xMax, yMax, zMin).func_181663_c(0.0f, -1.0f, 0.0f).func_181675_d();
        buff.func_181662_b(xMax, yMax, zMax).func_181663_c(0.0f, -1.0f, 0.0f).func_181675_d();
        buff.func_181662_b(xMin, yMax, zMax).func_181663_c(0.0f, -1.0f, 0.0f).func_181675_d();
        buff.func_181662_b(xMin, yMax, zMin).func_181663_c(0.0f, -1.0f, 0.0f).func_181675_d();
    }

    public static void renderBottomFaceEndpoints(BufferBuilder buff, double width, double xMin, double yMin, double zMin, double xMax, double yMax, double zMax) {
        buff.func_181662_b(xMin, yMin, zMin + width).func_181663_c(0.0f, -1.0f, 0.0f).func_181675_d();
        buff.func_181662_b(xMin, yMin, zMin - width).func_181663_c(0.0f, -1.0f, 0.0f).func_181675_d();
        buff.func_181662_b(xMax, yMax, zMax - width).func_181663_c(0.0f, -1.0f, 0.0f).func_181675_d();
        buff.func_181662_b(xMax, yMax, zMax + width).func_181663_c(0.0f, -1.0f, 0.0f).func_181675_d();
    }

    public static void renderNorthFace(BufferBuilder buff, double zMin, double xMin, double yMin, double xMax, double yMax) {
        buff.func_181662_b(xMin, yMax, zMin).func_181663_c(0.0f, 0.0f, 1.0f).func_181675_d();
        buff.func_181662_b(xMax, yMax, zMin).func_181663_c(0.0f, 0.0f, 1.0f).func_181675_d();
        buff.func_181662_b(xMax, yMin, zMin).func_181663_c(0.0f, 0.0f, 1.0f).func_181675_d();
        buff.func_181662_b(xMin, yMin, zMin).func_181663_c(0.0f, 0.0f, 1.0f).func_181675_d();
    }

    public static void renderNorthFaceEndpoints(BufferBuilder buff, double width, double xMin, double yMin, double zMin, double xMax, double yMax, double zMax) {
        buff.func_181662_b(xMin, yMin + width, zMin).func_181663_c(0.0f, 0.0f, 1.0f).func_181675_d();
        buff.func_181662_b(xMax, yMax + width, zMax).func_181663_c(0.0f, 0.0f, 1.0f).func_181675_d();
        buff.func_181662_b(xMax, yMax - width, zMax).func_181663_c(0.0f, 0.0f, 1.0f).func_181675_d();
        buff.func_181662_b(xMin, yMin - width, zMin).func_181663_c(0.0f, 0.0f, 1.0f).func_181675_d();
    }

    public static void renderSouthFace(BufferBuilder buff, double zMax, double xMin, double yMin, double xMax, double yMax) {
        buff.func_181662_b(xMin, yMax, zMax).func_181663_c(0.0f, 0.0f, -1.0f).func_181675_d();
        buff.func_181662_b(xMin, yMin, zMax).func_181663_c(0.0f, 0.0f, -1.0f).func_181675_d();
        buff.func_181662_b(xMax, yMin, zMax).func_181663_c(0.0f, 0.0f, -1.0f).func_181675_d();
        buff.func_181662_b(xMax, yMax, zMax).func_181663_c(0.0f, 0.0f, -1.0f).func_181675_d();
    }

    public static void renderSouthFaceEndpoints(BufferBuilder buff, double width, double xMin, double yMin, double zMin, double xMax, double yMax, double zMax) {
        buff.func_181662_b(xMin, yMin + width, zMin).func_181663_c(0.0f, 0.0f, -1.0f).func_181675_d();
        buff.func_181662_b(xMin, yMin - width, zMin).func_181663_c(0.0f, 0.0f, -1.0f).func_181675_d();
        buff.func_181662_b(xMax, yMax - width, zMax).func_181663_c(0.0f, 0.0f, -1.0f).func_181675_d();
        buff.func_181662_b(xMax, yMax + width, zMax).func_181663_c(0.0f, 0.0f, -1.0f).func_181675_d();
    }

    public static void renderEastFace(BufferBuilder buff, double xMax, double yMin, double zMin, double yMax, double zMax) {
        buff.func_181662_b(xMax, yMax, zMin).func_181663_c(1.0f, 0.0f, 0.0f).func_181675_d();
        buff.func_181662_b(xMax, yMax, zMax).func_181663_c(1.0f, 0.0f, 0.0f).func_181675_d();
        buff.func_181662_b(xMax, yMin, zMax).func_181663_c(1.0f, 0.0f, 0.0f).func_181675_d();
        buff.func_181662_b(xMax, yMin, zMin).func_181663_c(1.0f, 0.0f, 0.0f).func_181675_d();
    }

    public static void renderEastFaceEndpoints(BufferBuilder buff, double width, double xMin, double yMin, double zMin, double xMax, double yMax, double zMax) {
        buff.func_181662_b(xMax, yMax + width, zMin).func_181663_c(1.0f, 0.0f, 0.0f).func_181675_d();
        buff.func_181662_b(xMax, yMax - width, zMax).func_181663_c(1.0f, 0.0f, 0.0f).func_181675_d();
        buff.func_181662_b(xMax, yMin - width, zMax).func_181663_c(1.0f, 0.0f, 0.0f).func_181675_d();
        buff.func_181662_b(xMax, yMin + width, zMin).func_181663_c(1.0f, 0.0f, 0.0f).func_181675_d();
    }

    public static void renderWestFace(BufferBuilder buff, double xMin, double yMin, double zMin, double yMax, double zMax) {
        buff.func_181662_b(xMin, yMin, zMin).func_181663_c(-1.0f, 0.0f, 0.0f).func_181675_d();
        buff.func_181662_b(xMin, yMin, zMax).func_181663_c(-1.0f, 0.0f, 0.0f).func_181675_d();
        buff.func_181662_b(xMin, yMax, zMax).func_181663_c(-1.0f, 0.0f, 0.0f).func_181675_d();
        buff.func_181662_b(xMin, yMax, zMin).func_181663_c(-1.0f, 0.0f, 0.0f).func_181675_d();
    }

    public static void renderWestFaceEndpoints(BufferBuilder buff, double width, double xMin, double yMin, double zMin, double xMax, double yMax, double zMax) {
        buff.func_181662_b(xMin, yMin + width, zMin).func_181663_c(-1.0f, 0.0f, 0.0f).func_181675_d();
        buff.func_181662_b(xMin, yMin - width, zMax).func_181663_c(-1.0f, 0.0f, 0.0f).func_181675_d();
        buff.func_181662_b(xMin, yMax - width, zMax).func_181663_c(-1.0f, 0.0f, 0.0f).func_181675_d();
        buff.func_181662_b(xMin, yMax + width, zMin).func_181663_c(-1.0f, 0.0f, 0.0f).func_181675_d();
    }

    public static void renderTopFaceWithUV(BufferBuilder buff, double yMax, double xMin, double zMin, double xMax, double zMax, double uMin, double uMax, double vMin, double vMax) {
        buff.func_181662_b(xMin, yMax, zMin).func_187315_a(uMin, vMin).func_181675_d();
        buff.func_181662_b(xMin, yMax, zMax).func_187315_a(uMin, vMax).func_181675_d();
        buff.func_181662_b(xMax, yMax, zMax).func_187315_a(uMax, vMax).func_181675_d();
        buff.func_181662_b(xMax, yMax, zMin).func_187315_a(uMax, vMin).func_181675_d();
    }

    public static void renderBottomFaceWithUV(BufferBuilder buff, double yMax, double xMin, double zMin, double xMax, double zMax, double uMin, double uMax, double vMin, double vMax) {
        buff.func_181662_b(xMax, yMax, zMax).func_187315_a(uMax, vMax).func_181675_d();
        buff.func_181662_b(xMin, yMax, zMax).func_187315_a(uMin, vMax).func_181675_d();
        buff.func_181662_b(xMin, yMax, zMin).func_187315_a(uMin, vMin).func_181675_d();
        buff.func_181662_b(xMax, yMax, zMin).func_187315_a(uMax, vMin).func_181675_d();
    }

    public static void renderNorthFaceWithUV(BufferBuilder buff, double zMin, double xMin, double yMin, double xMax, double yMax, double uMin, double uMax, double vMin, double vMax) {
        buff.func_181662_b(xMin, yMax, zMin).func_187315_a(uMin, vMin).func_181675_d();
        buff.func_181662_b(xMax, yMax, zMin).func_187315_a(uMax, vMin).func_181675_d();
        buff.func_181662_b(xMax, yMin, zMin).func_187315_a(uMax, vMax).func_181675_d();
        buff.func_181662_b(xMin, yMin, zMin).func_187315_a(uMin, vMax).func_181675_d();
    }

    public static void renderNorthFaceWithUVNoNormal(BufferBuilder buff, double zMin, double xMin, double yMin, double xMax, double yMax, double uMin, double uMax, double vMin, double vMax) {
        buff.func_181662_b(xMin, yMax, zMin).func_187315_a(uMin, vMin).func_181675_d();
        buff.func_181662_b(xMax, yMax, zMin).func_187315_a(uMax, vMin).func_181675_d();
        buff.func_181662_b(xMax, yMin, zMin).func_187315_a(uMax, vMax).func_181675_d();
        buff.func_181662_b(xMin, yMin, zMin).func_187315_a(uMin, vMax).func_181675_d();
    }

    public static void renderSouthFaceWithUV(BufferBuilder buff, double zMax, double xMin, double yMin, double xMax, double yMax, double uMin, double uMax, double vMin, double vMax) {
        buff.func_181662_b(xMin, yMax, zMax).func_187315_a(uMin, vMin).func_181675_d();
        buff.func_181662_b(xMin, yMin, zMax).func_187315_a(uMin, vMax).func_181675_d();
        buff.func_181662_b(xMax, yMin, zMax).func_187315_a(uMax, vMax).func_181675_d();
        buff.func_181662_b(xMax, yMax, zMax).func_187315_a(uMax, vMin).func_181675_d();
    }

    public static void renderEastFaceWithUV(BufferBuilder buff, double xMax, double yMin, double zMin, double yMax, double zMax, double uMin, double uMax, double vMin, double vMax) {
        buff.func_181662_b(xMax, yMax, zMin).func_187315_a(uMin, vMin).func_181675_d();
        buff.func_181662_b(xMax, yMax, zMax).func_187315_a(uMax, vMin).func_181675_d();
        buff.func_181662_b(xMax, yMin, zMax).func_187315_a(uMax, vMax).func_181675_d();
        buff.func_181662_b(xMax, yMin, zMin).func_187315_a(uMin, vMax).func_181675_d();
    }

    public static void renderWestFaceWithUV(BufferBuilder buff, double xMin, double yMin, double zMin, double yMax, double zMax, double uMin, double uMax, double vMin, double vMax) {
        buff.func_181662_b(xMin, yMin, zMin).func_187315_a(uMin, vMax).func_181675_d();
        buff.func_181662_b(xMin, yMin, zMax).func_187315_a(uMax, vMax).func_181675_d();
        buff.func_181662_b(xMin, yMax, zMax).func_187315_a(uMax, vMin).func_181675_d();
        buff.func_181662_b(xMin, yMax, zMin).func_187315_a(uMin, vMin).func_181675_d();
    }

    public static void renderCubeWithUV(BufferBuilder buff, double xMin, double yMin, double zMin, double xMax, double yMax, double zMax, double uMin, double uMax, double vMin, double vMax) {
        RenderHelper.renderTopFaceWithUV(buff, yMax, xMin, zMin, xMax, zMax, uMin, uMax, vMin, vMax);
        RenderHelper.renderNorthFaceWithUV(buff, zMin, xMin, yMin, xMax, yMax, uMin, uMax, vMin, vMax);
        RenderHelper.renderSouthFaceWithUV(buff, zMax, xMin, yMin, xMax, yMax, uMin, uMax, vMin, vMax);
        RenderHelper.renderEastFaceWithUV(buff, xMax, yMin, zMin, yMax, zMax, uMin, uMax, vMin, vMax);
        RenderHelper.renderWestFaceWithUV(buff, xMin, yMin, zMin, yMax, zMax, uMin, uMax, vMin, vMax);
        RenderHelper.renderBottomFaceWithUV(buff, yMin, xMin, zMin, xMax, zMax, uMin, uMax, vMin, vMax);
    }

    public static void renderCube(BufferBuilder buff, double xMin, double yMin, double zMin, double xMax, double yMax, double zMax) {
        RenderHelper.renderTopFace(buff, yMax, xMin, zMin, xMax, zMax);
        RenderHelper.renderNorthFace(buff, zMin, xMin, yMin, xMax, yMax);
        RenderHelper.renderSouthFace(buff, zMax, xMin, yMin, xMax, yMax);
        RenderHelper.renderEastFace(buff, xMax, yMin, zMin, yMax, zMax);
        RenderHelper.renderWestFace(buff, xMin, yMin, zMin, yMax, zMax);
        RenderHelper.renderBottomFace(buff, yMin, xMin, zMin, xMax, zMax);
    }

    public static void renderItem(TileEntity tile, @Nonnull ItemStack itemstack, RenderItem dummyItem) {
        if (!itemstack.func_190926_b()) {
            EntityItem entityitem = new EntityItem(tile.func_145831_w(), 0.0, 0.0, 0.0, itemstack);
            Item item = entityitem.func_92059_d().func_77973_b();
            entityitem.func_92059_d().func_190920_e(1);
            entityitem.field_70290_d = 0.0f;
            GlStateManager.func_179140_f();
            GlStateManager.func_179152_a((float)0.5f, (float)0.5f, (float)0.5f);
            if (!dummyItem.func_175050_a(entityitem.func_92059_d())) {
                GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            }
            GlStateManager.func_179123_a();
            net.minecraft.client.renderer.RenderHelper.func_74519_b();
            dummyItem.func_181564_a(entityitem.func_92059_d(), ItemCameraTransforms.TransformType.FIXED);
            net.minecraft.client.renderer.RenderHelper.func_74518_a();
            GlStateManager.func_179099_b();
            GlStateManager.func_179145_e();
        }
    }

    public static void renderItem(TileEntity tile, EntityItem entityitem, RenderItem dummyItem) {
        GlStateManager.func_179140_f();
        GlStateManager.func_179152_a((float)0.5f, (float)0.5f, (float)0.5f);
        if (!dummyItem.func_175050_a(entityitem.func_92059_d())) {
            GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        }
        GlStateManager.func_179123_a();
        net.minecraft.client.renderer.RenderHelper.func_74519_b();
        dummyItem.func_181564_a(entityitem.func_92059_d(), ItemCameraTransforms.TransformType.FIXED);
        net.minecraft.client.renderer.RenderHelper.func_74518_a();
        GlStateManager.func_179099_b();
        GlStateManager.func_179145_e();
    }
}

