/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.libVulpes.util;

import java.util.ArrayList;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagByteArray;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraftforge.items.ItemStackHandler;
import zmaster587.libVulpes.interfaces.IInventoryUpdateCallback;

public class EmbeddedInventory
extends ItemStackHandler
implements ISidedInventory {
    private ItemStackHandler handler;
    private IInventoryUpdateCallback tile;
    private NonNullList<Boolean> slotInsert;
    private NonNullList<Boolean> slotExtract;

    public EmbeddedInventory(int size) {
        this.stacks = NonNullList.func_191197_a((int)size, (Object)ItemStack.field_190927_a);
        this.slotInsert = NonNullList.func_191197_a((int)size, (Object)true);
        this.slotExtract = NonNullList.func_191197_a((int)size, (Object)true);
    }

    public EmbeddedInventory(int size, IInventoryUpdateCallback tile) {
        this(size);
        this.tile = tile;
    }

    public void writeToNBT(NBTTagCompound nbt) {
        nbt.func_74768_a("size", this.stacks.size());
        NBTTagList list = new NBTTagList();
        for (int i = 0; i < this.stacks.size(); ++i) {
            ItemStack stack = (ItemStack)this.stacks.get(i);
            if (stack.func_190926_b()) continue;
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74774_a("Slot", (byte)i);
            stack.func_77955_b(tag);
            list.func_74742_a((NBTBase)tag);
        }
        nbt.func_74782_a("outputItems", (NBTBase)list);
        ArrayList<Byte> list2 = new ArrayList<Byte>();
        for (int i = 0; i < this.slotInsert.size(); ++i) {
            list2.add(i, (Boolean)this.slotInsert.get(i) != false ? (byte)1 : 0);
        }
        nbt.func_74782_a("slotInsert", (NBTBase)new NBTTagByteArray(list2));
        ArrayList<Byte> list3 = new ArrayList<Byte>();
        for (int i = 0; i < this.slotExtract.size(); ++i) {
            list3.add(i, (Boolean)this.slotExtract.get(i) != false ? (byte)1 : 0);
        }
        nbt.func_74782_a("slotExtract", (NBTBase)new NBTTagByteArray(list3));
    }

    protected void onContentsChanged(int slot) {
        super.onContentsChanged(slot);
        if (this.tile != null) {
            this.tile.onInventoryUpdated(slot);
        }
    }

    public void readFromNBT(NBTTagCompound nbt) {
        NBTTagList list = nbt.func_150295_c("outputItems", 10);
        this.stacks = NonNullList.func_191197_a((int)Math.max(nbt.func_74762_e("size") == 0 ? 4 : nbt.func_74762_e("size"), this.stacks.size()), (Object)ItemStack.field_190927_a);
        this.handler = new ItemStackHandler(this.stacks);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound tag = list.func_150305_b(i);
            byte slot = tag.func_74771_c("Slot");
            if (slot < 0 || slot >= this.stacks.size()) continue;
            this.stacks.set((int)slot, (Object)new ItemStack(tag));
        }
        byte[] list2 = nbt.func_74770_j("slotInsert");
        this.slotInsert = NonNullList.func_191197_a((int)list2.length, (Object)false);
        for (int i = 0; i < list2.length; ++i) {
            this.slotInsert.set(i, (Object)(list2[i] == 1 ? 1 : 0));
        }
        byte[] list3 = nbt.func_74770_j("slotExtract");
        this.slotExtract = NonNullList.func_191197_a((int)list3.length, (Object)false);
        for (int i = 0; i < list3.length; ++i) {
            this.slotExtract.set(i, (Object)(list3[i] == 1 ? 1 : 0));
        }
        if (this.slotInsert.size() == 0) {
            this.slotInsert = NonNullList.func_191197_a((int)4, (Object)false);
        }
        if (this.slotExtract.size() == 0) {
            this.slotExtract = NonNullList.func_191197_a((int)4, (Object)false);
        }
    }

    public int func_70302_i_() {
        return this.stacks.size();
    }

    @Nonnull
    public ItemStack func_70301_a(int slot) {
        if (slot >= this.stacks.size()) {
            return ItemStack.field_190927_a;
        }
        return (ItemStack)this.stacks.get(slot);
    }

    @Nonnull
    public ItemStack func_70298_a(int slot, int amt) {
        ItemStack stack = (ItemStack)this.stacks.get(slot);
        if (!stack.func_190926_b()) {
            ItemStack stack2 = stack.func_77979_a(Math.min(amt, stack.func_190916_E()));
            if (stack.func_190916_E() == 0) {
                this.stacks.set(slot, (Object)ItemStack.field_190927_a);
            }
            return stack2;
        }
        return ItemStack.field_190927_a;
    }

    public void func_70299_a(int slot, @Nonnull ItemStack stack) {
        this.stacks.set(slot, (Object)stack);
    }

    public boolean func_145818_k_() {
        return false;
    }

    public int func_70297_j_() {
        return 64;
    }

    public void setCanInsertSlot(int index, boolean bool) {
        this.slotInsert.set(index, (Object)bool);
    }

    public void setCanExtractSlot(int index, boolean bool) {
        this.slotExtract.set(index, (Object)bool);
    }

    public boolean func_70300_a(@Nullable EntityPlayer player) {
        return true;
    }

    public boolean func_191420_l() {
        for (ItemStack stack : this.stacks) {
            if (stack.func_190926_b()) continue;
            return false;
        }
        return true;
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public boolean func_94041_b(int slot, @Nonnull ItemStack item) {
        return ((ItemStack)this.stacks.get(slot)).func_190926_b() || ((ItemStack)this.stacks.get(slot)).func_77969_a(item) && ((ItemStack)this.stacks.get(slot)).func_77976_d() != ((ItemStack)this.stacks.get(slot)).func_190916_E();
    }

    @Nonnull
    public int[] func_180463_a(@Nullable EnumFacing side) {
        int[] array = new int[this.stacks.size()];
        for (int i = 0; i < this.stacks.size(); ++i) {
            array[i] = i;
        }
        return array;
    }

    public boolean func_180462_a(int index, @Nonnull ItemStack itemStackIn, @Nullable EnumFacing direction) {
        return (Boolean)this.slotInsert.get(index);
    }

    public boolean func_180461_b(int index, @Nonnull ItemStack stack, @Nullable EnumFacing direction) {
        return (Boolean)this.slotExtract.get(index);
    }

    @Nonnull
    public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
        if (!this.slotInsert.isEmpty() && ((Boolean)this.slotInsert.get(slot)).booleanValue()) {
            return super.insertItem(slot, stack, simulate);
        }
        return stack;
    }

    @Nonnull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (!this.slotExtract.isEmpty() && ((Boolean)this.slotExtract.get(slot)).booleanValue()) {
            return super.extractItem(slot, amount, simulate);
        }
        return ItemStack.field_190927_a;
    }

    @Nonnull
    public String func_70005_c_() {
        return "";
    }

    public void func_70296_d() {
    }

    @Nonnull
    public ItemStack func_70304_b(int index) {
        ItemStack stack = (ItemStack)this.stacks.get(index);
        this.stacks.set(index, (Object)ItemStack.field_190927_a);
        return stack;
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174890_g() {
        return 0;
    }

    public void func_174888_l() {
    }

    @Nonnull
    public ITextComponent func_145748_c_() {
        return new TextComponentString("Inventory");
    }
}

