/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.item;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.desht.pneumaticcraft.PneumaticCraftRepressurized;
import me.desht.pneumaticcraft.api.client.IFOVModifierItem;
import me.desht.pneumaticcraft.api.item.IItemRegistry;
import me.desht.pneumaticcraft.api.item.IPressurizable;
import me.desht.pneumaticcraft.api.item.IUpgradeAcceptor;
import me.desht.pneumaticcraft.client.render.pneumatic_armor.RenderCoordWireframe;
import me.desht.pneumaticcraft.client.render.pneumatic_armor.UpgradeRenderHandlerList;
import me.desht.pneumaticcraft.common.GuiHandler;
import me.desht.pneumaticcraft.common.config.ConfigHandler;
import me.desht.pneumaticcraft.common.item.IChargingStationGUIHolderItem;
import me.desht.pneumaticcraft.common.item.ItemPneumatic;
import me.desht.pneumaticcraft.common.pneumatic_armor.CommonArmorHandler;
import me.desht.pneumaticcraft.common.recipes.CraftingRegistrator;
import me.desht.pneumaticcraft.common.util.NBTUtil;
import me.desht.pneumaticcraft.common.util.UpgradableItemUtils;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.ISpecialArmor;
import net.minecraftforge.common.util.EnumHelper;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.items.ItemHandlerHelper;
import thaumcraft.api.items.IGoggles;
import thaumcraft.api.items.IRevealer;
import thaumcraft.api.items.IVisDiscountGear;

@Optional.InterfaceList(value={@Optional.Interface(iface="thaumcraft.api.items.IGoggles", modid="thaumcraft"), @Optional.Interface(iface="thaumcraft.api.items.IVisDiscountGear", modid="thaumcraft"), @Optional.Interface(iface="thaumcraft.api.items.IRevealer", modid="thaumcraft")})
public class ItemPneumaticArmor
extends ItemArmor
implements IPressurizable,
IChargingStationGUIHolderItem,
IUpgradeAcceptor,
ISpecialArmor,
IVisDiscountGear,
IGoggles,
IRevealer,
IFOVModifierItem {
    private static final ItemArmor.ArmorMaterial COMPRESSED_IRON_MATERIAL = EnumHelper.addArmorMaterial((String)"compressedIron", (String)"compressedIron", (int)24, (int[])new int[]{2, 5, 6, 2}, (int)9, (SoundEvent)SoundEvents.field_187725_r, (float)1.0f);
    private static final int[] ARMOR_VOLUMES = new int[]{12000, 12000, 28000, 12000};
    private static final int[] VIS_DISCOUNTS = new int[]{1, 2, 2, 5};
    private static final List<Set<Item>> applicableUpgrades = new ArrayList<Set<Item>>();
    public static final String NBT_SEARCH_STACK = "SearchStack";
    public static final String NBT_COORD_TRACKER = "CoordTracker";
    public static final String NBT_ENTITY_FILTER = "entityFilter";
    public static final String NBT_JUMP_BOOST = "jumpBoost";
    public static final String NBT_SPEED_BOOST = "speedBoost";
    public static final String NBT_BUILDER_MODE = "JetBootsBuilderMode";

    public ItemPneumaticArmor(String name, EntityEquipmentSlot equipmentSlotIn) {
        super(COMPRESSED_IRON_MATERIAL, PneumaticCraftRepressurized.proxy.getArmorRenderID("pneumaticcraft:textures/armor/pneumatic"), equipmentSlotIn);
        this.setRegistryName(name);
        this.func_77655_b(name);
        this.func_77637_a(PneumaticCraftRepressurized.tabPneumaticCraft);
    }

    public static boolean isPlayerWearingAnyPneumaticArmor(EntityPlayer player) {
        for (EntityEquipmentSlot slot : UpgradeRenderHandlerList.ARMOR_SLOTS) {
            if (!ItemPneumaticArmor.isPneumaticArmorPiece(player, slot)) continue;
            return true;
        }
        return false;
    }

    public static boolean isPneumaticArmorPiece(EntityPlayer player, EntityEquipmentSlot slot) {
        return player.func_184582_a(slot).func_77973_b() instanceof ItemPneumaticArmor;
    }

    public int getBaseVolume() {
        return ARMOR_VOLUMES[this.field_77881_a.func_188454_b()];
    }

    @Nullable
    public String getArmorTexture(ItemStack stack, Entity entity, EntityEquipmentSlot slot, String type) {
        return slot == EntityEquipmentSlot.LEGS ? "pneumaticcraft:textures/armor/pneumatic_2.png" : "pneumaticcraft:textures/armor/pneumatic_1.png";
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        ItemPneumatic.addStandardTooltip(stack, worldIn, tooltip, flagIn);
        if (this.field_77881_a == EntityEquipmentSlot.HEAD) {
            this.addHelmetInformation(stack, worldIn, tooltip, flagIn);
        }
    }

    private void addHelmetInformation(ItemStack stack, World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        BlockPos pos;
        ItemStack searchedStack;
        if (stack.func_77942_o() && stack.func_77978_p().func_74762_e("theoneprobe") == 1) {
            tooltip.add(TextFormatting.BLUE + "The One Probe installed");
        }
        if (!(searchedStack = ItemPneumaticArmor.getSearchedStack(stack)).func_190926_b()) {
            for (int i = 0; i < tooltip.size(); ++i) {
                if (!tooltip.get(i).contains("Item Search")) continue;
                tooltip.set(i, tooltip.get(i) + " (searching " + searchedStack.func_82833_r() + ")");
                break;
            }
        }
        if ((pos = ItemPneumaticArmor.getCoordTrackerPos(stack, worldIn)) != null) {
            RenderCoordWireframe.addInfo(tooltip, worldIn, pos);
        }
    }

    public boolean func_82789_a(ItemStack par1ItemStack, ItemStack par2ItemStack) {
        return false;
    }

    static void initApplicableUpgrades() {
        for (int i = 0; i < 4; ++i) {
            applicableUpgrades.add(new HashSet());
        }
        for (EntityEquipmentSlot slot : UpgradeRenderHandlerList.ARMOR_SLOTS) {
            Set<Item> upgrades = applicableUpgrades.get(slot.func_188454_b());
            UpgradeRenderHandlerList.instance().getHandlersForSlot(slot).forEach(handler -> Arrays.stream(handler.getRequiredUpgrades()).filter(Objects::nonNull).forEach(upgrades::add));
            ItemPneumaticArmor.addApplicableUpgrade(slot, IItemRegistry.EnumUpgrade.SPEED);
            ItemPneumaticArmor.addApplicableUpgrade(slot, IItemRegistry.EnumUpgrade.VOLUME);
            ItemPneumaticArmor.addApplicableUpgrade(slot, IItemRegistry.EnumUpgrade.ITEM_LIFE);
            ItemPneumaticArmor.addApplicableUpgrade(slot, IItemRegistry.EnumUpgrade.ARMOR);
            ItemPneumaticArmor.addApplicableUpgrade(slot, IItemRegistry.EnumUpgrade.THAUMCRAFT);
        }
        ItemPneumaticArmor.addApplicableUpgrade(EntityEquipmentSlot.HEAD, IItemRegistry.EnumUpgrade.RANGE);
        ItemPneumaticArmor.addApplicableUpgrade(EntityEquipmentSlot.HEAD, IItemRegistry.EnumUpgrade.SECURITY);
        ItemPneumaticArmor.addApplicableUpgrade(EntityEquipmentSlot.CHEST, IItemRegistry.EnumUpgrade.SECURITY);
    }

    private static void addApplicableUpgrade(EntityEquipmentSlot slot, IItemRegistry.EnumUpgrade what) {
        if (what.isDepLoaded()) {
            applicableUpgrades.get(slot.func_188454_b()).add(CraftingRegistrator.getUpgrade(what).func_77973_b());
        }
    }

    @Override
    public Set<Item> getApplicableUpgrades() {
        return applicableUpgrades.get(this.field_77881_a.func_188454_b());
    }

    @Override
    public float getPressure(ItemStack iStack) {
        int volume = UpgradableItemUtils.getUpgrades(IItemRegistry.EnumUpgrade.VOLUME, iStack) * 5000 + this.getBaseVolume();
        int oldVolume = NBTUtil.getInteger(iStack, "volume");
        int currentAir = NBTUtil.getInteger(iStack, "air");
        if (volume < oldVolume) {
            currentAir = currentAir * volume / oldVolume;
            NBTUtil.setInteger(iStack, "air", currentAir);
        }
        if (volume != oldVolume) {
            NBTUtil.setInteger(iStack, "volume", volume);
        }
        return (float)currentAir / (float)volume;
    }

    @Override
    public float maxPressure(ItemStack iStack) {
        return 10.0f;
    }

    @Override
    public int getVolume(ItemStack iStack) {
        return UpgradableItemUtils.getUpgrades(IItemRegistry.EnumUpgrade.VOLUME, iStack) * 5000 + this.getBaseVolume();
    }

    @Override
    public void addAir(ItemStack iStack, int amount) {
        int maxAir = (int)(this.maxPressure(iStack) * (float)this.getVolume(iStack));
        int oldAir = NBTUtil.getInteger(iStack, "air");
        NBTUtil.setInteger(iStack, "air", Math.min(maxAir, Math.max(oldAir + amount, 0)));
    }

    @Override
    public GuiHandler.EnumGuiId getGuiID() {
        return GuiHandler.EnumGuiId.PNEUMATIC_ARMOR;
    }

    @Override
    public String getName() {
        return this.func_77658_a() + ".name";
    }

    public ISpecialArmor.ArmorProperties getProperties(EntityLivingBase player, @Nonnull ItemStack armor, DamageSource source, double damage, int slot) {
        int maxAbsorb = armor.func_77958_k() + 1 - armor.func_77952_i();
        float ratio = source.func_94541_c() ? 0.18f : (float)((ItemArmor)armor.func_77973_b()).field_77879_b / 30.0f;
        ISpecialArmor.ArmorProperties ap = new ISpecialArmor.ArmorProperties(1, (double)ratio, maxAbsorb);
        int armorUpgrades = Math.min(6, UpgradableItemUtils.getUpgrades(IItemRegistry.EnumUpgrade.ARMOR, armor));
        ap.Armor = (float)armorUpgrades * (slot == 2 ? 1.0f : 0.5f);
        ap.Toughness = Math.min(2.0f, (float)armorUpgrades * 0.5f);
        return ap;
    }

    public int getArmorDisplay(EntityPlayer player, @Nonnull ItemStack armor, int slot) {
        int armorUpgrades = Math.min(6, UpgradableItemUtils.getUpgrades(IItemRegistry.EnumUpgrade.ARMOR, armor));
        return Math.min(armorUpgrades, 2);
    }

    public void damageArmor(EntityLivingBase entity, @Nonnull ItemStack stack, DamageSource source, int damage, int slot) {
        if (source.func_94541_c()) {
            return;
        }
        ItemStack copy = stack.func_77946_l();
        stack.func_77972_a(damage, entity);
        if (stack.func_190926_b() && entity instanceof EntityPlayer) {
            ItemStack[] upgrades;
            for (ItemStack upgrade : upgrades = UpgradableItemUtils.getUpgradeStacks(copy)) {
                ItemHandlerHelper.giveItemToPlayer((EntityPlayer)((EntityPlayer)entity), (ItemStack)upgrade);
            }
        }
    }

    public static int getIntData(ItemStack stack, String key, int def) {
        if (stack.func_77973_b() instanceof ItemPneumaticArmor && stack.func_77942_o() && stack.func_77978_p().func_150297_b(key, 3)) {
            return stack.func_77978_p().func_74762_e(key);
        }
        return def;
    }

    public static boolean getBooleanData(ItemStack stack, String key, boolean def) {
        if (stack.func_77973_b() instanceof ItemPneumaticArmor && stack.func_77942_o() && stack.func_77978_p().func_150297_b(key, 1)) {
            return stack.func_77978_p().func_74771_c(key) == 1;
        }
        return def;
    }

    @Nonnull
    public static ItemStack getSearchedStack(ItemStack helmetStack) {
        if (helmetStack.func_190926_b() || !NBTUtil.hasTag(helmetStack, NBT_SEARCH_STACK)) {
            return ItemStack.field_190927_a;
        }
        NBTTagCompound tag = NBTUtil.getCompoundTag(helmetStack, NBT_SEARCH_STACK);
        if (tag.func_74762_e("itemID") == -1) {
            return ItemStack.field_190927_a;
        }
        return new ItemStack(Item.func_150899_d((int)tag.func_74762_e("itemID")), 1, tag.func_74762_e("itemDamage"));
    }

    public static BlockPos getCoordTrackerPos(ItemStack helmetStack, World world) {
        if (helmetStack.func_190926_b() || !NBTUtil.hasTag(helmetStack, NBT_COORD_TRACKER)) {
            return null;
        }
        NBTTagCompound tag = NBTUtil.getCompoundTag(helmetStack, NBT_COORD_TRACKER);
        if (tag.func_74762_e("y") == -1 || world.field_73011_w.getDimension() != tag.func_74762_e("dimID")) {
            return null;
        }
        return NBTUtil.getPos(tag);
    }

    public static void setCoordTrackerPos(ItemStack helmetStack, int dimId, BlockPos pos) {
        NBTTagCompound tag = NBTUtil.getCompoundTag(helmetStack, NBT_COORD_TRACKER);
        tag.func_74768_a("dimID", dimId);
        NBTUtil.setPos(tag, (Vec3i)pos);
    }

    public static String getEntityFilter(ItemStack helmetStack) {
        if (helmetStack.func_190926_b() || !NBTUtil.hasTag(helmetStack, NBT_ENTITY_FILTER)) {
            return "";
        }
        return NBTUtil.getString(helmetStack, NBT_ENTITY_FILTER);
    }

    @Override
    public float getFOVModifier(ItemStack stack, EntityPlayer player, EntityEquipmentSlot slot) {
        CommonArmorHandler handler;
        double boost;
        if (slot == EntityEquipmentSlot.LEGS && ConfigHandler.client.leggingsFOVfactor > 0.0 && (boost = (handler = CommonArmorHandler.getHandlerForPlayer()).getSpeedBoostFromLegs()) > 0.0) {
            return 1.0f + (float)(boost * 2.0 * ConfigHandler.client.leggingsFOVfactor);
        }
        return 1.0f;
    }

    private boolean hasThaumcraftUpgradeAndPressure(ItemStack stack) {
        return this.getPressure(stack) > 0.0f && UpgradableItemUtils.getUpgrades(IItemRegistry.EnumUpgrade.THAUMCRAFT, stack) > 0;
    }

    @Optional.Method(modid="thaumcraft")
    public int getVisDiscount(ItemStack stack, EntityPlayer player) {
        return this.hasThaumcraftUpgradeAndPressure(stack) ? VIS_DISCOUNTS[this.field_77881_a.func_188454_b()] : 0;
    }

    @Optional.Method(modid="thaumcraft")
    public boolean showIngamePopups(ItemStack itemstack, EntityLivingBase player) {
        return this.field_77881_a == EntityEquipmentSlot.HEAD && this.hasThaumcraftUpgradeAndPressure(itemstack);
    }

    @Optional.Method(modid="thaumcraft")
    public boolean showNodes(ItemStack itemstack, EntityLivingBase player) {
        return this.field_77881_a == EntityEquipmentSlot.HEAD && this.hasThaumcraftUpgradeAndPressure(itemstack);
    }
}

