/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.sensor.pollSensors.entity;

import java.util.ArrayList;
import java.util.List;
import me.desht.pneumaticcraft.common.sensor.pollSensors.entity.EntityPollSensor;
import me.desht.pneumaticcraft.common.util.EntityFilter;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.util.Rectangle;

public class EntityInRangeSensor
extends EntityPollSensor {
    private EntityFilter filter;

    @Override
    public String getSensorPath() {
        return "Within Range";
    }

    @Override
    public boolean needsTextBox() {
        return true;
    }

    @Override
    public int getRedstoneValue(List<Entity> entities, String textboxText) {
        if (this.filter == null) {
            this.filter = new EntityFilter(textboxText);
        }
        int entitiesFound = 0;
        if (textboxText.equals("")) {
            return Math.min(15, entities.size());
        }
        for (Entity entity : entities) {
            if (!this.filter.test(entity)) continue;
            ++entitiesFound;
        }
        return Math.min(15, entitiesFound);
    }

    @Override
    public List<String> getDescription() {
        ArrayList<String> text = new ArrayList<String>();
        text.add(TextFormatting.BLACK + "Emits a redstone level for every entity within range. You can select a specific entity by filling in its name in the textbox. Hold F1 to get detailed help on entity filter syntax.");
        return text;
    }

    @Override
    public Class getEntityTracked() {
        return Entity.class;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void drawAdditionalInfo(FontRenderer fontRenderer) {
        fontRenderer.func_78276_b("Entity filter", 70, 48, 0x404040);
    }

    @Override
    public Rectangle needsSlot() {
        return null;
    }

    @Override
    public void notifyTextChange(String newText) {
        this.filter = new EntityFilter(newText);
    }
}

