/*
 * Decompiled with CFR 0.152.
 */
package me.paulf.wings.server.item;

import com.google.common.collect.ImmutableSet;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import me.paulf.wings.WingsMod;
import me.paulf.wings.server.apparatus.FlightApparatus;
import me.paulf.wings.server.apparatus.FlightApparatuses;
import me.paulf.wings.server.apparatus.SimpleFlightApparatus;
import me.paulf.wings.server.flight.Flight;
import me.paulf.wings.server.item.WingSettings;
import me.paulf.wings.server.item.WingsDict;
import me.paulf.wings.server.sound.WingsSounds;
import me.paulf.wings.util.CapabilityProviders;
import me.paulf.wings.util.HandlerSlot;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnumEnchantmentType;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;

public final class ItemWings
extends Item {
    private final ImmutableSet<EnumEnchantmentType> allowedEnchantmentTypes;
    private final Consumer<CapabilityProviders.CompositeBuilder> capabilities;
    private WingSettings settings;

    private ItemWings(ImmutableSet<EnumEnchantmentType> allowedEnchantmentTypes, Consumer<CapabilityProviders.CompositeBuilder> capabilities, WingSettings settings) {
        this.allowedEnchantmentTypes = allowedEnchantmentTypes;
        this.capabilities = capabilities;
        this.settings = settings;
    }

    public void setSettings(WingSettings settings) {
        this.settings = settings;
        this.func_77656_e(settings.getItemDurability());
    }

    public EntityEquipmentSlot getEquipmentSlot(ItemStack stack) {
        return EntityEquipmentSlot.CHEST;
    }

    public int func_77619_b() {
        return 1;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return this.allowedEnchantmentTypes.contains((Object)enchantment.field_77351_y);
    }

    public boolean func_82789_a(ItemStack stack, ItemStack ingredient) {
        return WingsDict.test(ingredient, "dustFairy");
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        for (HandlerSlot slot : WingsMod.instance().getWingsAccessor().enumerate((EntityLivingBase)player)) {
            ItemStack split = stack.func_77979_a(1);
            ItemStack remaining = slot.insert(split);
            stack.func_190917_f(remaining.func_190916_E());
            if (remaining.func_190916_E() >= split.func_190916_E()) continue;
            player.func_184185_a(WingsSounds.ITEM_ARMOR_EQUIP_WINGS, 1.0f, 1.0f);
            return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
        }
        return new ActionResult(EnumActionResult.FAIL, (Object)stack);
    }

    public static ItemWings create(Consumer<CapabilityProviders.CompositeBuilder> capabilities, WingSettings attributes) {
        ItemWings wings = new ItemWings((ImmutableSet<EnumEnchantmentType>)ImmutableSet.of((Object)EnumEnchantmentType.ALL, (Object)EnumEnchantmentType.BREAKABLE, (Object)EnumEnchantmentType.WEARABLE), capabilities, attributes);
        wings.func_77625_d(1);
        wings.func_77656_e(attributes.getItemDurability());
        return wings;
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable NBTTagCompound tag) {
        CapabilityProviders.CompositeBuilder builder = CapabilityProviders.builder().add(FlightApparatuses.providerBuilder(SimpleFlightApparatus.builder().withFlight((player, wings, direction) -> {
            int distance = Math.round((float)direction.func_72433_c() * 100.0f);
            if (distance > 0) {
                player.func_71020_j((float)distance * this.settings.getFlyingExertion());
            }
        }).withLanding((player, wings, direction) -> player.func_71020_j(this.settings.getLandingExertion())).withUsability((player, wings) -> (!wings.func_77984_f() || wings.func_77952_i() < wings.func_77958_k() - 1) && player.func_71024_bL().func_75116_a() >= this.settings.getRequiredFlightSatiation()).withLandability((player, wings) -> player.func_71024_bL().func_75116_a() >= this.settings.getRequiredLandSatiation()).withVitality(flight -> new FlightApparatus.FlightState((Flight)flight){
            private static final int DAMAGE_RATE = 20;
            private int flightTime;
            final /* synthetic */ Flight val$flight;
            {
                this.val$flight = flight;
            }

            @Override
            public void onUpdate(EntityPlayer player, ItemStack stack) {
                if (this.val$flight.isFlying()) {
                    if (this.flightTime++ % 20 == 19) {
                        stack.func_77972_a(1, (EntityLivingBase)player);
                    }
                } else {
                    this.flightTime = 0;
                }
            }
        }).build()).build());
        this.capabilities.accept(builder);
        return builder.build();
    }
}

