/*
 * Decompiled with CFR 0.152.
 */
package com.zuxelus.energycontrol.items.cards;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.zuxelus.energycontrol.EnergyControl;
import com.zuxelus.energycontrol.EnergyControlConfig;
import com.zuxelus.energycontrol.ServerTickHandler;
import com.zuxelus.energycontrol.api.CardState;
import com.zuxelus.energycontrol.api.ICardReader;
import com.zuxelus.energycontrol.api.IHasBars;
import com.zuxelus.energycontrol.api.IItemCard;
import com.zuxelus.energycontrol.api.ITouchAction;
import com.zuxelus.energycontrol.api.PanelSetting;
import com.zuxelus.energycontrol.api.PanelString;
import com.zuxelus.energycontrol.init.ModItems;
import com.zuxelus.energycontrol.items.ItemUpgrade;
import com.zuxelus.energycontrol.items.cards.ItemCardBase;
import com.zuxelus.energycontrol.items.cards.ItemCardCounter;
import com.zuxelus.energycontrol.items.cards.ItemCardEnergy;
import com.zuxelus.energycontrol.items.cards.ItemCardEnergyArray;
import com.zuxelus.energycontrol.items.cards.ItemCardInventory;
import com.zuxelus.energycontrol.items.cards.ItemCardLiquid;
import com.zuxelus.energycontrol.items.cards.ItemCardLiquidAdvanced;
import com.zuxelus.energycontrol.items.cards.ItemCardLiquidArray;
import com.zuxelus.energycontrol.items.cards.ItemCardReader;
import com.zuxelus.energycontrol.items.cards.ItemCardRedstone;
import com.zuxelus.energycontrol.items.cards.ItemCardText;
import com.zuxelus.energycontrol.items.cards.ItemCardTime;
import com.zuxelus.energycontrol.items.cards.ItemCardToggle;
import com.zuxelus.energycontrol.items.cards.ItemCardVanilla;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public final class ItemCardMain
extends Item
implements IItemCard,
ITouchAction,
IHasBars {
    private static final Map<Integer, ItemCardBase> CARDS = new HashMap<Integer, ItemCardBase>();
    public static final int LOCATION_RANGE = 8;

    public ItemCardMain() {
        this.func_77625_d(1);
        this.func_77627_a(true);
        this.canRepair = false;
        this.func_77637_a(EnergyControl.creativeTab);
    }

    public static boolean isCard(ItemStack stack) {
        return !stack.func_190926_b() && stack.func_77973_b() instanceof IItemCard;
    }

    public void registerCards() {
        ItemCardMain.register(ItemCardEnergy::new);
        ItemCardMain.register(ItemCardCounter::new);
        ItemCardMain.register(ItemCardLiquid::new);
        ItemCardMain.register(ItemCardLiquidAdvanced::new);
        ItemCardMain.register(ItemCardText::new);
        ItemCardMain.register(ItemCardTime::new);
        ItemCardMain.register(ItemCardEnergyArray::new);
        ItemCardMain.register(ItemCardLiquidArray::new);
        ItemCardMain.register(ItemCardToggle::new);
        ItemCardMain.register(ItemCardVanilla::new);
        ItemCardMain.register(ItemCardInventory::new);
        ItemCardMain.register(ItemCardRedstone::new);
    }

    public static void register(Supplier<ItemCardBase> factory) {
        ItemCardBase item = factory.get();
        if (ItemCardMain.checkCard(item)) {
            CARDS.put(item.getDamage(), item);
        }
    }

    private static boolean checkCard(ItemCardBase item) {
        if (!CARDS.containsKey(item.getDamage())) {
            return true;
        }
        if (item.getDamage() <= 49) {
            EnergyControl.logger.warn(String.format("Card %s was not registered. ID %d is already used for standard card.", item.getUnlocalizedName(), item.getDamage()));
        } else {
            EnergyControl.logger.warn(String.format("Card %s was not registered. ID %d is already used for extended card.", item.getUnlocalizedName(), item.getDamage()));
        }
        return false;
    }

    public static boolean containsCard(int i) {
        return CARDS.containsKey(i);
    }

    public String func_77667_c(ItemStack stack) {
        int damage = stack.func_77952_i();
        if (CARDS.containsKey(damage)) {
            return CARDS.get(damage).getUnlocalizedName();
        }
        return "";
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (!this.func_194125_a(tab)) {
            return;
        }
        for (Map.Entry<Integer, ItemCardBase> entry : CARDS.entrySet()) {
            Integer key = entry.getKey();
            items.add((Object)new ItemStack((Item)this, 1, key.intValue()));
        }
    }

    public boolean func_77645_m() {
        return true;
    }

    public boolean func_77616_k(ItemStack stack) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<String> tooltip, ITooltipFlag flag) {
        ItemCardReader reader = new ItemCardReader(stack);
        String title = reader.getTitle();
        if (title != null && !title.isEmpty()) {
            tooltip.add(title);
        }
        switch (stack.func_77952_i()) {
            case 18: 
            case 19: {
                return;
            }
            case 10: 
            case 11: 
            case 12: {
                tooltip.add(I18n.func_135052_a((String)"msg.ec.cards", (Object[])new Object[]{reader.getCardCount()}));
                return;
            }
            case 13: {
                tooltip.add(I18n.func_135052_a((String)"msg.ec.touch_card", (Object[])new Object[0]));
            }
        }
        BlockPos target = reader.getTarget();
        if (target != null) {
            tooltip.add(String.format("x: %d, y: %d, z: %d", target.func_177958_n(), target.func_177956_o(), target.func_177952_p()));
        }
    }

    public static List<PanelString> getStringData(int settings, ItemCardReader reader, boolean isServer, boolean showLabels) {
        if (CARDS.containsKey(reader.getCardType())) {
            return CARDS.get(reader.getCardType()).getStringData(settings, reader, isServer, showLabels);
        }
        return null;
    }

    public static CardState updateCardNBT(ItemStack stack, World world, BlockPos pos, ICardReader reader, ItemStack upgradeStack) {
        int upgradeCountRange = 0;
        if (upgradeStack != ItemStack.field_190927_a && upgradeStack.func_77973_b() instanceof ItemUpgrade && upgradeStack.func_77952_i() == 0) {
            upgradeCountRange = upgradeStack.func_190916_E();
        }
        boolean needUpdate = true;
        int range = 8 * (int)Math.pow(2.0, Math.min(upgradeCountRange, 7));
        CardState state = CardState.INVALID_CARD;
        IItemCard card = (IItemCard)stack.func_77973_b();
        if (!EnergyControlConfig.disableRangeCheck && card.isRemoteCard(stack)) {
            BlockPos target = reader.getTarget();
            if (target != null) {
                int dx = target.func_177958_n() - pos.func_177958_n();
                int dy = target.func_177956_o() - pos.func_177956_o();
                int dz = target.func_177952_p() - pos.func_177952_p();
                if (Math.abs(dx) > range || Math.abs(dy) > range || Math.abs(dz) > range) {
                    needUpdate = false;
                    state = CardState.OUT_OF_RANGE;
                }
            } else {
                needUpdate = false;
            }
        }
        if (needUpdate) {
            state = card.update(world, reader, range, pos);
        }
        reader.setState(state);
        return state;
    }

    public static Optional<ItemCardBase> getCardById(int id) {
        return Optional.ofNullable(CARDS.get(id));
    }

    @Override
    public CardState update(World world, ICardReader reader, int range, BlockPos pos) {
        return ItemCardMain.getCardById(reader.getCardType()).map(card -> card.update(world, reader, range, pos)).orElse(null);
    }

    @Override
    public List<PanelString> getStringData(int settings, ICardReader reader, boolean isServer, boolean showLabels) {
        return ItemCardMain.getCardById(reader.getCardType()).map(card -> card.getStringData(settings, reader, isServer, showLabels)).orElseGet(Collections::emptyList);
    }

    @Override
    public List<PanelSetting> getSettingsList(ItemStack stack) {
        return ItemCardMain.getCardById(stack.func_77952_i()).map(ItemCardBase::getSettingsList).orElse(null);
    }

    @Override
    public boolean isRemoteCard(ItemStack stack) {
        return ItemCardMain.getCardById(stack.func_77952_i()).map(ItemCardBase::isRemoteCard).orElse(false);
    }

    @Override
    public boolean enableTouch(ItemStack stack) {
        return ItemCardMain.getCardById(stack.func_77952_i()).map(card -> card instanceof ITouchAction).orElse(false);
    }

    @Override
    public boolean runTouchAction(World world, ICardReader reader, ItemStack stack) {
        return ItemCardMain.getCardById(reader.getCardType()).filter(card -> card instanceof ITouchAction).map(card -> ((ITouchAction)((Object)card)).runTouchAction(world, reader, stack)).orElse(false);
    }

    @Override
    public void renderImage(TextureManager manager, ICardReader reader) {
        ItemCardMain.getCardById(reader.getCardType()).filter(card -> card instanceof ITouchAction).ifPresent(card -> ((ITouchAction)((Object)card)).renderImage(manager, reader));
    }

    @Override
    public boolean enableBars(ItemStack stack) {
        return ItemCardMain.getCardById(stack.func_77952_i()).map(card -> card instanceof IHasBars).orElse(false);
    }

    @Override
    public void renderBars(TextureManager manager, double displayWidth, double displayHeight, ICardReader reader) {
        ItemCardMain.getCardById(reader.getCardType()).filter(card -> card instanceof IHasBars).ifPresent(card -> ((IHasBars)((Object)card)).renderBars(manager, displayWidth, displayHeight, reader));
    }

    public static void registerModels() {
        for (Map.Entry<Integer, ItemCardBase> entry : CARDS.entrySet()) {
            Integer key = entry.getKey();
            if (key > 49) continue;
            ModItems.registerItemModel(ModItems.itemCard, key, CARDS.get(key).getName());
        }
    }

    public static void registerExtendedModels() {
        for (Map.Entry<Integer, ItemCardBase> entry : CARDS.entrySet()) {
            Integer key = entry.getKey();
            if (key <= 49) continue;
            ModItems.registerExternalItemModel(ModItems.itemCard, key, CARDS.get(key).getName());
        }
    }

    public static Set<Integer> getCardIds() {
        return CARDS.keySet();
    }

    public static void sendCardToWS(List<PanelString> list, ICardReader reader) {
        if (EnergyControlConfig.webSocket.wsHost.isEmpty()) {
            return;
        }
        String id = reader.getId();
        JsonObject json = new JsonObject();
        json.addProperty("id", id);
        JsonArray array = new JsonArray();
        for (PanelString panelString : list) {
            JsonObject line = new JsonObject();
            if (panelString.textLeft != null) {
                line.addProperty("left", panelString.textLeft);
                line.addProperty("left_color", (Number)panelString.colorLeft);
            }
            if (panelString.textCenter != null) {
                line.addProperty("center", panelString.textCenter);
                line.addProperty("center_color", (Number)panelString.colorCenter);
            }
            if (panelString.textRight != null) {
                line.addProperty("right", panelString.textRight);
                line.addProperty("right_color", (Number)panelString.colorRight);
            }
            array.add((JsonElement)line);
        }
        json.add("lines", (JsonElement)array);
        ServerTickHandler.instance.cards.put(id, json);
    }
}

