/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api.gas;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import mekanism.api.gas.Gas;
import net.minecraft.client.Minecraft;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.LoaderState;
import net.minecraftforge.fml.relauncher.Side;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class GasRegistry {
    private static ArrayList<Gas> registeredGasses = new ArrayList();
    private static Logger LOG = LogManager.getLogger((String)"Mekanism GasRegistry");

    public static Gas register(Gas gas) {
        if (gas == null) {
            return null;
        }
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT && GasRegistry.hasAlreadyStitched()) {
            gas.updateIcon(Minecraft.func_71410_x().func_147117_R());
            if (gas.getSpriteRaw() == null) {
                LOG.error("Gas {} registered post texture stitch without valid sprite!", (Object)gas.getName());
            }
        }
        registeredGasses.add(gas);
        return GasRegistry.getGas(gas.getName());
    }

    public static Gas getGas(int id) {
        if (id == -1) {
            return null;
        }
        return registeredGasses.get(id);
    }

    public static Gas getGas(Fluid f) {
        for (Gas gas : GasRegistry.getRegisteredGasses()) {
            if (!gas.hasFluid() || gas.getFluid() != f) continue;
            return gas;
        }
        return null;
    }

    public static boolean containsGas(String name) {
        return GasRegistry.getGas(name) != null;
    }

    public static List<Gas> getRegisteredGasses() {
        return new ArrayList<Gas>(registeredGasses);
    }

    public static Gas getGas(String name) {
        name = name.toLowerCase(Locale.ROOT);
        for (Gas gas : registeredGasses) {
            if (!gas.getName().toLowerCase(Locale.ROOT).equals(name)) continue;
            return gas;
        }
        return null;
    }

    public static int getGasID(Gas gas) {
        if (gas == null || !GasRegistry.containsGas(gas.getName())) {
            return -1;
        }
        return registeredGasses.indexOf(gas);
    }

    private static boolean hasAlreadyStitched() {
        return Loader.instance().getLoaderState().ordinal() > LoaderState.PREINITIALIZATION.ordinal();
    }
}

