/*
 * Decompiled with CFR 0.152.
 */
package info.loenwind.autosave;

import info.loenwind.autosave.Registry;
import info.loenwind.autosave.engine.StorableEngine;
import info.loenwind.autosave.exceptions.NoHandlerFoundException;
import info.loenwind.autosave.util.NBTAction;
import info.loenwind.autosave.util.NullHelper;
import java.util.EnumSet;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTTagCompound;

public class Reader {
    public static <T> void read(Registry registry, Set<NBTAction> phase, NBTTagCompound tag, T object) {
        try {
            StorableEngine.read(registry, phase, tag, object);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (NoHandlerFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> void read(@Nullable Set<NBTAction> phase, @Nullable NBTTagCompound tag, T object) {
        Reader.read(Registry.GLOBAL_REGISTRY, NullHelper.notnull(phase, "Missing phase"), NullHelper.notnull(tag, "Missing NBT"), object);
    }

    public static <T> void read(Registry registry, NBTAction phase, @Nullable NBTTagCompound tag, T object) {
        Reader.read(registry, (Set<NBTAction>)NullHelper.notnullJ(EnumSet.of(phase), "EnumSet.of()"), NullHelper.notnull(tag, "Missing NBT"), object);
    }

    public static <T> void read(NBTAction phase, @Nullable NBTTagCompound tag, T object) {
        Reader.read(Registry.GLOBAL_REGISTRY, (Set<NBTAction>)NullHelper.notnullJ(EnumSet.of(phase), "EnumSet.of()"), NullHelper.notnull(tag, "Missing NBT"), object);
    }

    public static <T> void read(Registry registry, @Nullable NBTTagCompound tag, T object) {
        Reader.read(registry, (Set<NBTAction>)NullHelper.notnullJ(EnumSet.allOf(NBTAction.class), "EnumSet.allOf()"), NullHelper.notnull(tag, "Missing NBT"), object);
    }

    public static <T> void read(@Nullable NBTTagCompound tag, T object) {
        Reader.read(Registry.GLOBAL_REGISTRY, (Set<NBTAction>)NullHelper.notnullJ(EnumSet.allOf(NBTAction.class), "EnumSet.allOf()"), NullHelper.notnull(tag, "Missing NBT"), object);
    }

    @Nullable
    public static <T> T readField(@Nullable NBTTagCompound tag, @Nullable Class<T> fieldClass, @Nullable String fieldName, @Nullable T object) {
        try {
            return StorableEngine.getSingleField(Registry.GLOBAL_REGISTRY, (Set<NBTAction>)NullHelper.notnullJ(EnumSet.allOf(NBTAction.class), "EnumSet.allOf()"), NullHelper.notnull(tag, "Missing NBT"), NullHelper.notnull(fieldName, "Missing field name"), NullHelper.notnull(fieldClass, "Missing field class"), object);
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
        catch (NoHandlerFoundException e) {
            throw new RuntimeException(e);
        }
    }
}

