/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.util.bbcode.node;

import net.malisis.core.util.bbcode.node.BBNode;
import net.malisis.core.util.bbcode.render.BBRenderElement;
import net.minecraft.util.text.TextFormatting;

public class BBStyleNode
extends BBNode {
    protected TextFormatting format;

    public BBStyleNode(String tag) {
        super(tag);
        switch (tag) {
            case "b": {
                this.format = TextFormatting.BOLD;
                break;
            }
            case "i": {
                this.format = TextFormatting.ITALIC;
                break;
            }
            case "u": {
                this.format = TextFormatting.UNDERLINE;
                break;
            }
            case "s": {
                this.format = TextFormatting.STRIKETHROUGH;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid tag for BBStyleNode : " + tag);
            }
        }
    }

    public TextFormatting getEcf() {
        return this.format;
    }

    public String toFormattedString() {
        return this.format.toString();
    }

    @Override
    public BBStyleNode copy() {
        return new BBStyleNode(this.tag);
    }

    @Override
    public void clean() {
        BBStyleNode node = this.getChildStyleNode(this.tag);
        if (node != null && node.getParent() != null) {
            for (BBNode n : node) {
                node.getParent().insertBefore(n, node);
            }
            node.getParent().remove(node);
        }
        super.clean();
    }

    @Override
    public void apply(BBRenderElement element) {
        element.styles.add(this.format);
    }
}

