/*
 * Decompiled with CFR 0.152.
 */
package cassiokf.industrialrenewal.blocks.industrialfloor;

import cassiokf.industrialrenewal.blocks.industrialfloor.BlockIndustrialFloor;
import cassiokf.industrialrenewal.blocks.pipes.BlockEnergyCable;
import cassiokf.industrialrenewal.init.ModBlocks;
import cassiokf.industrialrenewal.util.Utils;
import cassiokf.industrialrenewal.util.enums.EnumEnergyCableType;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.property.ExtendedBlockState;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;

public class BlockFloorCable
extends BlockEnergyCable {
    public BlockFloorCable(EnumEnergyCableType type, String name, CreativeTabs tab) {
        super(type, name, tab);
    }

    @Override
    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer entity, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        return false;
    }

    @Override
    protected BlockStateContainer func_180661_e() {
        IProperty[] listedProperties = new IProperty[]{};
        IUnlistedProperty[] unlistedProperties = new IUnlistedProperty[]{MASTER, SOUTH, NORTH, EAST, WEST, UP, DOWN, CSOUTH, CNORTH, CEAST, CWEST, CUP, CDOWN, WSOUTH, WNORTH, WEAST, WWEST, WUP, WDOWN};
        return new ExtendedBlockState((Block)this, listedProperties, unlistedProperties);
    }

    @Override
    public IBlockState getExtendedState(IBlockState state, IBlockAccess world, BlockPos pos) {
        if (state instanceof IExtendedBlockState) {
            IExtendedBlockState eState = (IExtendedBlockState)super.getExtendedState(state, world, pos);
            return eState.withProperty(WSOUTH, (Object)BlockIndustrialFloor.canConnectTo(world, pos, EnumFacing.SOUTH)).withProperty(WNORTH, (Object)BlockIndustrialFloor.canConnectTo(world, pos, EnumFacing.NORTH)).withProperty(WEAST, (Object)BlockIndustrialFloor.canConnectTo(world, pos, EnumFacing.EAST)).withProperty(WWEST, (Object)BlockIndustrialFloor.canConnectTo(world, pos, EnumFacing.WEST)).withProperty(WUP, (Object)BlockIndustrialFloor.canConnectTo(world, pos, EnumFacing.UP)).withProperty(WDOWN, (Object)BlockIndustrialFloor.canConnectTo(world, pos, EnumFacing.DOWN));
        }
        return state;
    }

    public Item func_180660_a(IBlockState state, Random par2Random, int par3) {
        return new ItemStack(ItemBlock.func_150898_a((Block)ModBlocks.blockIndFloor)).func_77973_b();
    }

    public void func_176206_d(World world, BlockPos pos, IBlockState state) {
        BlockEnergyCable block;
        switch (this.type) {
            default: {
                block = ModBlocks.energyCableLV;
                break;
            }
            case MV: {
                block = ModBlocks.energyCableMV;
                break;
            }
            case HV: {
                block = ModBlocks.energyCableHV;
            }
        }
        ItemStack itemst = new ItemStack(ItemBlock.func_150898_a((Block)block));
        if (!world.field_72995_K) {
            Utils.spawnItemStack(world, pos, itemst);
        }
        super.func_176206_d(world, pos, state);
    }

    public ItemStack func_185473_a(World worldIn, BlockPos pos, IBlockState state) {
        return new ItemStack(ItemBlock.func_150898_a((Block)ModBlocks.blockIndFloor));
    }

    @Override
    public void func_185477_a(IBlockState state, World worldIn, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, @Nullable Entity entityIn, boolean p_185477_7_) {
        BlockFloorCable.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)state.func_185890_d((IBlockAccess)worldIn, pos));
    }

    @Override
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return field_185505_j;
    }

    @Deprecated
    public boolean func_185481_k(IBlockState state) {
        return true;
    }

    public boolean isSideSolid(IBlockState base_state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return side.equals((Object)EnumFacing.UP);
    }

    @Override
    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        if (face == EnumFacing.UP || face == EnumFacing.DOWN) {
            return BlockFaceShape.SOLID;
        }
        return BlockFaceShape.UNDEFINED;
    }
}

