/*
 * Decompiled with CFR 0.152.
 */
package cassiokf.industrialrenewal.util;

import cassiokf.industrialrenewal.tileentity.tubes.TileEntityMultiBlocksTube;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class MultiBlockHelper {
    public static List<Integer> outputEnergy(TileEntityMultiBlocksTube machine, int maxReceive, int maxEnergyCanTransport, boolean simulate, World world) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        int quantity = machine.getMachineContainers().size();
        if (quantity > 0 && maxReceive > 0) {
            list = MultiBlockHelper.moveEnergy(machine, maxReceive, maxEnergyCanTransport, simulate);
        } else {
            list.add(0);
            list.add(0);
        }
        return list;
    }

    public static List<Integer> outputFluid(TileEntityMultiBlocksTube machine, FluidStack resource, int maxFluidCanTransport, boolean doFill, World world) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        int quantity = machine.getMachineContainers().size();
        if (quantity > 0 && resource != null && resource.amount > 0) {
            list = MultiBlockHelper.moveFluid(machine, resource, maxFluidCanTransport, doFill);
        } else {
            list.add(0);
            list.add(0);
        }
        return list;
    }

    private static List<Integer> moveFluid(TileEntityMultiBlocksTube machine, FluidStack resource, int maxFluidCanTransport, boolean doFill) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        list.add(0);
        list.add(0);
        Map<TileEntity, EnumFacing> mapPosSet = machine.getMachineContainers();
        int validOutputs = MultiBlockHelper.getFluidMaxOutPutCount(resource, machine, maxFluidCanTransport, mapPosSet);
        if (validOutputs == 0) {
            return list;
        }
        list.add(1, validOutputs);
        FluidStack realMaxOutput = new FluidStack(resource.getFluid(), Math.min(resource.amount / validOutputs, maxFluidCanTransport));
        int out = 0;
        for (TileEntity te : mapPosSet.keySet()) {
            EnumFacing face;
            IFluidHandler tankStorage;
            if (te == null || (tankStorage = (IFluidHandler)te.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, face = mapPosSet.get(te).func_176734_d())) == null || tankStorage.getTankProperties() == null || tankStorage.getTankProperties().length <= 0 || !tankStorage.getTankProperties()[0].canFill()) continue;
            realMaxOutput.amount = machine.getLimitedValueForOutPut(realMaxOutput.amount, maxFluidCanTransport, te, !doFill);
            if (realMaxOutput.amount <= 0) continue;
            int fluid = tankStorage.fill(realMaxOutput, doFill);
            out += fluid;
        }
        list.add(0, out);
        return list;
    }

    private static List<Integer> moveEnergy(TileEntityMultiBlocksTube machine, int amount, int maxEnergyCanTransport, boolean simulate) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        list.add(0);
        list.add(0);
        Map<TileEntity, EnumFacing> mapPosSet = machine.getMachineContainers();
        if (mapPosSet == null || mapPosSet.isEmpty()) {
            return list;
        }
        int validOutputs = MultiBlockHelper.getEnergyMaxOutPutCount(machine, maxEnergyCanTransport, mapPosSet);
        if (validOutputs == 0) {
            return list;
        }
        list.add(1, validOutputs);
        int realMaxOutput = Math.min(amount / validOutputs, maxEnergyCanTransport);
        int out = 0;
        for (TileEntity te : mapPosSet.keySet()) {
            EnumFacing face;
            IEnergyStorage energyStorage;
            if (te == null || mapPosSet.get(te) == null || (energyStorage = (IEnergyStorage)te.getCapability(CapabilityEnergy.ENERGY, face = mapPosSet.get(te).func_176734_d())) == null || !energyStorage.canReceive() || (realMaxOutput = machine.getLimitedValueForOutPut(realMaxOutput, maxEnergyCanTransport, te, simulate)) <= 0) continue;
            int energy = energyStorage.receiveEnergy(realMaxOutput, simulate);
            out += energy;
        }
        list.add(0, out);
        return list;
    }

    public static int getFluidMaxOutPutCount(FluidStack resource, TileEntityMultiBlocksTube machine, int maxFluidCanTransport, Map<TileEntity, EnumFacing> mapPosSet) {
        int canAccept = 0;
        for (TileEntity te : mapPosSet.keySet()) {
            int fluid;
            EnumFacing face;
            IFluidHandler tankStorage;
            if (te == null || !mapPosSet.containsKey(te) || (tankStorage = (IFluidHandler)te.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, face = mapPosSet.get(te).func_176734_d())) == null || tankStorage.getTankProperties() == null || tankStorage.getTankProperties().length <= 0 || !tankStorage.getTankProperties()[0].canFill()) continue;
            FluidStack realMaxOutput = resource.copy();
            realMaxOutput.amount = machine.getLimitedValueForOutPut(realMaxOutput.amount, maxFluidCanTransport, te, true);
            if (realMaxOutput.amount <= 0 || (fluid = tankStorage.fill(realMaxOutput, false)) <= 0) continue;
            ++canAccept;
        }
        return canAccept;
    }

    private static int getEnergyMaxOutPutCount(TileEntityMultiBlocksTube machine, int maxEnergyCanTransport, Map<TileEntity, EnumFacing> mapPosSet) {
        int canAccept = 0;
        int realMaxOutput = maxEnergyCanTransport;
        for (TileEntity te : mapPosSet.keySet()) {
            int energy;
            EnumFacing face;
            IEnergyStorage energyStorage;
            if (te == null || !mapPosSet.containsKey(te) || (energyStorage = (IEnergyStorage)te.getCapability(CapabilityEnergy.ENERGY, face = mapPosSet.get(te).func_176734_d())) == null || !energyStorage.canReceive() || (realMaxOutput = machine.getLimitedValueForOutPut(realMaxOutput, maxEnergyCanTransport, te, true)) <= 0 || (energy = energyStorage.receiveEnergy(realMaxOutput, true)) <= 0) continue;
            ++canAccept;
        }
        return canAccept;
    }
}

