/*
 * Decompiled with CFR 0.152.
 */
package com.setycz.chickens.jei.laying;

import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IDrawableAnimated;
import mezz.jei.api.gui.IDrawableStatic;
import mezz.jei.api.gui.IGuiItemStackGroup;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeWrapper;
import mezz.jei.util.Translator;
import net.minecraft.client.Minecraft;
import net.minecraft.util.ResourceLocation;

public class LayingRecipeCategory
implements IRecipeCategory {
    public static final String UID = "chickens.Laying";
    private final IDrawableStatic background;
    private final IDrawableAnimated arrow;
    private final String title = Translator.translateToLocal((String)"gui.laying");
    private final IDrawableStatic icon;

    public LayingRecipeCategory(IGuiHelper guiHelper) {
        ResourceLocation location = new ResourceLocation("chickens", "textures/gui/laying.png");
        this.background = guiHelper.createDrawable(location, 0, 0, 82, 54);
        IDrawableStatic arrowDrawable = guiHelper.createDrawable(location, 82, 0, 13, 10);
        this.arrow = guiHelper.createAnimatedDrawable(arrowDrawable, 200, IDrawableAnimated.StartDirection.LEFT, false);
        ResourceLocation iconLocation = new ResourceLocation("chickens", "textures/gui/laying_icon.png");
        this.icon = guiHelper.createDrawable(iconLocation, 0, 0, 16, 16);
    }

    public String getUid() {
        return UID;
    }

    public String getTitle() {
        return this.title;
    }

    public IDrawable getBackground() {
        return this.background;
    }

    @Nullable
    public IDrawable getIcon() {
        return this.icon;
    }

    public void drawExtras(Minecraft minecraft) {
        this.arrow.draw(minecraft, 40, 21);
    }

    public List<String> getTooltipStrings(int mouseX, int mouseY) {
        return Collections.emptyList();
    }

    public void setRecipe(IRecipeLayout recipeLayout, IRecipeWrapper recipeWrapper, IIngredients ingredients) {
        IGuiItemStackGroup guiItemStacks = recipeLayout.getItemStacks();
        int inputSlot = 0;
        guiItemStacks.init(inputSlot, true, 13, 15);
        guiItemStacks.set(ingredients);
        int outputSlot = 1;
        guiItemStacks.init(outputSlot, false, 57, 15);
        guiItemStacks.set(ingredients);
    }

    public String getModName() {
        return "Chickens";
    }
}

