/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.api.farm;

import crazypants.enderio.api.ILocalizable;
import javax.annotation.Nonnull;

public enum FarmNotification implements ILocalizable
{
    OUTPUT_FULL("outputFull"),
    NO_SEEDS("noSeeds", true),
    NO_AXE("noAxe", true),
    NO_HOE("noHoe", true),
    NO_TREETAP("noTreetap", true),
    NO_POWER("noPower"),
    NO_SHEARS("noShears", true),
    NO_CAP("noCapacitor"),
    NO_WATER("noWater");

    @Nonnull
    private final String langStr;
    private final boolean autoCleanup;

    private FarmNotification(String langStr) {
        this(langStr, false);
    }

    private FarmNotification(String langStr, boolean autoCleanup) {
        this.langStr = "enderio.farm.note." + langStr;
        this.autoCleanup = autoCleanup;
    }

    @Override
    @Nonnull
    public String getUnlocalizedName() {
        return this.langStr;
    }

    public boolean isAutoCleanup() {
        return this.autoCleanup;
    }
}

