/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.client.fx;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.lang.reflect.Constructor;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.orecruncher.dsurround.ModOptions;
import org.orecruncher.dsurround.client.fx.BlockEffect;
import org.orecruncher.dsurround.client.fx.BubbleJetEffect;
import org.orecruncher.dsurround.client.fx.DustJetEffect;
import org.orecruncher.dsurround.client.fx.FireFlyEffect;
import org.orecruncher.dsurround.client.fx.FireJetEffect;
import org.orecruncher.dsurround.client.fx.FountainJetEffect;
import org.orecruncher.dsurround.client.fx.SteamJetEffect;
import org.orecruncher.dsurround.client.fx.WaterSplashJetEffect;

public enum BlockEffectType {
    UNKNOWN("UNKNOWN", null){

        @Override
        public boolean isEnabled() {
            return false;
        }
    }
    ,
    SOUND("sound", null){

        @Override
        public boolean isEnabled() {
            return false;
        }
    }
    ,
    FIREFLY("firefly", (Class)FireFlyEffect.class){

        @Override
        public boolean isEnabled() {
            return ModOptions.effects.enableFireflies;
        }
    }
    ,
    STEAM_JET("steam", (Class)SteamJetEffect.class){

        @Override
        public boolean isEnabled() {
            return ModOptions.effects.enableSteamJets;
        }
    }
    ,
    FIRE_JET("fire", (Class)FireJetEffect.class){

        @Override
        public boolean isEnabled() {
            return ModOptions.effects.enableFireJets;
        }
    }
    ,
    BUBBLE_JET("bubble", (Class)BubbleJetEffect.class){

        @Override
        public boolean isEnabled() {
            return ModOptions.effects.enableBubbleJets;
        }
    }
    ,
    DUST_JET("dust", (Class)DustJetEffect.class){

        @Override
        public boolean isEnabled() {
            return ModOptions.effects.enableDustJets;
        }
    }
    ,
    FOUNTAIN_JET("fountain", (Class)FountainJetEffect.class){

        @Override
        public boolean isEnabled() {
            return ModOptions.effects.enableFountainJets;
        }
    }
    ,
    SPLASH_JET("splash", (Class)WaterSplashJetEffect.class){

        @Override
        public boolean isEnabled() {
            return ModOptions.effects.enableWaterSplash;
        }
    };

    private static final Map<String, BlockEffectType> typeMap;
    protected final String name;
    protected Constructor<?> factory;

    @Nonnull
    public static BlockEffectType get(@Nonnull String name) {
        BlockEffectType result = typeMap.get(name);
        return result == null ? UNKNOWN : result;
    }

    private BlockEffectType(String name, Class<?> clazz) {
        this.name = name;
        try {
            if (clazz != null) {
                this.factory = clazz.getConstructor(Integer.TYPE);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Nonnull
    public String getName() {
        return this.name;
    }

    public abstract boolean isEnabled();

    @Nullable
    public BlockEffect getInstance(int chance) {
        if (this.factory != null) {
            try {
                return (BlockEffect)this.factory.newInstance(chance);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return null;
    }

    static {
        typeMap = new Object2ObjectOpenHashMap();
        for (BlockEffectType effect : BlockEffectType.values()) {
            typeMap.put(effect.getName(), effect);
        }
    }
}

