/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.client.handlers.effects;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.orecruncher.dsurround.ModOptions;
import org.orecruncher.dsurround.client.effects.EntityEffect;
import org.orecruncher.dsurround.client.effects.IEntityEffectFactory;
import org.orecruncher.dsurround.client.effects.IEntityEffectFactoryFilter;
import org.orecruncher.dsurround.client.effects.IEntityEffectHandlerState;
import org.orecruncher.dsurround.client.sound.ISoundInstance;
import org.orecruncher.dsurround.client.sound.SoundEffect;
import org.orecruncher.dsurround.registry.item.IItemData;
import org.orecruncher.dsurround.registry.item.ItemUtils;

@SideOnly(value=Side.CLIENT)
public class PlayerToolBarSoundEffect
extends EntityEffect {
    protected final MainHandTracker mainHand;
    protected final HandTracker offHand;
    public static final IEntityEffectFactoryFilter DEFAULT_FILTER = (e, eei) -> eei.effects.contains("toolbar");

    public PlayerToolBarSoundEffect(@Nonnull EntityPlayer player2) {
        this.mainHand = new MainHandTracker(player2);
        this.offHand = new HandTracker(player2);
    }

    @Override
    @Nonnull
    public String name() {
        return "Toolbar";
    }

    @Override
    public void update(@Nonnull Entity subject) {
        if (ModOptions.sound.enableEquipSound) {
            this.mainHand.update(this.getState());
            this.offHand.update(this.getState());
        }
    }

    public static class Factory
    implements IEntityEffectFactory {
        @Override
        @Nonnull
        public List<EntityEffect> create(@Nonnull Entity entity) {
            return ImmutableList.of((Object)new PlayerToolBarSoundEffect((EntityPlayer)entity));
        }
    }

    protected static class MainHandTracker
    extends HandTracker {
        protected int lastSlot;

        public MainHandTracker(@Nonnull EntityPlayer player2) {
            super(player2, EnumHand.MAIN_HAND);
            this.lastSlot = player2.field_71071_by.field_70461_c;
        }

        @Override
        protected boolean triggerNewEquipSound(@Nonnull EntityPlayer player2) {
            return this.lastSlot != player2.field_71071_by.field_70461_c || super.triggerNewEquipSound(player2);
        }

        @Override
        public void update(@Nonnull IEntityEffectHandlerState state) {
            super.update(state);
            state.subject().ifPresent(e -> {
                this.lastSlot = ((EntityPlayer)e).field_71071_by.field_70461_c;
            });
        }
    }

    protected static class HandTracker {
        protected final EnumHand hand;
        protected Item lastHeld;

        public HandTracker(@Nonnull EntityPlayer player2) {
            this(player2, EnumHand.OFF_HAND);
        }

        protected HandTracker(@Nonnull EntityPlayer player2, @Nonnull EnumHand hand) {
            this.hand = hand;
            this.lastHeld = this.getItemForHand(player2, hand);
        }

        protected Item getItemForHand(EntityPlayer player2, EnumHand hand) {
            ItemStack stack = player2.func_184586_b(hand);
            return stack.func_77973_b();
        }

        protected boolean triggerNewEquipSound(@Nonnull EntityPlayer player2) {
            Item heldItem = this.getItemForHand(player2, this.hand);
            return heldItem != this.lastHeld;
        }

        protected void clearState() {
            this.lastHeld = null;
        }

        public void update(@Nonnull IEntityEffectHandlerState state) {
            EntityPlayer player2;
            Optional<Entity> e = state.subject();
            if (e.isPresent() && this.triggerNewEquipSound(player2 = (EntityPlayer)e.get())) {
                this.clearState();
                ItemStack currentStack = player2.func_184586_b(this.hand);
                IItemData data = ItemUtils.getItemData(currentStack.func_77973_b());
                SoundEffect soundEffect = data.getEquipSound(currentStack);
                if (soundEffect != null) {
                    ISoundInstance snd = state.createSound(soundEffect, (Entity)player2);
                    state.playSound(snd);
                    this.lastHeld = currentStack.func_77973_b();
                }
            }
        }
    }
}

