/*
 * Decompiled with CFR 0.152.
 */
package net.mcft.copy.backpacks;

import net.mcft.copy.backpacks.WearableBackpacks;
import net.mcft.copy.backpacks.api.BackpackRegistry;
import net.mcft.copy.backpacks.block.BlockBackpack;
import net.mcft.copy.backpacks.block.entity.TileEntityBackpack;
import net.mcft.copy.backpacks.item.ItemBackpack;
import net.mcft.copy.backpacks.item.recipe.RecipeDyeableItem;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.common.registry.GameRegistry;

public class BackpacksContent {
    public static ItemBackpack BACKPACK;

    public BackpacksContent() {
        if (WearableBackpacks.CONFIG.backpack.enabled.get().booleanValue()) {
            BACKPACK = new ItemBackpack();
        }
    }

    @SubscribeEvent
    public void onRegisterBlocks(RegistryEvent.Register<Block> event) {
        if (BACKPACK != null) {
            event.getRegistry().register(new BlockBackpack().setRegistryName("wearablebackpacks", "backpack"));
            GameRegistry.registerTileEntity(TileEntityBackpack.class, (ResourceLocation)new ResourceLocation("wearablebackpacks", "backpack"));
        }
    }

    @SubscribeEvent
    public void onRegisterItems(RegistryEvent.Register<Item> event) {
        if (BACKPACK != null) {
            event.getRegistry().register(BACKPACK.setRegistryName("wearablebackpacks", "backpack"));
            BackpackRegistry.registerEntity("minecraft:zombie", BackpackRegistry.RenderOptions.DEFAULT);
            BackpackRegistry.registerEntity("minecraft:skeleton", BackpackRegistry.RenderOptions.DEFAULT);
            BackpackRegistry.registerEntity("minecraft:zombie_pigman", BackpackRegistry.RenderOptions.DEFAULT);
            String backpack = BACKPACK.getRegistryName().toString();
            String idDefault = "wearablebackpacks:default";
            String idColored = "wearablebackpacks:colored";
            String lootTable = ItemBackpack.LOOT_TABLE.toString();
            BackpackRegistry.registerBackpack("minecraft:zombie", idDefault, backpack, 800, lootTable, null);
            BackpackRegistry.registerBackpack("minecraft:zombie", idColored, backpack, 8000, lootTable, BackpackRegistry.ColorRange.DEFAULT);
            BackpackRegistry.registerBackpack("minecraft:skeleton", idDefault, backpack, 1200, lootTable, null);
            BackpackRegistry.registerBackpack("minecraft:skeleton", idColored, backpack, 12000, lootTable, BackpackRegistry.ColorRange.DEFAULT);
            BackpackRegistry.registerBackpack("minecraft:zombie_pigman", idColored, backpack, 1000, lootTable, BackpackRegistry.ColorRange.DEFAULT);
            LootTableList.func_186375_a((ResourceLocation)ItemBackpack.LOOT_TABLE);
        }
    }

    public void registerRecipes() {
        ForgeRegistries.RECIPES.register(new RecipeDyeableItem().setRegistryName("wearablebackpacks", "dyeable_item"));
    }
}

