/*
 * Decompiled with CFR 0.152.
 */
package net.mcft.copy.backpacks.config;

import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.mcft.copy.backpacks.BackpacksContent;
import net.mcft.copy.backpacks.WearableBackpacks;
import net.mcft.copy.backpacks.api.BackpackHelper;
import net.mcft.copy.backpacks.config.Setting;
import net.mcft.copy.backpacks.config.SettingBoolean;
import net.mcft.copy.backpacks.config.SettingInteger;
import net.mcft.copy.backpacks.config.custom.SettingBackpackSize;
import net.mcft.copy.backpacks.config.custom.SettingListEntities;
import net.mcft.copy.backpacks.config.custom.SettingPercent;
import net.mcft.copy.backpacks.misc.BackpackSize;
import net.mcft.copy.backpacks.network.MessageSyncSettings;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.network.FMLNetworkEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BackpacksConfig {
    public final Setting<Boolean> equipAsChestArmor = new SettingBoolean(true).setSynced(setting -> {
        BackpackHelper.equipAsChestArmor = (Boolean)setting.get();
    }).setComment("If disabled, backpacks do not take up the player's chest armor equipment slot. Default: true.");
    public final Setting<Boolean> enableEquippedInteraction = new SettingBoolean(true).setComment("If enabled, allows equipped backpacks to be opened by other players by right clicking the target's back. Default: true.");
    public final Setting<Boolean> enableSelfInteraction = new SettingBoolean(false).setSynced().setComment("If enabled, allows players to open their own equipped backpack without requiring it to be placed first using a keybind. Default: false.");
    public final Setting<Boolean> enableMachineInteraction = new SettingBoolean(false).setComment("If enabled, allows machines to interact with placed backpacks. Default: false.");
    public final Setting<Boolean> dropAsBlockOnDeath = new SettingBoolean(true).setComment("If enabled, places equipped backpacks as a block on death, instead of scattering the items all around. Default: true.");
    public BackpackCategory backpack;
    public EntityCategory entity;
    @SideOnly(value=Side.CLIENT)
    public CosmeticCategory cosmetic;
    private final Configuration _config;
    private List<String> _categories = new ArrayList<String>();
    private Map<String, Setting<?>> _settings = new LinkedHashMap();
    @SideOnly(value=Side.CLIENT)
    private boolean _connected;

    public BackpacksConfig(File file) {
        this._config = new Configuration(file);
        this.addSettingsFromClass(this, "general");
        for (Field field : this.getClass().getFields()) {
            if (field.getDeclaringClass() != this.getClass() || !field.getType().getName().endsWith("Category")) continue;
            try {
                String category = field.getName();
                field.set(this, field.getType().getConstructors()[0].newInstance(this));
                this.addSettingsFromClass(field.get(this), category);
                if (this._categories.contains(category)) continue;
                this._categories.add(category);
            }
            catch (IllegalAccessException | InstantiationException | InvocationTargetException ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    private void addSettingsFromClass(Object instance, String category) {
        for (Field field : instance.getClass().getFields()) {
            Setting setting;
            if (!Setting.class.isAssignableFrom(field.getType())) continue;
            try {
                setting = (Setting)field.get(instance);
            }
            catch (IllegalAccessException ex) {
                throw new RuntimeException(ex);
            }
            setting.init(category, field.getName());
            this._settings.put(setting.getFullName(), setting);
        }
    }

    public Setting<?> getSetting(String fullName) {
        return this._settings.get(fullName);
    }

    public Collection<Setting<?>> getSettings() {
        return this._settings.values();
    }

    public Collection<Setting<?>> getSettings(String category) {
        return this.getSettings().stream().filter(setting -> setting.getCategory().equals(category)).collect(Collectors.toList());
    }

    public Collection<Setting<?>> getSettingsGeneral() {
        return this.getSettings("general");
    }

    public List<String> getCategories() {
        return Collections.unmodifiableList(this._categories);
    }

    public void load() {
        if (this._settings == null) {
            return;
        }
        this._config.load();
        if (this._config.getCategory("backpack").containsKey("rows")) {
            int rows = this._config.get("backpack", "rows", 4).getInt();
            this._config.get("backpack", "size", "").set(new BackpackSize(9, rows).toString());
            this._config.getCategory("backpack").remove((Object)"rows");
        }
        this.getSettings().forEach(setting -> setting.loadFromConfiguration(this._config));
    }

    public void save() {
        Map byCategory = this.getSettings().stream().collect(Collectors.groupingBy(setting -> setting.getCategory(), LinkedHashMap::new, Collectors.toList()));
        for (Map.Entry entry : byCategory.entrySet()) {
            String category = (String)entry.getKey();
            if (category.equals("general")) continue;
            List order = ((List)entry.getValue()).stream().map(Setting::getName).collect(Collectors.toList());
            this._config.setCategoryPropertyOrder(category, order);
        }
        this._config.getCategory("general").remove((Object)"enableHelpTooltips");
        this.getSettings().forEach(setting -> setting.saveToConfiguration(this._config));
        this._config.save();
    }

    public void init() {
        this.getSettings().forEach(Setting::update);
    }

    @SubscribeEvent
    public void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (!event.getModID().equals("wearablebackpacks")) {
            return;
        }
        if (event.isWorldRunning()) {
            WearableBackpacks.CHANNEL.sendToAll((IMessage)MessageSyncSettings.create(), BackpacksConfig::isNotServerOwner);
        }
        this.save();
    }

    @SubscribeEvent
    public void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        if (BackpacksConfig.isNotServerOwner(event.player)) {
            return;
        }
        WearableBackpacks.CHANNEL.sendTo(MessageSyncSettings.create(), event.player);
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onDisconnectedFromServer(FMLNetworkEvent.ClientConnectedToServerEvent event) {
        this._connected = true;
    }

    @SideOnly(value=Side.CLIENT)
    public void syncSettings(NBTTagCompound data) {
        if (!this._connected) {
            return;
        }
        for (String key : data.func_150296_c()) {
            NBTBase tag = data.func_74781_a(key);
            Setting<?> setting = this.getSetting(key);
            if (setting == null || !setting.doesSync()) continue;
            setting.readSynced(tag);
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onDisconnectedFromServer(FMLNetworkEvent.ClientDisconnectionFromServerEvent event) {
        if (!this._connected) {
            return;
        }
        this.getSettings().forEach(Setting::resetSynced);
        this._connected = false;
    }

    private static MinecraftServer getServerInstance() {
        return FMLCommonHandler.instance().getMinecraftServerInstance();
    }

    private static boolean isNotServerOwner(EntityPlayer player) {
        return player.func_70005_c_().equalsIgnoreCase(BackpacksConfig.getServerInstance().func_71214_G());
    }

    @SideOnly(value=Side.CLIENT)
    public class CosmeticCategory {
        public final Setting<Double> enchantEffectOpacity = new SettingPercent(0.8).setConfigEntryClass("net.mcft.copy.backpacks.client.gui.config.custom.EntryValueEffectOpacity").setComment("Controls the opacity / visibility of the enchantment effect on equipped and placed backpacks, if present. Default: 80%.");
    }

    public class EntityCategory {
        public final Setting<Boolean> spawnNaturally = new SettingBoolean(true).setComment("Controls whether mobs spawned naturally can randomly be wearing backpacks.");
        public final Setting<Boolean> spawnFromSpawners = new SettingBoolean(false).setComment("Controls whether mobs spawned from spawners can randomly be wearing backpacks.");
        public final SettingListEntities list = new SettingListEntities();
    }

    public class BackpackCategory {
        public final Setting<Boolean> enabled = new SettingBoolean(true).setRequiresMinecraftRestart();
        public final Setting<Integer> durability;
        public final Setting<Integer> armor;
        public final Setting<BackpackSize> size;

        public BackpackCategory() {
            this.durability = new SettingInteger(214).setValidRange(0, 32000).setRequired(this.enabled).setRecommended(BackpacksConfig.this.equipAsChestArmor, "chestplate").setSynced(setting -> BackpacksContent.BACKPACK.func_77656_e((Integer)setting.get())).setComment("Durability of a normal backpack. Set to 0 for unbreakable. Default: 214.");
            this.armor = new SettingInteger(2).setValidRange(0, 20).setRequired(this.enabled).setRecommended(BackpacksConfig.this.equipAsChestArmor, "chestplate").setSynced().setConfigEntryClass("net.mcft.copy.backpacks.client.gui.config.custom.EntryValueArmor").setComment("Armor points of a normal backpack. Valid values are 0 to 20. Default: 2.\nHas no effect if equipAsChestArmor is disabled.");
            this.size = new SettingBackpackSize(9, 4).setRequired(this.enabled).setComment("Storage size of a normal backpack. Valid values are [1x1] to [17x6]. Default: [9x4].\nChanging this doesn't affect placed or equipped backpacks until turned back into an item.");
        }
    }
}

