/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolscontrol.blocks.multitank;

import java.awt.Rectangle;
import mcjty.lib.base.ModBase;
import mcjty.lib.container.EmptyContainer;
import mcjty.lib.gui.GenericGuiContainer;
import mcjty.lib.gui.Window;
import mcjty.lib.gui.layout.HorizontalAlignment;
import mcjty.lib.gui.layout.Layout;
import mcjty.lib.gui.layout.LayoutHint;
import mcjty.lib.gui.layout.PositionalLayout;
import mcjty.lib.gui.layout.VerticalAlignment;
import mcjty.lib.gui.widgets.AbstractContainerWidget;
import mcjty.lib.gui.widgets.BlockRender;
import mcjty.lib.gui.widgets.Label;
import mcjty.lib.gui.widgets.Panel;
import mcjty.lib.gui.widgets.Widget;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.rftoolscontrol.RFToolsControl;
import mcjty.rftoolscontrol.blocks.multitank.MultiTankFluidProperties;
import mcjty.rftoolscontrol.blocks.multitank.MultiTankTileEntity;
import mcjty.rftoolscontrol.network.PacketGetTankFluids;
import mcjty.rftoolscontrol.network.RFToolsCtrlMessages;
import mcjty.rftoolscontrol.setup.GuiProxy;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.inventory.Container;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class GuiMultiTank
extends GenericGuiContainer<MultiTankTileEntity> {
    public static final int WIDTH = 180;
    public static final int HEIGHT = 87;
    private static final ResourceLocation iconLocation = new ResourceLocation("rftoolscontrol", "textures/gui/tank.png");
    private int listDirty = 0;
    private BlockRender[] liquids = new BlockRender[4];
    private Label[] labels = new Label[4];

    public GuiMultiTank(MultiTankTileEntity tileEntity, EmptyContainer container) {
        super((ModBase)RFToolsControl.instance, RFToolsCtrlMessages.INSTANCE, (GenericTileEntity)tileEntity, (Container)container, GuiProxy.GUI_MANUAL_CONTROL, "tank");
        this.field_146999_f = 180;
        this.field_147000_g = 87;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        Panel toplevel = (Panel)new Panel(this.field_146297_k, (Gui)this).setLayout((Layout)new PositionalLayout()).setBackground(iconLocation);
        toplevel.setBounds(new Rectangle(this.field_147003_i, this.field_147009_r, this.field_146999_f, this.field_147000_g));
        for (int i = 0; i < 4; ++i) {
            this.liquids[i] = (BlockRender)new BlockRender(this.field_146297_k, (Gui)this).setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(10, 9 + i * 18, 16, 16));
            toplevel.addChild((Widget)this.liquids[i]);
            this.labels[i] = new Label(this.field_146297_k, (Gui)this);
            ((Label)((Label)this.labels[i].setHorizontalAlignment(HorizontalAlignment.ALIGN_LEFT)).setVerticalAlignment(VerticalAlignment.ALIGN_CENTER)).setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(32, 9 + i * 18, 142, 16));
            toplevel.addChild((Widget)this.labels[i]);
        }
        this.window = new Window((GuiScreen)this, (AbstractContainerWidget)toplevel);
    }

    private void requestLists() {
        RFToolsCtrlMessages.INSTANCE.sendToServer((IMessage)new PacketGetTankFluids(((MultiTankTileEntity)this.tileEntity).func_174877_v()));
    }

    private void requestListsIfNeeded() {
        --this.listDirty;
        if (this.listDirty <= 0) {
            this.requestLists();
            this.listDirty = 10;
        }
    }

    private void updateLiquids() {
        this.requestListsIfNeeded();
        MultiTankFluidProperties[] properties = ((MultiTankTileEntity)this.tileEntity).getProperties();
        for (int i = 0; i < 4; ++i) {
            FluidStack stack;
            if (i < properties.length && properties[i] != null && (stack = properties[i].getContents()) != null) {
                this.liquids[i].setRenderItem((Object)stack);
                this.labels[i].setText(stack.getLocalizedName() + " (" + stack.amount + "mb)");
                continue;
            }
            this.liquids[i].setRenderItem(null);
            this.labels[i].setText("");
        }
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        this.updateLiquids();
        this.drawWindow();
    }
}

