/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.durabilitytooltip;

import com.supermartijn642.durabilitytooltip.DurabilityTooltip;
import com.supermartijn642.durabilitytooltip.DurabilityTooltipConfig;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.item.Item;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber(value={Side.CLIENT})
public class DurabilityTooltipClient {
    private static String lastBlackListConfig = "";
    private static Set<String> blackListedMods = new HashSet<String>();

    public static boolean isBlackListed(Item item) {
        String owningMod = ForgeRegistries.ITEMS.getKey((IForgeRegistryEntry)item).func_110624_b();
        if (!DurabilityTooltipConfig.blackListedMods.get().equals(lastBlackListConfig)) {
            blackListedMods.clear();
            Arrays.stream(DurabilityTooltipConfig.blackListedMods.get().split(",")).map(String::trim).filter(s -> {
                boolean valid = s.matches("[a-z0-9_.-]+");
                if (!valid) {
                    DurabilityTooltip.LOGGER.error("Invalid modid '" + s + "' in config value 'blackListedMods'!");
                }
                return valid;
            }).forEach(blackListedMods::add);
            lastBlackListConfig = DurabilityTooltipConfig.blackListedMods.get();
        }
        return blackListedMods.contains(owningMod);
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void onItemTooltip(ItemTooltipEvent e) {
        if (!(DurabilityTooltipConfig.onlyVanillaTools.get().booleanValue() && !ForgeRegistries.ITEMS.getKey((IForgeRegistryEntry)e.getItemStack().func_77973_b()).func_110624_b().equals("minecraft") || DurabilityTooltipClient.isBlackListed(e.getItemStack().func_77973_b()) || !DurabilityTooltipConfig.showWhenFull.get().booleanValue() && !e.getItemStack().func_77951_h() || !e.getItemStack().func_77984_f() || e.getFlags().func_194127_a() && e.getItemStack().func_77951_h())) {
            int maxDurability = e.getItemStack().func_77958_k();
            int durability = maxDurability - e.getItemStack().func_77952_i();
            DurabilityTooltipConfig.tooltipStyle.get().appendTooltip(e.getToolTip(), durability, maxDurability);
        }
    }
}

