/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.durabilitytooltip;

import com.supermartijn642.durabilitytooltip.DurabilityTooltipConfig;
import com.supermartijn642.durabilitytooltip.TooltipColorStyle;
import java.util.List;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;

public enum TooltipStyle {
    BAR,
    NUMBERS,
    TEXT;


    public void appendTooltip(List<String> tooltips, int durability, int maxDurability) {
        boolean showTooltipHint = DurabilityTooltipConfig.showTooltipHint.get();
        TextFormatting baseColor = DurabilityTooltipConfig.baseTooltipColor.get();
        TooltipColorStyle colorStyle = DurabilityTooltipConfig.tooltipColorStyle.get();
        TextFormatting reactiveColor = colorStyle.getColorForDurability(baseColor, durability, maxDurability);
        switch (this) {
            case BAR: {
                if (showTooltipHint) {
                    tooltips.add(new TextComponentTranslation("durabilitytooltip.info.bar.durability_hint", new Object[0]).func_150255_a(new Style().func_150238_a(baseColor)).func_150254_d());
                }
                int fullCharacters = Math.round(10.0f * (float)durability / (float)maxDurability);
                TextComponentString innerBar = new TextComponentString("");
                for (int character = 0; character < 10; ++character) {
                    innerBar.func_150257_a(new TextComponentTranslation(character < fullCharacters ? "durabilitytooltip.info.bar.full_symbol" : "durabilitytooltip.info.bar.empty_symbol", new Object[0]).func_150255_a(new Style().func_150238_a(reactiveColor)));
                }
                ITextComponent bar = new TextComponentTranslation("durabilitytooltip.info.bar.bar_line", new Object[]{innerBar}).func_150255_a(new Style().func_150238_a(baseColor));
                tooltips.add(bar.func_150254_d());
                break;
            }
            case NUMBERS: {
                ITextComponent durabilityComponent = new TextComponentString(Integer.toString(durability)).func_150255_a(new Style().func_150238_a(reactiveColor));
                ITextComponent maxDurabilityComponent = new TextComponentString(Integer.toString(maxDurability)).func_150255_a(new Style().func_150238_a(colorStyle == TooltipColorStyle.VARYING ? baseColor : reactiveColor));
                ITextComponent numbers = durability == maxDurability ? new TextComponentTranslation("durabilitytooltip.info.numbers.full_durability", new Object[]{maxDurabilityComponent}).func_150255_a(new Style().func_150238_a(baseColor)) : new TextComponentTranslation("durabilitytooltip.info.numbers.damaged", new Object[]{durabilityComponent, maxDurabilityComponent}).func_150255_a(new Style().func_150238_a(baseColor));
                if (showTooltipHint) {
                    numbers = new TextComponentTranslation("durabilitytooltip.info.numbers.durability_hint", new Object[]{numbers}).func_150255_a(new Style().func_150238_a(baseColor));
                }
                tooltips.add(numbers.func_150254_d());
                break;
            }
            case TEXT: {
                String translationKey = durability == maxDurability ? "durabilitytooltip.info.text.full_durability" : ((float)durability >= 0.4f * (float)maxDurability ? "durabilitytooltip.info.text.damaged" : ((float)durability >= 0.1f * (float)maxDurability ? "durabilitytooltip.info.text.severely_damaged" : "durabilitytooltip.info.text.nearly_broken"));
                ITextComponent tooltip = new TextComponentTranslation(translationKey, new Object[0]).func_150255_a(new Style().func_150238_a(reactiveColor));
                if (showTooltipHint) {
                    tooltip = new TextComponentTranslation("durabilitytooltip.info.text.durability_hint", new Object[]{tooltip}).func_150255_a(new Style().func_150238_a(baseColor));
                }
                tooltips.add(tooltip.func_150254_d());
            }
        }
    }
}

