/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.ambientsounds;

import com.creativemd.ambientsounds.AmbientSound;
import io.netty.util.internal.ThreadLocalRandom;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.Sound;
import net.minecraft.client.audio.SoundEventAccessor;
import net.minecraft.client.audio.SoundManager;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import paulscode.sound.Library;
import paulscode.sound.SoundSystem;
import paulscode.sound.SoundSystemConfig;
import paulscode.sound.Source;

public class AmbientSoundEngine {
    private static Field system = ReflectionHelper.findField(SoundManager.class, (String[])new String[]{"sndSystem", "field_148620_e"});
    private static Field loaded = ReflectionHelper.findField(SoundManager.class, (String[])new String[]{"loaded", "field_148617_f"});
    public Library library;
    public SoundManager manager;
    public GameSettings settings;
    private List<AmbientSound.SoundStream> sounds = new ArrayList<AmbientSound.SoundStream>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int playingCount() {
        List<AmbientSound.SoundStream> list = this.sounds;
        synchronized (list) {
            return this.sounds.size();
        }
    }

    public SoundSystem getSystem() {
        try {
            return (SoundSystem)system.get(this.manager);
        }
        catch (IllegalAccessException | IllegalArgumentException exception) {
            return null;
        }
    }

    public AmbientSoundEngine(SoundManager manager, GameSettings settings) {
        this.settings = settings;
        this.manager = manager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void tick() {
        try {
            if (!loaded.getBoolean(this.manager)) {
                return;
            }
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            e.printStackTrace();
        }
        SoundSystem system = this.getSystem();
        if (this.library == null) {
            this.library = (Library)ReflectionHelper.getPrivateValue(SoundSystem.class, (Object)this.getSystem(), (String[])new String[]{"soundLibrary"});
        }
        List<AmbientSound.SoundStream> list = this.sounds;
        synchronized (list) {
            Double mute = null;
            try {
                for (AmbientSound.SoundStream sound : this.sounds) {
                    double soundMute = sound.mute();
                    if (!(soundMute > 0.0) || mute != null && !(mute < soundMute)) continue;
                    mute = soundMute;
                }
                Object object = SoundSystemConfig.THREAD_SYNC;
                synchronized (object) {
                    Iterator<AmbientSound.SoundStream> iterator = this.sounds.iterator();
                    while (iterator.hasNext()) {
                        boolean playing;
                        AmbientSound.SoundStream sound = iterator.next();
                        Source source = this.library.getSource(sound.systemName);
                        if (source == null) {
                            if (!sound.hasPlayedOnce()) continue;
                            playing = false;
                        } else {
                            playing = source.playing();
                        }
                        if (sound.hasPlayedOnce() && !playing) {
                            sound.onFinished();
                            if (source != null) {
                                source.stop();
                            }
                            iterator.remove();
                            continue;
                        }
                        if (!sound.hasPlayedOnce() && playing) {
                            sound.setPlayedOnce();
                        }
                        source.setPitch((float)sound.pitch);
                        if (source.toLoop != sound.loop()) {
                            source.toLoop = sound.loop();
                        }
                        if (mute == null || sound.mute() >= mute) {
                            source.sourceVolume = (float)sound.volume * this.getVolume(SoundCategory.AMBIENT);
                            continue;
                        }
                        source.sourceVolume = (float)(sound.volume * (1.0 - mute)) * this.getVolume(SoundCategory.AMBIENT);
                    }
                }
            }
            catch (ConcurrentModificationException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(AmbientSound.SoundStream sound) {
        SoundSystem system = this.getSystem();
        system.stop(sound.systemName);
        system.removeSource(sound.systemName);
        List<AmbientSound.SoundStream> list = this.sounds;
        synchronized (list) {
            this.sounds.remove(sound);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void play(int offset, AmbientSound.SoundStream stream) {
        try {
            if (!loaded.getBoolean(this.manager)) {
                return;
            }
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            e.printStackTrace();
        }
        SoundSystem system = this.getSystem();
        ResourceLocation resourcelocation = stream.location;
        SoundEventAccessor soundeventaccessor = this.manager.field_148622_c.func_184398_a(resourcelocation);
        if (soundeventaccessor == null) {
            throw new RuntimeException("Missing accessor for " + resourcelocation);
        }
        Sound sound = soundeventaccessor.func_148720_g();
        SoundCategory soundcategory = SoundCategory.AMBIENT;
        float f = 16.0f;
        float f1 = this.getClampedVolume((float)stream.volume);
        float f2 = this.getClampedPitch((float)stream.pitch);
        if (f1 > 0.0f) {
            String s = MathHelper.func_180182_a((Random)ThreadLocalRandom.current()).toString();
            ResourceLocation resourcelocation1 = sound.func_188721_b();
            if (sound.func_188723_h()) {
                system.newStreamingSource(false, s, AmbientSoundEngine.getURLForSoundResource(resourcelocation1), resourcelocation1.toString(), stream.loop(), 0.0f, 0.0f, 0.0f, 0, f);
            } else {
                system.newSource(false, s, AmbientSoundEngine.getURLForSoundResource(resourcelocation1), resourcelocation1.toString(), stream.loop(), 0.0f, 0.0f, 0.0f, 0, f);
            }
            stream.systemName = s;
            system.setPitch(s, f2);
            system.setVolume(s, f1);
            system.play(s);
            stream.onStart();
            List<AmbientSound.SoundStream> list = this.sounds;
            synchronized (list) {
                this.sounds.add(stream);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopAll() {
        List<AmbientSound.SoundStream> list = this.sounds;
        synchronized (list) {
            for (AmbientSound.SoundStream sound : this.sounds) {
                this.stop(sound);
                sound.onFinished();
            }
        }
    }

    private static URL getURLForSoundResource(final ResourceLocation p_148612_0_) {
        String s = String.format("%s:%s:%s", "mcsounddomain", p_148612_0_.func_110624_b(), p_148612_0_.func_110623_a());
        URLStreamHandler urlstreamhandler = new URLStreamHandler(){

            @Override
            protected URLConnection openConnection(URL p_openConnection_1_) {
                return new URLConnection(p_openConnection_1_){

                    @Override
                    public void connect() throws IOException {
                    }

                    @Override
                    public InputStream getInputStream() throws IOException {
                        return Minecraft.func_71410_x().func_110442_L().func_110536_a(p_148612_0_).func_110527_b();
                    }
                };
            }
        };
        try {
            return new URL((URL)null, s, urlstreamhandler);
        }
        catch (MalformedURLException var4) {
            throw new Error("TODO: Sanely handle url exception! :D");
        }
    }

    private float getClampedPitch(float pitch) {
        return MathHelper.func_76131_a((float)pitch, (float)0.5f, (float)2.0f);
    }

    private float getClampedVolume(float volume) {
        return MathHelper.func_76131_a((float)(volume * this.getVolume(SoundCategory.AMBIENT)), (float)0.0f, (float)1.0f);
    }

    private float getVolume(SoundCategory category) {
        return category != null && category != SoundCategory.MASTER ? this.settings.func_186711_a(category) : 1.0f;
    }
}

